/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.jdbc.connection;

import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JdbcConnectionDefinition;

public class JndiConnectionDefinition
extends JdbcConnectionDefinition {
    private String jndiName;
    private String username;
    private String password;
    private String databaseType;

    public JndiConnectionDefinition(String name, String jndiName, String databaseType, String username, String password) {
        super(name);
        if (StringUtils.isEmpty((String)jndiName)) {
            throw new IllegalArgumentException("The provided jndiName can not be empty");
        }
        this.jndiName = jndiName;
        this.databaseType = databaseType;
        this.username = username;
        this.password = password;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JndiConnectionDefinition that = (JndiConnectionDefinition)o;
        if (this.databaseType != null ? !this.databaseType.equals(that.databaseType) : that.databaseType != null) {
            return false;
        }
        if (!this.jndiName.equals(that.jndiName)) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        return !(this.username != null ? !this.username.equals(that.username) : that.username != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.jndiName.hashCode();
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.databaseType != null ? this.databaseType.hashCode() : 0);
        return result;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }
}

