/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.jdbc.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.DriverConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.JndiConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.SimpleSQLReportDataFactory;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.ui.datasources.jdbc.JdbcDataSourceModule;
import org.pentaho.reporting.ui.datasources.jdbc.connection.DriverConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JdbcConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JndiConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.ui.JdbcConnectionPanel;
import org.pentaho.reporting.ui.datasources.jdbc.ui.JdbcDataSourceDialog;
import org.pentaho.reporting.ui.datasources.jdbc.ui.SimpleDataSourceDialogModel;

public class SimpleJdbcDataSourceDialog
extends CommonDialog {
    protected static final Log log = LogFactory.getLog(JdbcDataSourceDialog.class);
    private SimpleDataSourceDialogModel dialogModel;
    private ResourceBundleSupport bundleSupport;
    private DesignTimeContext designTimeContext;
    private JdbcConnectionPanel connectionComponent;

    public SimpleJdbcDataSourceDialog(DesignTimeContext designTimeContext) {
        this.designTimeContext = designTimeContext;
        this.initDialog();
    }

    public SimpleJdbcDataSourceDialog(DesignTimeContext designTimeContext, JDialog parent) {
        super((Dialog)parent);
        this.designTimeContext = designTimeContext;
        this.initDialog();
    }

    public SimpleJdbcDataSourceDialog(DesignTimeContext designTimeContext, JFrame parent) {
        super((Frame)parent);
        this.designTimeContext = designTimeContext;
        this.initDialog();
    }

    public DesignTimeContext getDesignTimeContext() {
        return this.designTimeContext;
    }

    public SimpleSQLReportDataFactory performConfiguration(SimpleSQLReportDataFactory dataFactory) {
        SimpleSQLReportDataFactory newDataFactory;
        this.dialogModel.clear();
        if (dataFactory != null) {
            this.dialogModel.setJdbcPasswordField(dataFactory.getPasswordField());
            this.dialogModel.setJdbcUserField(dataFactory.getUserField());
            ConnectionProvider currentJNDISource = dataFactory.getConnectionProvider();
            JdbcConnectionDefinition definition = this.connectionComponent.createConnectionDefinition(currentJNDISource);
            this.dialogModel.addConnection(definition);
            this.dialogModel.getConnections().setSelectedItem(definition);
        }
        if (!this.performEdit()) {
            return null;
        }
        JdbcConnectionDefinition connectionDefinition = (JdbcConnectionDefinition)this.dialogModel.getConnections().getSelectedItem();
        if (connectionDefinition == null) {
            return null;
        }
        if (connectionDefinition instanceof JndiConnectionDefinition) {
            JndiConnectionDefinition jcd = (JndiConnectionDefinition)connectionDefinition;
            JndiConnectionProvider provider = new JndiConnectionProvider();
            provider.setConnectionPath(jcd.getJndiName());
            provider.setUsername(jcd.getUsername());
            provider.setPassword(jcd.getPassword());
            newDataFactory = new SimpleSQLReportDataFactory((ConnectionProvider)provider);
        } else if (connectionDefinition instanceof DriverConnectionDefinition) {
            DriverConnectionDefinition dcd = (DriverConnectionDefinition)connectionDefinition;
            DriverConnectionProvider provider = new DriverConnectionProvider();
            provider.setDriver(dcd.getDriverClass());
            provider.setUrl(dcd.getConnectionString());
            Properties properties = dcd.getProperties();
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                provider.setProperty(key, properties.getProperty(key));
            }
            newDataFactory = new SimpleSQLReportDataFactory((ConnectionProvider)provider);
        } else {
            return null;
        }
        newDataFactory.setPasswordField(this.dialogModel.getJdbcPasswordField());
        newDataFactory.setUserField(this.dialogModel.getJdbcUserField());
        return newDataFactory;
    }

    private void initDialog() {
        this.dialogModel = new SimpleDataSourceDialogModel();
        this.dialogModel.addPropertyChangeListener(new ConfirmValidateHandler());
        this.bundleSupport = new ResourceBundleSupport(Locale.getDefault(), "org.pentaho.reporting.ui.datasources.jdbc.messages", ObjectUtilities.getClassLoader(JdbcDataSourceModule.class));
        this.connectionComponent = new JdbcConnectionPanel(this.dialogModel, this.designTimeContext);
        this.setTitle(this.bundleSupport.getString("JdbcDataSourceDialog.Title"));
        this.setModal(true);
        super.init();
    }

    protected String getDialogId() {
        return "JdbcDataSourceEditor.Simple";
    }

    protected Component createContentPane() {
        JLabel descriptionLabel = new JLabel(this.bundleSupport.getString("SimpleJdbcDataSourceDialog.DescriptionLabel"));
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.add("Center", descriptionLabel);
        headerPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add("Center", this.connectionComponent);
        contentPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        return contentPanel;
    }

    protected SimpleDataSourceDialogModel getDialogModel() {
        return this.dialogModel;
    }

    protected ResourceBundleSupport getBundleSupport() {
        return this.bundleSupport;
    }

    private class ConfirmValidateHandler
    implements PropertyChangeListener {
        private ConfirmValidateHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SimpleJdbcDataSourceDialog.this.validateInputs(false);
        }
    }
}

