/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.util.CpuTimeTracker;
import org.apache.hadoop.yarn.util.ProcfsBasedProcessTree;
import org.apache.hadoop.yarn.util.ResourceCalculatorPlugin;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LinuxResourceCalculatorPlugin
extends ResourceCalculatorPlugin {
    private static final Log LOG = LogFactory.getLog(LinuxResourceCalculatorPlugin.class);
    private static final String PROCFS_MEMFILE = "/proc/meminfo";
    private static final Pattern PROCFS_MEMFILE_FORMAT = Pattern.compile("^([a-zA-Z]*):[ \t]*([0-9]*)[ \t]kB");
    private static final String MEMTOTAL_STRING = "MemTotal";
    private static final String SWAPTOTAL_STRING = "SwapTotal";
    private static final String MEMFREE_STRING = "MemFree";
    private static final String SWAPFREE_STRING = "SwapFree";
    private static final String INACTIVE_STRING = "Inactive";
    private static final String PROCFS_CPUINFO = "/proc/cpuinfo";
    private static final Pattern PROCESSOR_FORMAT = Pattern.compile("^processor[ \t]:[ \t]*([0-9]*)");
    private static final Pattern FREQUENCY_FORMAT = Pattern.compile("^cpu MHz[ \t]*:[ \t]*([0-9.]*)");
    private static final String PROCFS_STAT = "/proc/stat";
    private static final Pattern CPU_TIME_FORMAT = Pattern.compile("^cpu[ \t]*([0-9]*)[ \t]*([0-9]*)[ \t]*([0-9]*)[ \t].*");
    private CpuTimeTracker cpuTimeTracker;
    private String procfsMemFile;
    private String procfsCpuFile;
    private String procfsStatFile;
    long jiffyLengthInMillis;
    private long ramSize = 0L;
    private long swapSize = 0L;
    private long ramSizeFree = 0L;
    private long swapSizeFree = 0L;
    private long inactiveSize = 0L;
    private int numProcessors = 0;
    private long cpuFrequency = 0L;
    boolean readMemInfoFile = false;
    boolean readCpuInfoFile = false;

    long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public LinuxResourceCalculatorPlugin() {
        this(PROCFS_MEMFILE, PROCFS_CPUINFO, PROCFS_STAT, ProcfsBasedProcessTree.JIFFY_LENGTH_IN_MILLIS);
    }

    public LinuxResourceCalculatorPlugin(String procfsMemFile, String procfsCpuFile, String procfsStatFile, long jiffyLengthInMillis) {
        this.procfsMemFile = procfsMemFile;
        this.procfsCpuFile = procfsCpuFile;
        this.procfsStatFile = procfsStatFile;
        this.jiffyLengthInMillis = jiffyLengthInMillis;
        this.cpuTimeTracker = new CpuTimeTracker(jiffyLengthInMillis);
    }

    private void readProcMemInfoFile() {
        this.readProcMemInfoFile(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProcMemInfoFile(boolean readAgain) {
        if (this.readMemInfoFile && !readAgain) {
            return;
        }
        BufferedReader in = null;
        FileReader fReader = null;
        try {
            fReader = new FileReader(this.procfsMemFile);
            in = new BufferedReader(fReader);
        }
        catch (FileNotFoundException f) {
            return;
        }
        Matcher mat = null;
        try {
            String str = in.readLine();
            while (str != null) {
                mat = PROCFS_MEMFILE_FORMAT.matcher(str);
                if (mat.find()) {
                    if (mat.group(1).equals(MEMTOTAL_STRING)) {
                        this.ramSize = Long.parseLong(mat.group(2));
                    } else if (mat.group(1).equals(SWAPTOTAL_STRING)) {
                        this.swapSize = Long.parseLong(mat.group(2));
                    } else if (mat.group(1).equals(MEMFREE_STRING)) {
                        this.ramSizeFree = Long.parseLong(mat.group(2));
                    } else if (mat.group(1).equals(SWAPFREE_STRING)) {
                        this.swapSizeFree = Long.parseLong(mat.group(2));
                    } else if (mat.group(1).equals(INACTIVE_STRING)) {
                        this.inactiveSize = Long.parseLong(mat.group(2));
                    }
                }
                str = in.readLine();
            }
        }
        catch (IOException io) {
            LOG.warn((Object)("Error reading the stream " + io));
        }
        finally {
            try {
                fReader.close();
                try {
                    in.close();
                }
                catch (IOException i) {
                    LOG.warn((Object)("Error closing the stream " + in));
                }
            }
            catch (IOException i) {
                LOG.warn((Object)("Error closing the stream " + fReader));
            }
        }
        this.readMemInfoFile = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProcCpuInfoFile() {
        if (this.readCpuInfoFile) {
            return;
        }
        BufferedReader in = null;
        FileReader fReader = null;
        try {
            fReader = new FileReader(this.procfsCpuFile);
            in = new BufferedReader(fReader);
        }
        catch (FileNotFoundException f) {
            return;
        }
        Matcher mat = null;
        try {
            this.numProcessors = 0;
            String str = in.readLine();
            while (str != null) {
                mat = PROCESSOR_FORMAT.matcher(str);
                if (mat.find()) {
                    ++this.numProcessors;
                }
                if ((mat = FREQUENCY_FORMAT.matcher(str)).find()) {
                    this.cpuFrequency = (long)(Double.parseDouble(mat.group(1)) * 1000.0);
                }
                str = in.readLine();
            }
        }
        catch (IOException io) {
            LOG.warn((Object)("Error reading the stream " + io));
        }
        finally {
            try {
                fReader.close();
                try {
                    in.close();
                }
                catch (IOException i) {
                    LOG.warn((Object)("Error closing the stream " + in));
                }
            }
            catch (IOException i) {
                LOG.warn((Object)("Error closing the stream " + fReader));
            }
        }
        this.readCpuInfoFile = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProcStatFile() {
        BufferedReader in = null;
        FileReader fReader = null;
        try {
            fReader = new FileReader(this.procfsStatFile);
            in = new BufferedReader(fReader);
        }
        catch (FileNotFoundException f) {
            return;
        }
        Matcher mat = null;
        try {
            String str = in.readLine();
            while (str != null) {
                mat = CPU_TIME_FORMAT.matcher(str);
                if (mat.find()) {
                    long uTime = Long.parseLong(mat.group(1));
                    long nTime = Long.parseLong(mat.group(2));
                    long sTime = Long.parseLong(mat.group(3));
                    this.cpuTimeTracker.updateElapsedJiffies(BigInteger.valueOf(uTime + nTime + sTime), this.getCurrentTime());
                    break;
                }
                str = in.readLine();
            }
        }
        catch (IOException io) {
            LOG.warn((Object)("Error reading the stream " + io));
        }
        finally {
            try {
                fReader.close();
                try {
                    in.close();
                }
                catch (IOException i) {
                    LOG.warn((Object)("Error closing the stream " + in));
                }
            }
            catch (IOException i) {
                LOG.warn((Object)("Error closing the stream " + fReader));
            }
        }
    }

    @Override
    public long getPhysicalMemorySize() {
        this.readProcMemInfoFile();
        return this.ramSize * 1024L;
    }

    @Override
    public long getVirtualMemorySize() {
        this.readProcMemInfoFile();
        return (this.ramSize + this.swapSize) * 1024L;
    }

    @Override
    public long getAvailablePhysicalMemorySize() {
        this.readProcMemInfoFile(true);
        return (this.ramSizeFree + this.inactiveSize) * 1024L;
    }

    @Override
    public long getAvailableVirtualMemorySize() {
        this.readProcMemInfoFile(true);
        return (this.ramSizeFree + this.swapSizeFree + this.inactiveSize) * 1024L;
    }

    @Override
    public int getNumProcessors() {
        this.readProcCpuInfoFile();
        return this.numProcessors;
    }

    @Override
    public long getCpuFrequency() {
        this.readProcCpuInfoFile();
        return this.cpuFrequency;
    }

    @Override
    public long getCumulativeCpuTime() {
        this.readProcStatFile();
        return this.cpuTimeTracker.cumulativeCpuTime.longValue();
    }

    @Override
    public float getCpuUsage() {
        this.readProcStatFile();
        float overallCpuUsage = this.cpuTimeTracker.getCpuTrackerUsagePercent();
        if (overallCpuUsage != -1.0f) {
            overallCpuUsage /= (float)this.getNumProcessors();
        }
        return overallCpuUsage;
    }

    public static void main(String[] args) {
        LinuxResourceCalculatorPlugin plugin = new LinuxResourceCalculatorPlugin();
        System.out.println("Physical memory Size (bytes) : " + plugin.getPhysicalMemorySize());
        System.out.println("Total Virtual memory Size (bytes) : " + plugin.getVirtualMemorySize());
        System.out.println("Available Physical memory Size (bytes) : " + plugin.getAvailablePhysicalMemorySize());
        System.out.println("Total Available Virtual memory Size (bytes) : " + plugin.getAvailableVirtualMemorySize());
        System.out.println("Number of Processors : " + plugin.getNumProcessors());
        System.out.println("CPU frequency (kHz) : " + plugin.getCpuFrequency());
        System.out.println("Cumulative CPU time (ms) : " + plugin.getCumulativeCpuTime());
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("CPU usage % : " + plugin.getCpuUsage());
    }
}

