/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hbase.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceLocator;
import org.pentaho.big.data.kettle.plugins.hbase.input.HBaseInputData;
import org.pentaho.big.data.kettle.plugins.hbase.input.HBaseInputMeta;
import org.pentaho.big.data.kettle.plugins.hbase.mapping.HBaseRowToKettleTuple;
import org.pentaho.big.data.kettle.plugins.hbase.mapping.MappingAdmin;
import org.pentaho.bigdata.api.hbase.ByteConversionUtil;
import org.pentaho.bigdata.api.hbase.HBaseConnection;
import org.pentaho.bigdata.api.hbase.HBaseService;
import org.pentaho.bigdata.api.hbase.Result;
import org.pentaho.bigdata.api.hbase.mapping.Mapping;
import org.pentaho.bigdata.api.hbase.meta.HBaseValueMetaInterface;
import org.pentaho.bigdata.api.hbase.meta.HBaseValueMetaInterfaceFactory;
import org.pentaho.bigdata.api.hbase.table.HBaseTable;
import org.pentaho.bigdata.api.hbase.table.ResultScanner;
import org.pentaho.bigdata.api.hbase.table.ResultScannerBuilder;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;

public class HBaseInput
extends BaseStep
implements StepInterface {
    private final NamedClusterServiceLocator namedClusterServiceLocator;
    protected HBaseInputMeta m_meta;
    protected HBaseInputData m_data;
    private HBaseService hBaseService;
    private HBaseTable m_hbAdminTable;
    private ResultScanner resultScanner;
    private HBaseValueMetaInterfaceFactory hBaseValueMetaInterfaceFactory;
    protected HBaseConnection m_hbAdmin;
    protected ByteConversionUtil m_bytesUtil;
    protected MappingAdmin m_mappingAdmin;
    protected Mapping m_tableMapping;
    protected Map<String, HBaseValueMetaInterface> m_columnsMappedByAlias;
    protected List<HBaseValueMetaInterface> m_userOutputColumns;
    protected HBaseRowToKettleTuple m_tupleHandler;

    public HBaseInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans, NamedClusterServiceLocator namedClusterServiceLocator) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.namedClusterServiceLocator = namedClusterServiceLocator;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (this.first) {
            HBaseTable hBaseTable;
            this.first = false;
            this.m_meta = (HBaseInputMeta)smi;
            this.m_data = (HBaseInputData)sdi;
            try {
                ArrayList connectionMessages = new ArrayList();
                this.hBaseService = (HBaseService)this.namedClusterServiceLocator.getService(this.m_meta.getNamedCluster(), HBaseService.class);
                this.m_hbAdmin = this.hBaseService.getHBaseConnection((VariableSpace)this, this.environmentSubstitute(this.m_meta.getCoreConfigURL()), this.environmentSubstitute(this.m_meta.getDefaultConfigURL()), this.log);
                this.m_bytesUtil = this.hBaseService.getByteConversionUtil();
                this.hBaseValueMetaInterfaceFactory = this.hBaseService.getHBaseValueMetaInterfaceFactory();
                if (connectionMessages.size() > 0) {
                    for (String m : connectionMessages) {
                        this.logBasic(m);
                    }
                }
            }
            catch (Exception ex) {
                throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.UnableToObtainConnection", (String[])new String[0]), (Throwable)ex);
            }
            try {
                this.m_mappingAdmin = new MappingAdmin(this.m_hbAdmin);
            }
            catch (Exception ex) {
                throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.UnableToCreateAMappingAdminConnection", (String[])new String[0]), (Throwable)ex);
            }
            String sourceName = this.environmentSubstitute(this.m_meta.getSourceTableName());
            if (StringUtil.isEmpty((String)sourceName)) {
                throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.TableName.Missing", (String[])new String[0]));
            }
            try {
                hBaseTable = this.m_hbAdmin.getTable(sourceName);
            }
            catch (IOException e) {
                throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.CantGetTable", (String[])new String[]{sourceName}), (Throwable)e);
            }
            try {
                if (!hBaseTable.exists()) {
                    throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.SourceTableDoesNotExist", (String[])new String[]{sourceName}));
                }
                if (hBaseTable.disabled() || !hBaseTable.available()) {
                    throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.SourceTableIsNotAvailable", (String[])new String[]{sourceName}));
                }
            }
            catch (Exception ex) {
                throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.AvailabilityReadinessProblem", (String[])new String[]{sourceName}), (Throwable)ex);
            }
            if (this.m_meta.getMapping() != null && Const.isEmpty((String)this.m_meta.getSourceMappingName())) {
                this.m_tableMapping = this.m_meta.getMapping();
            } else {
                if (Const.isEmpty((String)this.m_meta.getSourceMappingName())) {
                    throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.NoMappingName", (String[])new String[0]));
                }
                try {
                    this.m_tableMapping = this.m_mappingAdmin.getMapping(this.environmentSubstitute(this.m_meta.getSourceTableName()), this.environmentSubstitute(this.m_meta.getSourceMappingName()));
                }
                catch (Exception ex) {
                    throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.UnableToRetrieveMapping", (String[])new String[]{this.environmentSubstitute(this.m_meta.getSourceMappingName()), this.environmentSubstitute(this.m_meta.getSourceTableName())}), (Throwable)ex);
                }
            }
            HBaseValueMetaInterface vm2 = this.hBaseValueMetaInterfaceFactory.createHBaseValueMetaInterface(null, null, this.m_tableMapping.getKeyName(), HBaseInput.getKettleTypeByKeyType(this.m_tableMapping.getKeyType()), -1, -1);
            vm2.setKey(true);
            try {
                this.m_tableMapping.addMappedColumn(vm2, this.m_tableMapping.isTupleMapping());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.m_columnsMappedByAlias = this.m_tableMapping.getMappedColumns();
            if (this.m_tableMapping.isTupleMapping()) {
                this.m_tupleHandler = new HBaseRowToKettleTuple(this.m_bytesUtil);
            }
            String dateOrNumberConversionMaskForKey = null;
            this.m_userOutputColumns = this.m_meta.getOutputFields();
            if (this.m_userOutputColumns != null && this.m_userOutputColumns.size() > 0) {
                for (HBaseValueMetaInterface vm : this.m_userOutputColumns) {
                    if (!vm.isKey()) {
                        if (this.m_columnsMappedByAlias.get(vm.getAlias()) != null) continue;
                        throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.UnableToFindUserSelectedColumn", (String[])new String[]{vm.getAlias(), this.m_tableMapping.getFriendlyName()}));
                    }
                    dateOrNumberConversionMaskForKey = vm.getConversionMask();
                }
            }
            try {
                this.m_hbAdminTable = this.m_hbAdmin.getTable(sourceName);
            }
            catch (Exception ex) {
                throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.UnableToSetSourceTableForScan", (String[])new String[0]), (Throwable)ex);
            }
            ResultScannerBuilder scannerBuilder = this.m_hbAdminTable.createScannerBuilder(this.m_tableMapping, dateOrNumberConversionMaskForKey, this.m_meta.getKeyStartValue(), this.m_meta.getKeyStopValue(), this.m_meta.getScannerCacheSize(), this.log, (VariableSpace)this);
            if (this.m_userOutputColumns != null && this.m_userOutputColumns.size() > 0 && !this.m_tableMapping.isTupleMapping()) {
                HBaseInputData.setScanColumns(scannerBuilder, this.m_userOutputColumns, this.m_tableMapping);
            }
            if (this.m_meta.getColumnFilters() != null && this.m_meta.getColumnFilters().size() > 0) {
                HBaseInputData.setScanFilters(scannerBuilder, this.m_meta.getColumnFilters(), this.m_meta.getMatchAnyFilter(), this.m_columnsMappedByAlias, (VariableSpace)this);
            }
            if (!this.isStopped()) {
                try {
                    this.resultScanner = scannerBuilder.build();
                }
                catch (Exception e) {
                    throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.UnableToExecuteSourceTableScan", (String[])new String[0]), (Throwable)e);
                }
                this.m_data.setOutputRowMeta((RowMetaInterface)new RowMeta());
                this.m_meta.getFields(this.m_data.getOutputRowMeta(), this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
            }
        }
        Result next = null;
        if (!this.isStopped()) {
            try {
                next = this.resultScanner.next();
            }
            catch (Exception e) {
                throw new KettleException(e.getMessage(), (Throwable)e);
            }
        }
        if (next == null) {
            try {
                this.m_hbAdminTable.close();
                this.m_hbAdmin.close();
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.ProblemClosingConnection", (String[])new String[]{e.getMessage()}), (Throwable)e);
            }
            this.setOutputDone();
            return false;
        }
        if (this.m_tableMapping.isTupleMapping()) {
            List<Object[]> tupleRows = HBaseInputData.getTupleOutputRows(this.hBaseService, next, this.m_userOutputColumns, this.m_columnsMappedByAlias, this.m_tableMapping, this.m_tupleHandler, this.m_data.getOutputRowMeta());
            for (Object[] tuple : tupleRows) {
                this.putRow(this.m_data.getOutputRowMeta(), tuple);
            }
            return true;
        }
        Object[] outRowData = HBaseInputData.getOutputRow(next, this.m_userOutputColumns, this.m_columnsMappedByAlias, this.m_tableMapping, this.m_data.getOutputRowMeta());
        this.putRow(this.m_data.getOutputRowMeta(), outRowData);
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        if (super.init(smi, sdi)) {
            HBaseInputMeta meta = (HBaseInputMeta)smi;
            try {
                meta.applyInjection((VariableSpace)this);
                return true;
            }
            catch (KettleException e) {
                this.logError("Error while injecting properties", e);
            }
        }
        return false;
    }

    public static int getKettleTypeByKeyType(Mapping.KeyType keyType) {
        if (keyType == null) {
            return 0;
        }
        switch (keyType) {
            case BINARY: {
                return 8;
            }
            case STRING: {
                return 2;
            }
            case UNSIGNED_LONG: 
            case UNSIGNED_INTEGER: 
            case LONG: 
            case INTEGER: {
                return 1;
            }
            case UNSIGNED_DATE: 
            case DATE: {
                return 3;
            }
        }
        return 0;
    }

    public void setStopped(boolean stopped) {
        if (this.isStopped() && stopped) {
            return;
        }
        super.setStopped(stopped);
        if (stopped && this.m_hbAdmin != null) {
            this.logBasic(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.ClosingConnection", (String[])new String[0]));
            try {
                this.m_hbAdmin.close();
            }
            catch (IOException ex) {
                this.logError(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.ProblemClosingConnection1", (Object[])new Object[]{ex}));
            }
        }
    }
}

