/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.sqoop;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.pentaho.big.data.kettle.plugins.job.JobEntryMode;
import org.pentaho.big.data.kettle.plugins.job.PropertyEntry;
import org.pentaho.big.data.kettle.plugins.sqoop.AbstractSqoopJobEntry;
import org.pentaho.big.data.kettle.plugins.sqoop.ArgumentWrapper;
import org.pentaho.big.data.kettle.plugins.sqoop.CommandLineArgument;
import org.pentaho.big.data.kettle.plugins.sqoop.SqoopConfig;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;

public class SqoopUtils {
    public static final String ARG_PREFIX = "--";
    public static final String ARG_PREFIX_1 = "-";
    public static final String ARG_D = "-D";
    private static final String WHITESPACE = " ";
    private static final String EQUALS = "=";
    private static final String QUOTE = "\"";
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile(" ");
    private static final Pattern QUOTE_PATTERN = Pattern.compile("\"");
    private static final Pattern BACKSLASH_PATTERN = Pattern.compile("\\\\");
    private static final Pattern EQUALS_PATTERN = Pattern.compile("=");
    private static final Object[][] ESCAPE_SEQUENCES = new Object[][]{{Pattern.compile("\t"), "\\\\t"}, {Pattern.compile("\b"), "\\\\b"}, {Pattern.compile("\n"), "\\\\n"}, {Pattern.compile("\r"), "\\\\r"}, {Pattern.compile("\f"), "\\\\f"}};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> parseCommandLine(String commandLineString, VariableSpace variableSpace, boolean ignoreSqoopCommand) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        try (StringReader reader = new StringReader(commandLineString);){
            StreamTokenizer tokenizer = new StreamTokenizer(reader);
            tokenizer.ordinaryChar(45);
            tokenizer.ordinaryChar(46);
            tokenizer.ordinaryChars(48, 57);
            tokenizer.wordChars(0, 65535);
            tokenizer.whitespaceChars(0, 32);
            tokenizer.quoteChar(34);
            tokenizer.quoteChar(39);
            boolean skipToken = false;
            while (tokenizer.nextToken() != -1) {
                if (tokenizer.sval == null) continue;
                String s = tokenizer.sval;
                if (variableSpace != null) {
                    s = variableSpace.environmentSubstitute(s);
                }
                if (ignoreSqoopCommand && args.isEmpty()) {
                    if ("sqoop".equals(s)) {
                        skipToken = true;
                        continue;
                    }
                    if (skipToken) {
                        ignoreSqoopCommand = false;
                        skipToken = false;
                        continue;
                    }
                }
                if (s.startsWith(ARG_D)) {
                    SqoopUtils.handleCustomOption(args, s, tokenizer, variableSpace);
                    continue;
                }
                args.add(SqoopUtils.escapeEscapeSequences(s));
            }
        }
        return args;
    }

    public static void configureFromCommandLine(SqoopConfig config, String commandLineString, VariableSpace variableSpace) throws IOException, KettleException {
        int i;
        List<String> args = SqoopUtils.parseCommandLine(commandLineString, variableSpace, true);
        HashMap<String, String> argValues = new HashMap<String, String>();
        LinkedHashMap<String, String> customArgValues = new LinkedHashMap<String, String>();
        int peekAhead = i = 0;
        while (i < args.size()) {
            String arg = args.get(i);
            int prefLen = SqoopUtils.isArgName(arg);
            if (prefLen > 0) {
                arg = arg.substring(prefLen);
            }
            String value = null;
            peekAhead = i + 1;
            if (peekAhead < args.size()) {
                value = args.get(peekAhead);
            }
            if (ARG_D.equals(arg)) {
                int index = value.indexOf(EQUALS);
                String customArg = value.substring(0, index);
                String customValue = value.substring(index + 1);
                if (variableSpace != null) {
                    customArg = variableSpace.environmentSubstitute(value);
                    customValue = variableSpace.environmentSubstitute(value);
                }
                customArgValues.put(customArg, customValue);
                i += 2;
                continue;
            }
            if (SqoopUtils.isArgName(value) > 0) {
                value = null;
                ++i;
            } else {
                if (variableSpace != null) {
                    value = variableSpace.environmentSubstitute(value);
                }
                i += 2;
            }
            argValues.put(arg, value);
        }
        SqoopUtils.setArgumentStringValues(config, argValues);
        SqoopUtils.setCustomArgumentStringValues(config, customArgValues);
    }

    private static int isArgName(String s) {
        if (s != null) {
            if (s.startsWith(ARG_PREFIX) && s.length() > ARG_PREFIX.length()) {
                return ARG_PREFIX.length();
            }
            if (ARG_D.equals(s)) {
                return 0;
            }
            if (s.startsWith(ARG_PREFIX_1) && s.length() > ARG_PREFIX_1.length()) {
                return ARG_PREFIX_1.length();
            }
        }
        return 0;
    }

    protected static void setArgumentStringValues(SqoopConfig config, Map<String, String> args) throws KettleException {
        for (Class<?> aClass = config.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            for (Field field : aClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(CommandLineArgument.class)) continue;
                CommandLineArgument arg = field.getAnnotation(CommandLineArgument.class);
                String value = SqoopUtils.pickupArgumentValueFor(arg, args);
                try {
                    String fieldName = field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
                    Method setter = SqoopUtils.findMethod(config.getClass(), fieldName, new Class[]{String.class}, "set");
                    setter.invoke((Object)config, value);
                }
                catch (Exception ex) {
                    throw new KettleException("Cannot set value of argument \"" + arg.name() + "\" to \"" + value + QUOTE, (Throwable)ex);
                }
            }
        }
        if (!args.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            Iterator<String> i = args.keySet().iterator();
            while (i.hasNext()) {
                sb.append(i.next());
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
            throw new KettleException(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"ErrorUnknownArguments", (Object[])new Object[]{sb}));
        }
    }

    private static void setCustomArgumentStringValues(SqoopConfig config, Map<String, String> customArgValues) {
        config.getCustomArguments().clear();
        for (Map.Entry<String, String> entry : customArgValues.entrySet()) {
            config.getCustomArguments().add((Object)new PropertyEntry(entry.getKey(), entry.getValue()));
        }
    }

    private static String pickupArgumentValueFor(CommandLineArgument arg, Map<String, String> args) throws KettleException {
        String argumentName = arg.name();
        if (args.containsKey(argumentName)) {
            String value = args.remove(argumentName);
            if (arg.flag()) {
                return Boolean.TRUE.toString();
            }
            if (StringUtil.isEmpty((String)value)) {
                throw new KettleException(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"ErrorProhibitedEmptyString", (String[])new String[]{argumentName}));
            }
            return value;
        }
        return null;
    }

    public static List<String> getCommandLineArgs(SqoopConfig config, VariableSpace variableSpace) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        if (JobEntryMode.ADVANCED_COMMAND_LINE.equals((Object)config.getModeAsEnum())) {
            return SqoopUtils.parseCommandLine(config.getCommandLine(), variableSpace, true);
        }
        SqoopUtils.appendCustomArguments(args, config, variableSpace);
        SqoopUtils.appendArguments(args, SqoopUtils.findAllArguments(config), variableSpace);
        return args;
    }

    public static String generateCommandLineString(SqoopConfig config, VariableSpace variableSpace) {
        StringBuilder sb = new StringBuilder();
        ArrayList<ArrayList<String>> buffers = new ArrayList<ArrayList<String>>();
        ArrayList<String> customBuffer = new ArrayList<String>();
        for (PropertyEntry entry : config.getCustomArguments()) {
            SqoopUtils.appendCustomArgument(customBuffer, entry, variableSpace, true);
        }
        Iterator<Object> iterator = customBuffer.iterator();
        while (iterator.hasNext()) {
            sb.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            sb.append(WHITESPACE);
        }
        for (ArgumentWrapper arg : SqoopUtils.findAllArguments(config)) {
            ArrayList<String> buffer = new ArrayList<String>(4);
            SqoopUtils.appendArgument(buffer, arg, variableSpace);
            if (buffer.isEmpty()) continue;
            buffers.add(buffer);
        }
        if (!customBuffer.isEmpty() && !buffers.isEmpty()) {
            sb.append(WHITESPACE);
        }
        Iterator buffersIter = buffers.iterator();
        while (buffersIter.hasNext()) {
            List buffer = (List)buffersIter.next();
            sb.append((String)buffer.get(0));
            if (buffer.size() == 2) {
                sb.append(WHITESPACE);
                sb.append(SqoopUtils.quote(SqoopUtils.escapeBackslash((String)buffer.get(1))));
            }
            if (!buffersIter.hasNext()) continue;
            sb.append(WHITESPACE);
        }
        return sb.toString();
    }

    protected static String escapeEscapeSequences(String s) {
        for (Object[] escapeSequence : ESCAPE_SEQUENCES) {
            s = ((Pattern)escapeSequence[0]).matcher(s).replaceAll((String)escapeSequence[1]);
        }
        return s;
    }

    protected static String quote(String s) {
        String orig = s;
        if (!orig.equals(s = QUOTE_PATTERN.matcher(s).replaceAll("\\\\\"")) || WHITESPACE_PATTERN.matcher(s).find() || BACKSLASH_PATTERN.matcher(s).find() || EQUALS_PATTERN.matcher(s).find()) {
            s = QUOTE + s + QUOTE;
        }
        return s;
    }

    protected static void appendArguments(List<String> args, Set<? extends ArgumentWrapper> arguments, VariableSpace variableSpace) {
        for (ArgumentWrapper argumentWrapper : arguments) {
            SqoopUtils.appendArgument(args, argumentWrapper, variableSpace);
        }
    }

    protected static void appendArgument(List<String> args, ArgumentWrapper arg, VariableSpace variableSpace) {
        String value = arg.getValue();
        if (variableSpace != null) {
            value = variableSpace.environmentSubstitute(value);
        }
        if (arg.isFlag() && Boolean.parseBoolean(value)) {
            args.add(arg.getPrefix() + arg.getName());
        } else if (!arg.isFlag() && value != null && !StringUtil.isEmpty((String)value)) {
            args.add(arg.getPrefix() + arg.getName());
            args.add(value);
        }
    }

    private static void appendCustomArguments(List<String> args, SqoopConfig config, VariableSpace variableSpace) {
        for (PropertyEntry entry : config.getCustomArguments()) {
            SqoopUtils.appendCustomArgument(args, entry, variableSpace, false);
        }
    }

    private static void appendCustomArgument(List<String> args, PropertyEntry arg, VariableSpace variableSpace, boolean quote) {
        String key = arg.getKey();
        String value = arg.getValue();
        if (StringUtils.isBlank((String)key) && StringUtils.isBlank((String)value)) {
            return;
        }
        key = StringUtils.defaultIfBlank((String)arg.getKey(), (String)"null");
        value = StringUtils.defaultIfBlank((String)arg.getValue(), (String)"null");
        if (variableSpace != null) {
            key = variableSpace.environmentSubstitute(key);
            value = variableSpace.environmentSubstitute(value);
        }
        if (quote) {
            value = SqoopUtils.quote(SqoopUtils.escapeBackslash(value));
        }
        args.add(ARG_D);
        args.add(key + EQUALS + value);
    }

    private static String escapeBackslash(String s) {
        return BACKSLASH_PATTERN.matcher(s).replaceAll("\\\\\\\\");
    }

    private static void handleCustomOption(List<String> args, String option, StreamTokenizer tokenizer, VariableSpace variableSpace) throws IOException {
        String key = null;
        String value = null;
        args.add(ARG_D);
        if (ARG_D.equals(option)) {
            tokenizer.nextToken();
            key = tokenizer.sval;
        } else {
            key = option.substring(ARG_D.length());
        }
        if (key.contains(EQUALS)) {
            if (key.endsWith(EQUALS)) {
                key = key.substring(0, key.length() - 1);
                tokenizer.nextToken();
                value = tokenizer.sval;
            } else {
                String[] split = key.split(EQUALS);
                key = split[0];
                value = split[1];
            }
        } else {
            tokenizer.nextToken();
            value = tokenizer.sval;
        }
        if (variableSpace != null) {
            key = variableSpace.environmentSubstitute(key);
            value = variableSpace.environmentSubstitute(value);
        }
        args.add(key + EQUALS + SqoopUtils.escapeEscapeSequences(value));
    }

    public static Set<? extends ArgumentWrapper> findAllArguments(Object o) {
        TreeSet<ArgumentWrapper> arguments = new TreeSet<ArgumentWrapper>(new Comparator<ArgumentWrapper>(){

            @Override
            public int compare(ArgumentWrapper o1, ArgumentWrapper o2) {
                int diff = o1.getOrder() - o2.getOrder();
                if (diff != 0) {
                    return diff;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Class<?> aClass = o.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            for (Field f : aClass.getDeclaredFields()) {
                if (!f.isAnnotationPresent(CommandLineArgument.class)) continue;
                CommandLineArgument anno = f.getAnnotation(CommandLineArgument.class);
                String fieldName = f.getName().substring(0, 1).toUpperCase() + f.getName().substring(1);
                Method getter = SqoopUtils.findMethod(aClass, fieldName, null, "get", "is");
                Method setter = SqoopUtils.findMethod(aClass, fieldName, new Class[]{f.getType()}, "set");
                arguments.add(new ArgumentWrapper(anno.name(), SqoopUtils.getDisplayName(anno), anno.flag(), anno.prefix(), anno.order(), o, getter, setter));
            }
        }
        return arguments;
    }

    public static String getDisplayName(CommandLineArgument anno) {
        return StringUtil.isEmpty((String)anno.displayName()) ? anno.name() : anno.displayName();
    }

    public static Method findMethod(Class<?> aClass, String methodName, Class<?>[] parameterTypes, String ... prefixes) {
        for (String prefix : prefixes) {
            try {
                return aClass.getDeclaredMethod(prefix + methodName, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return (aClass = aClass.getSuperclass()) == null ? null : SqoopUtils.findMethod(aClass, methodName, parameterTypes, prefixes);
    }
}

