/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.sqoop.ui;

import java.util.Collection;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.pentaho.big.data.kettle.plugins.sqoop.AbstractSqoopJobEntry;
import org.pentaho.big.data.kettle.plugins.sqoop.SqoopImportConfig;
import org.pentaho.big.data.kettle.plugins.sqoop.SqoopImportJobEntry;
import org.pentaho.big.data.kettle.plugins.sqoop.ui.AbstractSqoopJobEntryController;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class SqoopImportJobEntryController
extends AbstractSqoopJobEntryController<SqoopImportConfig, SqoopImportJobEntry> {
    public static final String SQOOP_IMPORT_STEP_NAME = "sqoop-import";

    public SqoopImportJobEntryController(JobMeta jobMeta, XulDomContainer container, SqoopImportJobEntry sqoopJobEntry, BindingFactory bindingFactory) {
        super(jobMeta, container, sqoopJobEntry, bindingFactory);
    }

    @Override
    public String getDialogElementId() {
        return SQOOP_IMPORT_STEP_NAME;
    }

    @Override
    protected void createBindings(SqoopImportConfig config, XulDomContainer container, BindingFactory bindingFactory, Collection<Binding> bindings) {
        super.createBindings(config, container, bindingFactory, bindings);
        bindings.add(bindingFactory.createBinding((Object)config, "targetDir", "targetDir", "value", new BindingConvertor[0]));
    }

    public void browseForTargetDirectory() {
        try {
            String[] schemeRestrictions = new String[1];
            if (this.selectedNamedCluster == null || "false".equals(this.selectedNamedCluster.getVariable("valid"))) {
                return;
            }
            schemeRestrictions[0] = this.selectedNamedCluster.isMapr() ? "maprfs" : "hdfs";
            String path = ((SqoopImportConfig)this.getConfig()).getTargetDir();
            FileObject initialFile = this.getInitialFile(path);
            if (initialFile == null) {
                this.showErrorDialog(BaseMessages.getString((Class)PKG, (String)"Sqoop.JobEntry.Connection.Error.title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"Sqoop.JobEntry.Connection.error", (String[])new String[0]));
                return;
            }
            FileObject targetDir = this.browseVfs(null, initialFile, 1, schemeRestrictions, false, schemeRestrictions[0], this.selectedNamedCluster, false, false);
            VfsFileChooserDialog dialog = Spoon.getInstance().getVfsFileChooserDialog(null, null);
            boolean okPressed = dialog.okPressed;
            if (okPressed) {
                ((SqoopImportConfig)this.getConfig()).setTargetDir(targetDir != null ? targetDir.getName().getPath() : null);
                this.extractNamedClusterFromVfsFileChooser();
            }
        }
        catch (FileSystemException | KettleFileException e) {
            ((SqoopImportJobEntry)this.getJobEntry()).logError(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"ErrorBrowsingDirectory", (String[])new String[0]), e);
        }
    }

    public void editNamedCluster() {
        this.editNamedCluster(SQOOP_IMPORT_STEP_NAME);
    }

    public void newNamedCluster() {
        this.newNamedCluster(SQOOP_IMPORT_STEP_NAME);
    }
}

