/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.bigdata.api.hdfs.impl;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.initializer.ClusterInitializationException;
import org.pentaho.big.data.api.initializer.ClusterInitializer;
import org.pentaho.bigdata.api.hdfs.HadoopFileSystem;
import org.pentaho.bigdata.api.hdfs.HadoopFileSystemFactory;
import org.pentaho.bigdata.api.hdfs.HadoopFileSystemLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopFileSystemLocatorImpl
implements HadoopFileSystemLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HadoopFileSystemLocatorImpl.class);
    private final List<HadoopFileSystemFactory> hadoopFileSystemFactories;
    private final ClusterInitializer clusterInitializer;

    public HadoopFileSystemLocatorImpl(List<HadoopFileSystemFactory> hadoopFileSystemFactories, ClusterInitializer clusterInitializer) {
        this.hadoopFileSystemFactories = hadoopFileSystemFactories;
        this.clusterInitializer = clusterInitializer;
    }

    @Override
    public HadoopFileSystem getHadoopFilesystem(NamedCluster namedCluster) throws ClusterInitializationException {
        return this.getHadoopFilesystem(namedCluster, null);
    }

    @Override
    public HadoopFileSystem getHadoopFilesystem(NamedCluster namedCluster, URI uri) throws ClusterInitializationException {
        this.clusterInitializer.initialize(namedCluster);
        for (HadoopFileSystemFactory hadoopFileSystemFactory : this.hadoopFileSystemFactories) {
            if (!hadoopFileSystemFactory.canHandle(namedCluster)) continue;
            try {
                return hadoopFileSystemFactory.create(namedCluster, uri);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to create " + uri.getScheme() + " service with " + hadoopFileSystemFactory + " for " + namedCluster, (Throwable)e);
            }
        }
        return null;
    }
}

