/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.mongodbinput;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import org.pentaho.di.core.Const;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputMeta;
import org.pentaho.di.ui.trans.step.BaseStepGenericXulDialog;
import org.pentaho.di.ui.trans.steps.mongodbinput.models.MongoDbModel;
import org.pentaho.di.ui.trans.steps.mongodbinput.models.MongoDocumentField;
import org.pentaho.di.ui.trans.steps.mongodbinput.models.MongoTag;
import org.pentaho.mongo.MongoDbException;
import org.pentaho.mongo.NamedReadPreference;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulLoader;
import org.pentaho.ui.xul.XulRunner;
import org.pentaho.ui.xul.XulSettingsManager;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.swing.SwingBindingFactory;
import org.pentaho.ui.xul.swing.SwingXulLoader;
import org.pentaho.ui.xul.swing.SwingXulRunner;

public class MongoDbInputXulDialog
extends BaseStepGenericXulDialog {
    private MongoDbModel model;
    private Binding databaseBinding;
    private Binding collectionBinding;
    protected static BindingConvertor<String, Boolean> emptyStringBinding = new IsEmptyStringToBooleanConvertor();
    protected static BindingConvertor<int[], Boolean> selectedItemsBinding = new SelectedToBooleanConvertor();
    protected static BindingConvertor<Collection<MongoTag>, Boolean> rowCountBinding = new RowCountToBooleanConvertor<MongoTag>();

    public MongoDbInputXulDialog(Object parent, BaseStepMeta baseStepMeta, TransMeta transMeta, String stepname) {
        super("org/pentaho/di/ui/trans/steps/mongodbinput/xul/mongodb_input.xul", parent, baseStepMeta, transMeta, stepname);
    }

    public XulSettingsManager getSettingsManager() {
        return null;
    }

    public ResourceBundle getResourceBundle() {
        return null;
    }

    public void init() {
        this.model = new MongoDbModel((MongoDbInputMeta)this.stepMeta.getStepMetaInterface());
        try {
            this.bf.setBindingType(Binding.Type.ONE_WAY);
            this.bf.createBinding((Object)this.model, "possibleReadPreferences", "readPreference", "elements", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding("hostName", "value", "getDbs", "disabled", new BindingConvertor[]{emptyStringBinding}).fireSourceChanged();
            this.bf.createBinding("hostName", "value", "getCollections", "disabled", new BindingConvertor[]{emptyStringBinding}).fireSourceChanged();
            this.bf.createBinding("hostName", "value", "getTags", "disabled", new BindingConvertor[]{emptyStringBinding}).fireSourceChanged();
            this.bf.createBinding("hostName", "value", "getFields", "disabled", new BindingConvertor[]{emptyStringBinding}).fireSourceChanged();
            this.databaseBinding = this.bf.createBinding((Object)this.model, "dbNames", "database", "elements", new BindingConvertor[0]);
            this.databaseBinding.fireSourceChanged();
            this.collectionBinding = this.bf.createBinding((Object)this.model, "collections", "collection", "elements", new BindingConvertor[0]);
            this.collectionBinding.fireSourceChanged();
            this.bf.createBinding(this.model.getFields(), "children", (Object)this, "previewState", new BindingConvertor[0]).fireSourceChanged();
            this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
            this.bf.createBinding((Object)this.model, "hostnames", "hostName", "value", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding((Object)this.model, "port", "port", "value", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding((Object)this.model, "jsonQuery", "jsonQuery", "value", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding((Object)this.model, "authenticationDatabaseName", "authDatabase", "value", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding((Object)this.model, "authenticationPassword", "authPassword", "value", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding((Object)this.model, "authenticationUser", "authUser", "value", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding((Object)this.model, "fieldsName", "fieldsQuery", "value", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding((Object)this.model, "socketTimeout", "socketTimeout", "value", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding((Object)this.model, "connectTimeout", "connectionTimeout", "value", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding((Object)this.model, "queryIsPipeline", "isAggPipeline", "checked", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding((Object)this.model, "useAllReplicaMembers", "isUseAllReplicas", "checked", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding((Object)this.model, "useKerberosAuthentication", "isUseKerberosAuthentication", "checked", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding("isUseKerberosAuthentication", "checked", "authPassword", "disabled", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding((Object)this.model, "dbName", "database", "selectedItem", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding((Object)this.model, "collection", "collection", "selectedItem", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding((Object)this.model, "readPreference", "readPreference", "selectedItem", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding("isAggPipeline", "checked", "fieldsQuery", "disabled", new BindingConvertor[0]).fireSourceChanged();
            Binding fieldsBinding = this.bf.createBinding(this.model.getFields(), "children", "fieldsTable", "elements", new BindingConvertor[0]);
            fieldsBinding.fireSourceChanged();
            Binding tagsBinding = this.bf.createBinding(this.model.getTags(), "children", "tagsTable", "elements", new BindingConvertor[0]);
            tagsBinding.fireSourceChanged();
            this.bf.setBindingType(Binding.Type.ONE_WAY);
            this.bf.createBinding("tagsTable", "absoluteSelectedRows", "joinTags", "disabled", new BindingConvertor[]{selectedItemsBinding}).fireSourceChanged();
            this.bf.createBinding(this.model.getTags(), "children", "testTags", "disabled", new BindingConvertor[]{rowCountBinding}).fireSourceChanged();
        }
        catch (Exception e) {
            this.log.logError("Error creating bindings for dialog. This dialog will not be available", (Throwable)e);
        }
    }

    public void setPreviewState(List<MongoDocumentField> elements) {
        this.validate();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.model.addPropertyChangeListener(listener);
        super.addPropertyChangeListener(listener);
    }

    public boolean validate() {
        return this.model.validate();
    }

    protected void initializeXul() throws XulException {
        this.initializeXul((XulLoader)new SwingXulLoader(), (BindingFactory)new SwingBindingFactory(), (XulRunner)new SwingXulRunner(), this.parent);
    }

    public void onAccept() {
        this.model.save();
        this.close();
        this.dispose();
    }

    public void onCancel() {
        this.stepname = null;
        this.close();
        this.dispose();
    }

    protected Class<?> getClassForMessages() {
        return ((Object)((Object)this)).getClass();
    }

    public void dispose() {
    }

    public void clear() {
        if (this.model == null) {
            return;
        }
        this.model.clear();
        try {
            this.databaseBinding.fireSourceChanged();
            this.collectionBinding.fireSourceChanged();
        }
        catch (Exception e) {
            this.logError("Non-critical error clearing database and collection information.", e);
        }
    }

    public void createNewField() {
        MongoDocumentField field = new MongoDocumentField();
        this.model.getFields().add((Object)field);
    }

    public void getDatabaseNamesFromMongo() {
        try {
            Vector<String> dbs = this.model.getDatabaseNamesFromMongo();
            this.model.setDbNames(dbs);
            this.databaseBinding.fireSourceChanged();
        }
        catch (Exception e) {
            this.showMessage(e.getMessage(), "MongoDb Error");
        }
    }

    public void getCollectionNamesFromMongo() {
        try {
            Vector<String> collections = this.model.getCollectionNamesFromMongo();
            this.model.setCollections(collections);
            this.collectionBinding.fireSourceChanged();
        }
        catch (Exception e) {
            this.showMessage(e.getMessage(), "MongoDb Error");
        }
    }

    public void getDocumentFieldsFromMongo() {
        if (Const.isEmpty((String)this.model.getHostnames())) {
            this.showMessage("At least one host name is required. Return to the configure tab, enter a host name and try again.", "MongoDb Error");
            return;
        }
        if (Const.isEmpty((String)this.model.getDbName())) {
            this.showMessage("A database name is required. Return to the options tab, enter a database name and try again.", "MongoDb Error");
            return;
        }
        if (Const.isEmpty((String)this.model.getCollection())) {
            this.showMessage("A collection name is required. Return to the options tab, enter a collection name and try again.", "MongoDb Error");
            return;
        }
        try {
            int mergeStrategy = 1;
            if (this.model.getFields().size() > 0) {
                mergeStrategy = this.showClearDataMessage();
            }
            if (mergeStrategy < 3 && mergeStrategy > -1) {
                this.model.getFieldsFromMongo(mergeStrategy);
            }
        }
        catch (Exception e) {
            this.showMessage(e.getMessage(), "MongoDb Error");
        }
    }

    public void getTagsFromMongo() {
        try {
            if (this.model.getReadPreference().equalsIgnoreCase(NamedReadPreference.PRIMARY.getName())) {
                this.showMessage("Tag sets defined with a read preference of 'primary' will not be honored by MongoDb. \nConsider changing your read preference to one other than primary.", "MongoDb Warning");
            }
            int mergeStrategy = 1;
            if (this.model.getTags().size() > 0) {
                mergeStrategy = this.showClearDataMessage();
            }
            if (mergeStrategy < 3 && mergeStrategy > -1) {
                this.model.getTagsFromMongo(mergeStrategy);
            }
        }
        catch (Exception e) {
            this.showMessage(e.getMessage(), "MongoDb Error");
        }
    }

    public void joinTags() {
        XulTree table = (XulTree)this.document.getElementById("tagsTable");
        int[] selectedTags = table.getAbsoluteSelectedRows();
        Object[][] values = table.getValues();
        String concatenated = "";
        for (int i : selectedTags) {
            String tag = (String)values[i][0];
            concatenated = concatenated + (concatenated.length() > 0 ? (!concatenated.endsWith(",") ? ", " : "") : "") + tag;
        }
        MongoTag tag = new MongoTag(concatenated);
        this.model.getTags().add((Object)tag);
    }

    public void testTags() {
        try {
            List<String> results = this.model.testSelectedTags();
            if (results == null) {
                this.showMessage("No matches found.", "Replica Set Member Matches");
                return;
            }
            StringBuffer message = new StringBuffer();
            for (String result : results) {
                message.append(result).append("\n");
            }
            this.showMessage(message.toString(), "Replica Set Member Matches");
        }
        catch (MongoDbException e) {
            this.showMessage(e.getMessage(), "MongoDb Error");
        }
    }

    public void createNewTag() {
        this.model.getTags().add((Object)new MongoTag());
    }

    private static class RowCountToBooleanConvertor<T>
    extends BindingConvertor<Collection<T>, Boolean> {
        private RowCountToBooleanConvertor() {
        }

        public Boolean sourceToTarget(Collection<T> value) {
            return value == null || value.isEmpty();
        }

        public Collection<T> targetToSource(Boolean value) {
            return null;
        }
    }

    private static class SelectedToBooleanConvertor
    extends BindingConvertor<int[], Boolean> {
        private SelectedToBooleanConvertor() {
        }

        public Boolean sourceToTarget(int[] value) {
            return value.length <= 1;
        }

        public int[] targetToSource(Boolean value) {
            return null;
        }
    }

    private static class IsEmptyStringToBooleanConvertor
    extends BindingConvertor<String, Boolean> {
        private IsEmptyStringToBooleanConvertor() {
        }

        public Boolean sourceToTarget(String value) {
            return Const.isEmpty((String)value);
        }

        public String targetToSource(Boolean value) {
            return null;
        }
    }
}

