/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AccessControlException;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DiskChecker;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.hadoop.Credentials;
import org.apache.oozie.action.hadoop.CredentialsProperties;
import org.apache.oozie.action.hadoop.CredentialsProvider;
import org.apache.oozie.action.hadoop.JavaMain;
import org.apache.oozie.action.hadoop.LauncherMainHadoopUtils;
import org.apache.oozie.action.hadoop.LauncherMapper;
import org.apache.oozie.action.hadoop.LauncherMapperHelper;
import org.apache.oozie.action.hadoop.OozieJobInfo;
import org.apache.oozie.action.hadoop.OozieLauncherInputFormat;
import org.apache.oozie.action.hadoop.OozieLauncherOutputCommitter;
import org.apache.oozie.action.hadoop.OozieLauncherOutputFormat;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.hadoop.utils.HadoopShims;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.ShareLibService;
import org.apache.oozie.service.URIHandlerService;
import org.apache.oozie.util.ELEvaluationException;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.JobUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.PropertiesUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public class JavaActionExecutor
extends ActionExecutor {
    private static final String HADOOP_USER = "user.name";
    public static final String HADOOP_JOB_TRACKER = "mapred.job.tracker";
    public static final String HADOOP_JOB_TRACKER_2 = "mapreduce.jobtracker.address";
    public static final String HADOOP_YARN_RM = "yarn.resourcemanager.address";
    public static final String HADOOP_NAME_NODE = "fs.default.name";
    private static final String HADOOP_JOB_NAME = "mapred.job.name";
    public static final String OOZIE_COMMON_LIBDIR = "oozie";
    private static final Set<String> DISALLOWED_PROPERTIES = new HashSet<String>();
    public static final String MAX_EXTERNAL_STATS_SIZE = "oozie.external.stats.max.size";
    public static final String ACL_VIEW_JOB = "mapreduce.job.acl-view-job";
    public static final String ACL_MODIFY_JOB = "mapreduce.job.acl-modify-job";
    public static final String HADOOP_YARN_UBER_MODE = "mapreduce.job.ubertask.enable";
    public static final String HADOOP_YARN_KILL_CHILD_JOBS_ON_AMRESTART = "oozie.action.launcher.am.restart.kill.childjobs";
    public static final String HADOOP_MAP_MEMORY_MB = "mapreduce.map.memory.mb";
    public static final String HADOOP_CHILD_JAVA_OPTS = "mapred.child.java.opts";
    public static final String HADOOP_MAP_JAVA_OPTS = "mapreduce.map.java.opts";
    public static final String HADOOP_REDUCE_JAVA_OPTS = "mapreduce.reduce.java.opts";
    public static final String HADOOP_CHILD_JAVA_ENV = "mapred.child.env";
    public static final String HADOOP_MAP_JAVA_ENV = "mapreduce.map.env";
    public static final String YARN_AM_RESOURCE_MB = "yarn.app.mapreduce.am.resource.mb";
    public static final String YARN_AM_COMMAND_OPTS = "yarn.app.mapreduce.am.command-opts";
    public static final String YARN_AM_ENV = "yarn.app.mapreduce.am.env";
    private static final String JAVA_MAIN_CLASS_NAME = "org.apache.oozie.action.hadoop.JavaMain";
    public static final int YARN_MEMORY_MB_MIN = 512;
    private static int maxActionOutputLen;
    private static int maxExternalStatsSize;
    private static int maxFSGlobMax;
    private static final String SUCCEEDED = "SUCCEEDED";
    private static final String KILLED = "KILLED";
    private static final String FAILED = "FAILED";
    private static final String FAILED_KILLED = "FAILED/KILLED";
    protected XLog LOG = XLog.getLog(this.getClass());
    private static final Pattern heapPattern;
    private static final String JAVA_TMP_DIR_SETTINGS = "-Djava.io.tmpdir=";
    public static final String CONF_HADOOP_YARN_UBER_MODE = "oozie.action.launcher.mapreduce.job.ubertask.enable";
    public static final String HADOOP_JOB_CLASSLOADER = "mapreduce.job.classloader";
    public static final String HADOOP_USER_CLASSPATH_FIRST = "mapreduce.user.classpath.first";
    public static final String OOZIE_CREDENTIALS_SKIP = "oozie.credentials.skip";
    public XConfiguration workflowConf = null;
    private static final String QUEUE_NAME = "mapred.job.queue.name";
    private static final Set<String> SPECIAL_PROPERTIES;
    private static Set<String> FINAL_STATUS;
    private static final String ACTION_SHARELIB_FOR = "oozie.action.sharelib.for.";

    public JavaActionExecutor() {
        this("java");
    }

    protected JavaActionExecutor(String type) {
        super(type);
    }

    public static List<Class> getCommonLauncherClasses() {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(LauncherMapper.class);
        classes.add(OozieLauncherInputFormat.class);
        classes.add(OozieLauncherOutputFormat.class);
        classes.add(OozieLauncherOutputCommitter.class);
        classes.add(LauncherMainHadoopUtils.class);
        classes.add(HadoopShims.class);
        classes.addAll(Services.get().get(URIHandlerService.class).getClassesForLauncher());
        return classes;
    }

    public List<Class> getLauncherClasses() {
        ArrayList<Class> classes = new ArrayList<Class>();
        try {
            classes.add(Class.forName(JAVA_MAIN_CLASS_NAME));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found", e);
        }
        return classes;
    }

    @Override
    public void initActionType() {
        super.initActionType();
        maxActionOutputLen = ConfigurationService.getInt("oozie.action.max.output.data");
        maxExternalStatsSize = ConfigurationService.getInt(MAX_EXTERNAL_STATS_SIZE);
        maxExternalStatsSize = maxExternalStatsSize == -1 ? Integer.MAX_VALUE : maxExternalStatsSize;
        maxFSGlobMax = ConfigurationService.getInt("oozie.action.fs.glob.max");
        this.registerError(UnknownHostException.class.getName(), ActionExecutorException.ErrorType.TRANSIENT, "JA001");
        this.registerError(AccessControlException.class.getName(), ActionExecutorException.ErrorType.NON_TRANSIENT, "JA002");
        this.registerError(DiskChecker.DiskOutOfSpaceException.class.getName(), ActionExecutorException.ErrorType.NON_TRANSIENT, "JA003");
        this.registerError(QuotaExceededException.class.getName(), ActionExecutorException.ErrorType.NON_TRANSIENT, "JA004");
        this.registerError(SafeModeException.class.getName(), ActionExecutorException.ErrorType.NON_TRANSIENT, "JA005");
        this.registerError(ConnectException.class.getName(), ActionExecutorException.ErrorType.TRANSIENT, "  JA006");
        this.registerError(JDOMException.class.getName(), ActionExecutorException.ErrorType.ERROR, "JA007");
        this.registerError(FileNotFoundException.class.getName(), ActionExecutorException.ErrorType.ERROR, "JA008");
        this.registerError(IOException.class.getName(), ActionExecutorException.ErrorType.TRANSIENT, "JA009");
    }

    public static int getMaxExternalStatsSize() {
        return maxExternalStatsSize;
    }

    static void checkForDisallowedProps(Configuration conf, String confName) throws ActionExecutorException {
        for (String prop : DISALLOWED_PROPERTIES) {
            if (conf.get(prop) == null) continue;
            throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "JA010", "Property [{0}] not allowed in action [{1}] configuration", prop, confName);
        }
    }

    public JobConf createBaseHadoopConf(ActionExecutor.Context context, Element actionXml) {
        Namespace ns = actionXml.getNamespace();
        String jobTracker = actionXml.getChild("job-tracker", ns).getTextTrim();
        String nameNode = actionXml.getChild("name-node", ns).getTextTrim();
        JobConf conf = Services.get().get(HadoopAccessorService.class).createJobConf(jobTracker);
        conf.set(HADOOP_USER, context.getProtoActionConf().get(HADOOP_USER));
        conf.set(HADOOP_JOB_TRACKER, jobTracker);
        conf.set(HADOOP_JOB_TRACKER_2, jobTracker);
        conf.set(HADOOP_YARN_RM, jobTracker);
        conf.set(HADOOP_NAME_NODE, nameNode);
        conf.set("mapreduce.fileoutputcommitter.marksuccessfuljobs", "true");
        return conf;
    }

    private static void injectLauncherProperties(Configuration srcConf, Configuration launcherConf) {
        for (Map.Entry entry : srcConf) {
            if (!((String)entry.getKey()).startsWith("oozie.launcher.")) continue;
            String name = ((String)entry.getKey()).substring("oozie.launcher.".length());
            String value = (String)entry.getValue();
            launcherConf.set((String)entry.getKey(), value);
            launcherConf.set(name, value);
        }
    }

    Configuration setupLauncherConf(Configuration conf, Element actionXml, Path appPath, ActionExecutor.Context context) throws ActionExecutorException {
        try {
            Namespace ns = actionXml.getNamespace();
            XConfiguration launcherConf = new XConfiguration();
            HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
            XConfiguration actionDefaultConf = has.createActionDefaultConf(conf.get(HADOOP_JOB_TRACKER), this.getType());
            JavaActionExecutor.injectLauncherProperties(actionDefaultConf, launcherConf);
            try {
                JavaActionExecutor.parseJobXmlAndConfiguration(context, actionXml, appPath, conf, true);
            }
            catch (HadoopAccessorException ex) {
                throw this.convertException(ex);
            }
            catch (URISyntaxException ex) {
                throw this.convertException(ex);
            }
            this.injectLauncherUseUberMode(launcherConf);
            XConfiguration.copy(launcherConf, conf);
            JavaActionExecutor.checkForDisallowedProps(launcherConf, "launcher configuration");
            Element e = actionXml.getChild("config-class", ns);
            if (e != null) {
                conf.set("oozie.action.config.class", e.getTextTrim());
            }
            return conf;
        }
        catch (IOException ex) {
            throw this.convertException(ex);
        }
    }

    void injectLauncherUseUberMode(Configuration launcherConf) {
        if (launcherConf.get(HADOOP_YARN_UBER_MODE) == null) {
            if (ConfigurationService.get("oozie.action." + this.getType() + ".launcher." + HADOOP_YARN_UBER_MODE).length() > 0) {
                if (ConfigurationService.getBoolean("oozie.action." + this.getType() + ".launcher." + HADOOP_YARN_UBER_MODE)) {
                    launcherConf.setBoolean(HADOOP_YARN_UBER_MODE, true);
                }
            } else if (ConfigurationService.getBoolean(CONF_HADOOP_YARN_UBER_MODE)) {
                launcherConf.setBoolean(HADOOP_YARN_UBER_MODE, true);
            }
        }
    }

    void updateConfForUberMode(Configuration launcherConf) {
        boolean hasConflictEnv = false;
        String launcherMapEnv = launcherConf.get(HADOOP_MAP_JAVA_ENV);
        if (launcherMapEnv == null) {
            launcherMapEnv = launcherConf.get(HADOOP_CHILD_JAVA_ENV);
        }
        String amEnv = launcherConf.get(YARN_AM_ENV);
        StringBuffer envStr = new StringBuffer();
        HashMap<String, List<String>> amEnvMap = null;
        HashMap<String, List<String>> launcherMapEnvMap = null;
        if (amEnv != null) {
            envStr.append(amEnv);
            amEnvMap = this.populateEnvMap(amEnv);
        }
        if (launcherMapEnv != null) {
            launcherMapEnvMap = this.populateEnvMap(launcherMapEnv);
            if (amEnvMap != null) {
                Iterator<String> envKeyItr = launcherMapEnvMap.keySet().iterator();
                while (envKeyItr.hasNext()) {
                    String envKey = envKeyItr.next();
                    if (!amEnvMap.containsKey(envKey)) continue;
                    List<String> amValList = amEnvMap.get(envKey);
                    List<String> launcherValList = launcherMapEnvMap.get(envKey);
                    Iterator<String> valItr = launcherValList.iterator();
                    while (valItr.hasNext()) {
                        String val = valItr.next();
                        if (!amValList.contains(val)) {
                            hasConflictEnv = true;
                            break;
                        }
                        valItr.remove();
                    }
                    if (!launcherValList.isEmpty()) continue;
                    envKeyItr.remove();
                }
            }
        }
        if (hasConflictEnv) {
            launcherConf.setBoolean(HADOOP_YARN_UBER_MODE, false);
        } else {
            if (launcherMapEnvMap != null) {
                for (String key : launcherMapEnvMap.keySet()) {
                    List<String> launcherValList = launcherMapEnvMap.get(key);
                    for (String val : launcherValList) {
                        if (envStr.length() > 0) {
                            envStr.append(",");
                        }
                        envStr.append(key).append("=").append(val);
                    }
                }
            }
            launcherConf.set(YARN_AM_ENV, envStr.toString());
            int launcherMapMemoryMB = launcherConf.getInt(HADOOP_MAP_MEMORY_MB, 1536);
            int amMemoryMB = launcherConf.getInt(YARN_AM_RESOURCE_MB, 1536);
            int memoryMB = Math.max(launcherMapMemoryMB, amMemoryMB) + 512;
            if (launcherMapMemoryMB < 4096 && amMemoryMB < 4096 && memoryMB > 4096) {
                memoryMB = 4096;
            }
            launcherConf.setInt(YARN_AM_RESOURCE_MB, memoryMB);
            String launcherMapOpts = launcherConf.get(HADOOP_MAP_JAVA_OPTS, "");
            String amChildOpts = launcherConf.get(YARN_AM_COMMAND_OPTS);
            StringBuilder optsStr = new StringBuilder();
            int heapSizeForMap = this.extractHeapSizeMB(launcherMapOpts);
            int heapSizeForAm = this.extractHeapSizeMB(amChildOpts);
            int heapSize = Math.max(heapSizeForMap, heapSizeForAm) + 512;
            if (heapSizeForMap < 4096 && heapSizeForAm < 4096 && heapSize > 3584) {
                heapSize = 3584;
            }
            if (amChildOpts != null) {
                optsStr.append(amChildOpts);
            }
            optsStr.append(" ").append(launcherMapOpts.trim());
            if (heapSize > 0) {
                optsStr.append(" ").append("-Xmx").append(heapSize).append("m");
            }
            launcherConf.set(YARN_AM_COMMAND_OPTS, optsStr.toString().trim());
        }
    }

    void updateConfForJavaTmpDir(Configuration conf) {
        String amChildOpts = conf.get(YARN_AM_COMMAND_OPTS);
        String oozieJavaTmpDirSetting = "-Djava.io.tmpdir=./tmp";
        if (amChildOpts != null && !amChildOpts.contains(JAVA_TMP_DIR_SETTINGS)) {
            conf.set(YARN_AM_COMMAND_OPTS, amChildOpts + " " + oozieJavaTmpDirSetting);
        }
    }

    private HashMap<String, List<String>> populateEnvMap(String input) {
        String[] envEntries;
        HashMap<String, List<String>> envMaps = new HashMap<String, List<String>>();
        for (String envEntry : envEntries = input.split(",")) {
            String[] envKeyVal = envEntry.split("=");
            String envKey = envKeyVal[0].trim();
            List<String> valList = envMaps.get(envKey);
            if (valList == null) {
                valList = new ArrayList<String>();
            }
            valList.add(envKeyVal[1].trim());
            envMaps.put(envKey, valList);
        }
        return envMaps;
    }

    public int extractHeapSizeMB(String input) {
        int ret = 0;
        if (input == null || input.equals("")) {
            return ret;
        }
        Matcher m = heapPattern.matcher(input);
        String heapStr = null;
        String heapNum = null;
        while (m.find()) {
            heapStr = m.group(1);
            heapNum = m.group(2);
        }
        if (heapStr != null) {
            ret = heapStr.endsWith("g") || heapStr.endsWith("G") ? Integer.parseInt(heapNum) * 1024 : Integer.parseInt(heapNum);
        }
        return ret;
    }

    public static void parseJobXmlAndConfiguration(ActionExecutor.Context context, Element element, Path appPath, Configuration conf) throws IOException, ActionExecutorException, HadoopAccessorException, URISyntaxException {
        JavaActionExecutor.parseJobXmlAndConfiguration(context, element, appPath, conf, false);
    }

    public static void parseJobXmlAndConfiguration(ActionExecutor.Context context, Element element, Path appPath, Configuration conf, boolean isLauncher) throws IOException, ActionExecutorException, HadoopAccessorException, URISyntaxException {
        Element e;
        Namespace ns = element.getNamespace();
        Iterator it = element.getChildren("job-xml", ns).iterator();
        HashMap<String, FileSystem> filesystemsMap = new HashMap<String, FileSystem>();
        HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
        while (it.hasNext()) {
            FileSystem fs;
            Path path;
            e = (Element)it.next();
            String jobXml = e.getTextTrim();
            Path pathSpecified = new Path(jobXml);
            Path path2 = path = pathSpecified.isAbsolute() ? pathSpecified : new Path(appPath, jobXml);
            if (filesystemsMap.containsKey(path.toUri().getAuthority())) {
                fs = (FileSystem)filesystemsMap.get(path.toUri().getAuthority());
            } else {
                fs = path.toUri().getAuthority() != null ? has.createFileSystem(context.getWorkflow().getUser(), path.toUri(), (Configuration)has.createJobConf(path.toUri().getAuthority())) : context.getAppFileSystem();
                filesystemsMap.put(path.toUri().getAuthority(), fs);
            }
            XConfiguration jobXmlConf = new XConfiguration((InputStream)fs.open(path));
            try {
                String jobXmlConfString = XmlUtils.prettyPrint(jobXmlConf).toString();
                jobXmlConfString = XmlUtils.removeComments(jobXmlConfString);
                jobXmlConfString = context.getELEvaluator().evaluate(jobXmlConfString, String.class);
                jobXmlConf = new XConfiguration(new StringReader(jobXmlConfString));
            }
            catch (ELEvaluationException ex) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.TRANSIENT, "EL_EVAL_ERROR", ex.getMessage(), ex);
            }
            catch (Exception ex) {
                context.setErrorInfo("EL_ERROR", ex.getMessage());
            }
            JavaActionExecutor.checkForDisallowedProps(jobXmlConf, "job-xml");
            if (isLauncher) {
                JavaActionExecutor.injectLauncherProperties(jobXmlConf, conf);
                continue;
            }
            XConfiguration.copy(jobXmlConf, conf);
        }
        e = element.getChild("configuration", ns);
        if (e != null) {
            String strConf = XmlUtils.prettyPrint(e).toString();
            XConfiguration inlineConf = new XConfiguration(new StringReader(strConf));
            JavaActionExecutor.checkForDisallowedProps(inlineConf, "inline configuration");
            if (isLauncher) {
                JavaActionExecutor.injectLauncherProperties(inlineConf, conf);
            } else {
                XConfiguration.copy(inlineConf, conf);
            }
        }
    }

    Configuration setupActionConf(Configuration actionConf, ActionExecutor.Context context, Element actionXml, Path appPath) throws ActionExecutorException {
        try {
            HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
            XConfiguration actionDefaults = has.createActionDefaultConf(actionConf.get(HADOOP_JOB_TRACKER), this.getType());
            XConfiguration.injectDefaults(actionDefaults, actionConf);
            has.checkSupportedFilesystem(appPath.toUri());
            this.setJavaMain(actionConf, actionXml);
            JavaActionExecutor.parseJobXmlAndConfiguration(context, actionXml, appPath, actionConf);
            actionConf.setBoolean("mapreduce.job.complete.cancel.delegation.tokens", false);
            this.updateConfForJavaTmpDir(actionConf);
            this.setRootLoggerLevel(actionConf);
            return actionConf;
        }
        catch (IOException ex) {
            throw this.convertException(ex);
        }
        catch (HadoopAccessorException ex) {
            throw this.convertException(ex);
        }
        catch (URISyntaxException ex) {
            throw this.convertException(ex);
        }
    }

    void setRootLoggerLevel(Configuration actionConf) {
        String oozieActionRootLogger;
        String oozieActionTypeRootLogger = "oozie.action." + this.getType() + "rootlogger.log.level";
        String rootLogLevel = actionConf.get(oozieActionTypeRootLogger, actionConf.get(oozieActionRootLogger = "oozie.action.rootlogger.log.level"));
        if (rootLogLevel != null) {
            return;
        }
        rootLogLevel = ConfigurationService.get(oozieActionTypeRootLogger);
        if (rootLogLevel != null && rootLogLevel.length() > 0) {
            actionConf.set(oozieActionRootLogger, rootLogLevel);
        } else {
            rootLogLevel = ConfigurationService.get(oozieActionRootLogger);
            if (rootLogLevel != null && rootLogLevel.length() > 0) {
                actionConf.set(oozieActionRootLogger, rootLogLevel);
            }
        }
    }

    Configuration addToCache(Configuration conf, Path appPath, String filePath, boolean archive) throws ActionExecutorException {
        URI uri = null;
        try {
            uri = new URI(filePath);
            URI baseUri = appPath.toUri();
            if (uri.getScheme() == null) {
                String resolvedPath = uri.getPath();
                if (!resolvedPath.startsWith("/")) {
                    resolvedPath = baseUri.getPath() + "/" + resolvedPath;
                }
                uri = new URI(baseUri.getScheme(), baseUri.getAuthority(), resolvedPath, uri.getQuery(), uri.getFragment());
            }
            if (archive) {
                DistributedCache.addCacheArchive((URI)uri.normalize(), (Configuration)conf);
            } else {
                String fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
                if (fileName.endsWith(".so") || fileName.contains(".so.")) {
                    uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), uri.getQuery(), fileName);
                    DistributedCache.addCacheFile((URI)uri.normalize(), (Configuration)conf);
                } else if (fileName.endsWith(".jar")) {
                    if (!fileName.contains("#")) {
                        String user = conf.get(HADOOP_USER);
                        Path pathToAdd = new Path(uri.normalize());
                        Services.get().get(HadoopAccessorService.class).addFileToClassPath(user, pathToAdd, conf);
                    } else {
                        DistributedCache.addCacheFile((URI)uri.normalize(), (Configuration)conf);
                    }
                } else {
                    if (!fileName.contains("#")) {
                        uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), uri.getQuery(), fileName);
                    }
                    DistributedCache.addCacheFile((URI)uri.normalize(), (Configuration)conf);
                }
            }
            DistributedCache.createSymlink((Configuration)conf);
            return conf;
        }
        catch (Exception ex) {
            this.LOG.debug("Errors when add to DistributedCache. Path=" + uri.toString() + ", archive=" + archive + ", conf=" + XmlUtils.prettyPrint(conf).toString());
            throw this.convertException(ex);
        }
    }

    public void prepareActionDir(FileSystem actionFs, ActionExecutor.Context context) throws ActionExecutorException {
        block4: {
            try {
                Path actionDir = context.getActionDir();
                Path tempActionDir = new Path(actionDir.getParent(), actionDir.getName() + ".tmp");
                if (actionFs.exists(actionDir)) break block4;
                try {
                    actionFs.mkdirs(tempActionDir);
                    actionFs.rename(tempActionDir, actionDir);
                }
                catch (IOException ex) {
                    actionFs.delete(tempActionDir, true);
                    actionFs.delete(actionDir, true);
                    throw ex;
                }
            }
            catch (Exception ex) {
                throw this.convertException(ex);
            }
        }
    }

    void cleanUpActionDir(FileSystem actionFs, ActionExecutor.Context context) throws ActionExecutorException {
        try {
            Path actionDir = context.getActionDir();
            if (!context.getProtoActionConf().getBoolean("oozie.action.keep.action.dir", false) && actionFs.exists(actionDir)) {
                actionFs.delete(actionDir, true);
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    protected void addShareLib(Configuration conf, String[] actionShareLibNames) throws ActionExecutorException {
        HashSet<String> confSet = new HashSet<String>(Arrays.asList(this.getShareLibFilesForActionConf() == null ? new String[]{} : this.getShareLibFilesForActionConf()));
        HashSet<1> sharelibList = new HashSet<1>();
        if (actionShareLibNames != null) {
            try {
                ShareLibService shareLibService = Services.get().get(ShareLibService.class);
                FileSystem fs = shareLibService.getFileSystem();
                if (fs != null) {
                    for (String actionShareLibName : actionShareLibNames) {
                        List<Path> listOfPaths = shareLibService.getShareLibJars(actionShareLibName);
                        if (listOfPaths == null || listOfPaths.isEmpty()) continue;
                        for (Path actionLibPath : listOfPaths) {
                            String fileName;
                            String fragmentName = new URI(actionLibPath.toString()).getFragment();
                            Path pathWithFragment = fragmentName == null ? actionLibPath : new Path(new URI(actionLibPath.toString()).getPath());
                            String string = fileName = fragmentName == null ? actionLibPath.getName() : fragmentName;
                            if (confSet.contains(fileName)) {
                                Configuration jobXmlConf = shareLibService.getShareLibConf(actionShareLibName, pathWithFragment);
                                if (jobXmlConf == null) continue;
                                JavaActionExecutor.checkForDisallowedProps(jobXmlConf, actionLibPath.getName());
                                XConfiguration.injectDefaults(jobXmlConf, conf);
                                this.LOG.trace("Adding properties of " + actionLibPath + " to job conf");
                                continue;
                            }
                            sharelibList.add(new Path(actionLibPath.toUri()){

                                public int hashCode() {
                                    return this.getName().hashCode();
                                }

                                public String getName() {
                                    try {
                                        return new URI(this.toString()).getFragment() == null ? new Path(this.toUri()).getName() : new URI(this.toString()).getFragment();
                                    }
                                    catch (URISyntaxException e) {
                                        throw new RuntimeException(e);
                                    }
                                }

                                public boolean equals(Object input) {
                                    if (input == null) {
                                        return false;
                                    }
                                    if (input == this) {
                                        return true;
                                    }
                                    if (!(input instanceof Path)) {
                                        return false;
                                    }
                                    return this.getName().equals(((Path)input).getName());
                                }
                            });
                        }
                    }
                }
                for (Path path : sharelibList) {
                    this.addToCache(conf, path, path.toUri().getPath(), false);
                }
            }
            catch (URISyntaxException ex) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "Error configuring sharelib", ex.getMessage());
            }
            catch (IOException ex) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "It should never happen", ex.getMessage());
            }
        }
    }

    protected void addSystemShareLibForAction(Configuration conf) throws ActionExecutorException {
        ShareLibService shareLibService = Services.get().get(ShareLibService.class);
        if (shareLibService != null) {
            try {
                List<Path> listOfPaths = shareLibService.getSystemLibJars(OOZIE_COMMON_LIBDIR);
                if (listOfPaths == null || listOfPaths.isEmpty()) {
                    throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "EJ001", "Could not locate Oozie sharelib");
                }
                FileSystem fs = listOfPaths.get(0).getFileSystem(conf);
                for (Path actionLibPath : listOfPaths) {
                    JobUtils.addFileToClassPath(actionLibPath, conf, fs);
                    DistributedCache.createSymlink((Configuration)conf);
                }
                listOfPaths = shareLibService.getSystemLibJars(this.getType());
                if (listOfPaths != null) {
                    for (Path actionLibPath : listOfPaths) {
                        JobUtils.addFileToClassPath(actionLibPath, conf, fs);
                        DistributedCache.createSymlink((Configuration)conf);
                    }
                }
            }
            catch (IOException ex) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "It should never happen", ex.getMessage());
            }
        }
    }

    protected void addActionLibs(Path appPath, Configuration conf) throws ActionExecutorException {
        String[] actionLibsStrArr = conf.getStrings("oozie.launcher.oozie.libpath");
        if (actionLibsStrArr != null) {
            try {
                for (String actionLibsStr : actionLibsStrArr) {
                    FileStatus[] files;
                    if ((actionLibsStr = actionLibsStr.trim()).length() <= 0) continue;
                    Path actionLibsPath = new Path(actionLibsStr);
                    String user = conf.get(HADOOP_USER);
                    FileSystem fs = Services.get().get(HadoopAccessorService.class).createFileSystem(user, appPath.toUri(), conf);
                    if (!fs.exists(actionLibsPath)) continue;
                    for (FileStatus file : files = fs.listStatus(actionLibsPath)) {
                        this.addToCache(conf, appPath, file.getPath().toUri().getPath(), false);
                    }
                }
            }
            catch (HadoopAccessorException ex) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, ex.getErrorCode().toString(), ex.getMessage());
            }
            catch (IOException ex) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "It should never happen", ex.getMessage());
            }
        }
    }

    public void setLibFilesArchives(ActionExecutor.Context context, Element actionXml, Path appPath, Configuration conf) throws ActionExecutorException {
        Configuration proto = context.getProtoActionConf();
        String[] paths = proto.getStrings("oozie.wf.application.lib");
        if (paths != null) {
            for (String path : paths) {
                this.addToCache(conf, appPath, path, false);
            }
        }
        this.addActionLibs(appPath, conf);
        for (Element eProp : actionXml.getChildren()) {
            String[] archivePaths;
            if (eProp.getName().equals("file")) {
                String[] filePaths;
                for (String path : filePaths = eProp.getTextTrim().split(",")) {
                    this.addToCache(conf, appPath, path.trim(), false);
                }
                continue;
            }
            if (!eProp.getName().equals("archive")) continue;
            for (String path : archivePaths = eProp.getTextTrim().split(",")) {
                this.addToCache(conf, appPath, path.trim(), true);
            }
        }
        this.addAllShareLibs(appPath, conf, context, actionXml);
    }

    private void addAllShareLibs(Path appPath, Configuration conf, ActionExecutor.Context context, Element actionXml) throws ActionExecutorException {
        this.addActionShareLib(appPath, conf, context, actionXml);
        this.addSystemShareLibForAction(conf);
    }

    private void addActionShareLib(Path appPath, Configuration conf, ActionExecutor.Context context, Element actionXml) throws ActionExecutorException {
        XConfiguration wfJobConf = null;
        try {
            wfJobConf = this.getWorkflowConf(context);
        }
        catch (IOException ioe) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "It should never happen", ioe.getMessage());
        }
        if (conf.get("oozie.use.system.libpath") == null) {
            if (wfJobConf.getBoolean("oozie.use.system.libpath", ConfigurationService.getBoolean("oozie.use.system.libpath"))) {
                this.addShareLib(conf, this.getShareLibNames(context, actionXml, conf));
            }
        } else if (conf.getBoolean("oozie.use.system.libpath", false)) {
            this.addShareLib(conf, this.getShareLibNames(context, actionXml, conf));
        }
    }

    protected String getLauncherMain(Configuration launcherConf, Element actionXml) {
        return launcherConf.get("oozie.launcher.action.main.class", JavaMain.class.getName());
    }

    private void setJavaMain(Configuration actionConf, Element actionXml) {
        Namespace ns = actionXml.getNamespace();
        Element e = actionXml.getChild("main-class", ns);
        if (e != null) {
            actionConf.set("oozie.action.java.main", e.getTextTrim());
        }
    }

    JobConf createLauncherConf(FileSystem actionFs, ActionExecutor.Context context, WorkflowAction action, Element actionXml, Configuration actionConf) throws ActionExecutorException {
        try {
            Path appPathRoot = new Path(context.getWorkflow().getAppPath());
            if (actionFs.isFile(appPathRoot)) {
                appPathRoot = appPathRoot.getParent();
            }
            JobConf launcherJobConf = this.createBaseHadoopConf(context, actionXml);
            launcherJobConf.setBoolean("mapreduce.job.complete.cancel.delegation.tokens", true);
            this.setupLauncherConf((Configuration)launcherJobConf, actionXml, appPathRoot, context);
            if (ConfigurationService.getBoolean(HADOOP_YARN_KILL_CHILD_JOBS_ON_AMRESTART)) {
                long launcherTime = System.currentTimeMillis();
                String coordActionNominalTime = context.getProtoActionConf().get("oozie.coord.action.nominal_time");
                if (coordActionNominalTime != null) {
                    launcherTime = Long.parseLong(coordActionNominalTime);
                } else if (context.getWorkflow().getCreatedTime() != null) {
                    launcherTime = context.getWorkflow().getCreatedTime().getTime();
                }
                String actionYarnTag = this.getActionYarnTag(this.getWorkflowConf(context), context.getWorkflow(), action);
                LauncherMapperHelper.setupYarnRestartHandling(launcherJobConf, actionConf, actionYarnTag, launcherTime);
            } else {
                this.LOG.info(MessageFormat.format("{0} is set to false, not setting YARN restart properties", HADOOP_YARN_KILL_CHILD_JOBS_ON_AMRESTART));
            }
            String actionShareLibProperty = actionConf.get(ACTION_SHARELIB_FOR + this.getType());
            if (actionShareLibProperty != null) {
                launcherJobConf.set(ACTION_SHARELIB_FOR + this.getType(), actionShareLibProperty);
            }
            this.setLibFilesArchives(context, actionXml, appPathRoot, (Configuration)launcherJobConf);
            String jobName = launcherJobConf.get(HADOOP_JOB_NAME);
            if (jobName == null || jobName.isEmpty()) {
                jobName = XLog.format("oozie:launcher:T={0}:W={1}:A={2}:ID={3}", this.getType(), context.getWorkflow().getAppName(), action.getName(), context.getWorkflow().getId());
                launcherJobConf.setJobName(jobName);
            }
            this.injectJobInfo(launcherJobConf, actionConf, context, action);
            this.injectLauncherCallback(context, (Configuration)launcherJobConf);
            String jobId = context.getWorkflow().getId();
            String actionId = action.getId();
            Path actionDir = context.getActionDir();
            String recoveryId = context.getRecoveryId();
            Namespace ns = actionXml.getNamespace();
            Element prepareElement = actionXml.getChild("prepare", ns);
            String prepareXML = "";
            if (prepareElement != null && prepareElement.getChildren().size() > 0) {
                prepareXML = XmlUtils.prettyPrint(prepareElement).toString().trim();
            }
            LauncherMapperHelper.setupLauncherInfo(launcherJobConf, jobId, actionId, actionDir, recoveryId, actionConf, prepareXML);
            LauncherMapperHelper.setupMainClass((Configuration)launcherJobConf, this.getLauncherMain((Configuration)launcherJobConf, actionXml));
            LauncherMapperHelper.setupLauncherURIHandlerConf((Configuration)launcherJobConf);
            LauncherMapperHelper.setupMaxOutputData((Configuration)launcherJobConf, maxActionOutputLen);
            LauncherMapperHelper.setupMaxExternalStatsSize((Configuration)launcherJobConf, maxExternalStatsSize);
            LauncherMapperHelper.setupMaxFSGlob((Configuration)launcherJobConf, maxFSGlobMax);
            List list = actionXml.getChildren("arg", ns);
            String[] args = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                args[i] = ((Element)list.get(i)).getTextTrim();
            }
            LauncherMapperHelper.setupMainArguments((Configuration)launcherJobConf, args);
            StringBuilder opts = new StringBuilder(launcherJobConf.get(HADOOP_CHILD_JAVA_OPTS, ""));
            if (launcherJobConf.get(HADOOP_MAP_JAVA_OPTS) != null) {
                opts.append(" ").append(launcherJobConf.get(HADOOP_MAP_JAVA_OPTS));
            }
            List javaopts = actionXml.getChildren("java-opt", ns);
            for (Element opt : javaopts) {
                opts.append(" ").append(opt.getTextTrim());
            }
            Element opt = actionXml.getChild("java-opts", ns);
            if (opt != null) {
                opts.append(" ").append(opt.getTextTrim());
            }
            launcherJobConf.set(HADOOP_CHILD_JAVA_OPTS, opts.toString().trim());
            launcherJobConf.set(HADOOP_MAP_JAVA_OPTS, opts.toString().trim());
            if (launcherJobConf.getBoolean(HADOOP_YARN_UBER_MODE, false)) {
                if (this.checkPropertiesToDisableUber((Configuration)launcherJobConf)) {
                    launcherJobConf.setBoolean(HADOOP_YARN_UBER_MODE, false);
                } else {
                    this.updateConfForUberMode((Configuration)launcherJobConf);
                }
            }
            this.updateConfForJavaTmpDir((Configuration)launcherJobConf);
            this.actionConfToLauncherConf(actionConf, launcherJobConf);
            return launcherJobConf;
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    private boolean checkPropertiesToDisableUber(Configuration launcherConf) {
        boolean disable = false;
        if (launcherConf.getBoolean(HADOOP_JOB_CLASSLOADER, false)) {
            disable = true;
        } else if (launcherConf.getBoolean(HADOOP_USER_CLASSPATH_FIRST, false)) {
            disable = true;
        }
        return disable;
    }

    private void injectCallback(ActionExecutor.Context context, Configuration conf) {
        String callback = context.getCallbackUrl("$jobStatus");
        if (conf.get("job.end.notification.url") != null) {
            this.LOG.warn("Overriding the action job end notification URI");
        }
        conf.set("job.end.notification.url", callback);
    }

    void injectActionCallback(ActionExecutor.Context context, Configuration actionConf) {
        this.injectCallback(context, actionConf);
    }

    void injectLauncherCallback(ActionExecutor.Context context, Configuration launcherConf) {
        this.injectCallback(context, launcherConf);
    }

    private void actionConfToLauncherConf(Configuration actionConf, JobConf launcherConf) {
        for (String name : SPECIAL_PROPERTIES) {
            if (actionConf.get(name) == null || launcherConf.get("oozie.launcher." + name) != null) continue;
            launcherConf.set(name, actionConf.get(name));
        }
    }

    public void submitLauncher(FileSystem actionFs, ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        JobClient jobClient = null;
        boolean exception = false;
        try {
            RunningJob runningJob;
            Path appPathRoot = new Path(context.getWorkflow().getAppPath());
            if (actionFs.isFile(appPathRoot)) {
                appPathRoot = appPathRoot.getParent();
            }
            Element actionXml = XmlUtils.parseXml(action.getConf());
            JobConf actionConf = this.createBaseHadoopConf(context, actionXml);
            this.setupActionConf((Configuration)actionConf, context, actionXml, appPathRoot);
            this.LOG.debug("Setting LibFilesArchives ");
            this.setLibFilesArchives(context, actionXml, appPathRoot, (Configuration)actionConf);
            String jobName = actionConf.get(HADOOP_JOB_NAME);
            if (jobName == null || jobName.isEmpty()) {
                jobName = XLog.format("oozie:action:T={0}:W={1}:A={2}:ID={3}", this.getType(), context.getWorkflow().getAppName(), action.getName(), context.getWorkflow().getId());
                actionConf.set(HADOOP_JOB_NAME, jobName);
            }
            this.injectActionCallback(context, (Configuration)actionConf);
            if ((actionConf.get(ACL_MODIFY_JOB) == null || actionConf.get(ACL_MODIFY_JOB).trim().equals("")) && context.getWorkflow().getAcl() != null) {
                actionConf.set(ACL_MODIFY_JOB, context.getWorkflow().getAcl());
            }
            JobConf credentialsConf = null;
            HashMap<String, CredentialsProperties> credentialsProperties = this.setCredentialPropertyToActionConf(context, action, (Configuration)actionConf);
            if (credentialsProperties != null) {
                credentialsConf = new JobConf(false);
                XConfiguration.copy((Configuration)actionConf, (Configuration)credentialsConf);
                this.setCredentialTokens(credentialsConf, context, action, credentialsProperties);
                for (Map.Entry entry : credentialsConf) {
                    if (actionConf.get((String)entry.getKey()) != null) continue;
                    actionConf.set((String)entry.getKey(), (String)entry.getValue());
                }
            }
            JobConf launcherJobConf = this.createLauncherConf(actionFs, context, action, actionXml, (Configuration)actionConf);
            this.LOG.debug("Creating Job Client for action " + action.getId());
            jobClient = this.createJobClient(context, launcherJobConf);
            String launcherId = LauncherMapperHelper.getRecoveryId((Configuration)launcherJobConf, context.getActionDir(), context.getRecoveryId());
            boolean alreadyRunning = launcherId != null;
            boolean isUserRetry = ((WorkflowActionBean)action).isUserRetry();
            if (alreadyRunning && !isUserRetry) {
                runningJob = jobClient.getJob(JobID.forName((String)launcherId));
                if (runningJob == null) {
                    String jobTracker = launcherJobConf.get(HADOOP_JOB_TRACKER);
                    throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "JA017", "unknown job [{0}@{1}], cannot recover", launcherId, jobTracker);
                }
            } else {
                this.LOG.debug("Submitting the job through Job Client for action " + action.getId());
                HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
                Token mrdt = jobClient.getDelegationToken(has.getMRDelegationTokenRenewer(launcherJobConf));
                launcherJobConf.getCredentials().addToken(HadoopAccessorService.MR_TOKEN_ALIAS, mrdt);
                if (this.needInjectCredentials() && credentialsConf != null) {
                    for (Token tk : credentialsConf.getCredentials().getAllTokens()) {
                        Text fauxAlias = new Text(tk.getKind() + "_" + tk.getService());
                        this.LOG.debug("ADDING TOKEN: " + fauxAlias);
                        launcherJobConf.getCredentials().addToken(fauxAlias, tk);
                    }
                } else {
                    this.LOG.info("No need to inject credentials.");
                }
                runningJob = jobClient.submitJob(launcherJobConf);
                if (runningJob == null) {
                    throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "JA017", "Error submitting launcher for action [{0}]", action.getId());
                }
                launcherId = runningJob.getID().toString();
                this.LOG.debug("After submission get the launcherId " + launcherId);
            }
            String jobTracker = launcherJobConf.get(HADOOP_JOB_TRACKER);
            String consoleUrl = runningJob.getTrackingURL();
            context.setStartData(launcherId, jobTracker, consoleUrl);
        }
        catch (Exception ex) {
            exception = true;
            throw this.convertException(ex);
        }
        finally {
            if (jobClient != null) {
                try {
                    jobClient.close();
                }
                catch (Exception e) {
                    if (exception) {
                        this.LOG.error((Object)"JobClient error: ", e);
                    }
                    throw this.convertException(e);
                }
            }
        }
    }

    private boolean needInjectCredentials() {
        boolean methodExists = true;
        try {
            Class<?> klass = Class.forName("org.apache.hadoop.mapred.JobConf");
            klass.getMethod("getCredentials", new Class[0]);
        }
        catch (ClassNotFoundException ex) {
            methodExists = false;
        }
        catch (NoSuchMethodException ex) {
            methodExists = false;
        }
        return methodExists;
    }

    protected HashMap<String, CredentialsProperties> setCredentialPropertyToActionConf(ActionExecutor.Context context, WorkflowAction action, Configuration actionConf) throws Exception {
        HashMap<String, CredentialsProperties> credPropertiesMap = null;
        if (context != null && action != null) {
            if (!"true".equals(actionConf.get(OOZIE_CREDENTIALS_SKIP))) {
                XConfiguration wfJobConf = this.getWorkflowConf(context);
                if ("false".equals(actionConf.get(OOZIE_CREDENTIALS_SKIP)) || !wfJobConf.getBoolean(OOZIE_CREDENTIALS_SKIP, ConfigurationService.getBoolean(OOZIE_CREDENTIALS_SKIP))) {
                    credPropertiesMap = this.getActionCredentialsProperties(context, action);
                    if (credPropertiesMap != null) {
                        for (String key : credPropertiesMap.keySet()) {
                            CredentialsProperties prop = credPropertiesMap.get(key);
                            if (prop == null) continue;
                            this.LOG.debug("Credential Properties set for action : " + action.getId());
                            for (String property : prop.getProperties().keySet()) {
                                actionConf.set(property, prop.getProperties().get(property));
                                this.LOG.debug("property : '" + property + "', value : '" + prop.getProperties().get(property) + "'");
                            }
                        }
                    } else {
                        this.LOG.warn("No credential properties found for action : " + action.getId() + ", cred : " + action.getCred());
                    }
                } else {
                    this.LOG.info("Skipping credentials (oozie.credentials.skip=true)");
                }
            } else {
                this.LOG.info("Skipping credentials (oozie.credentials.skip=true)");
            }
        } else {
            this.LOG.warn("context or action is null");
        }
        return credPropertiesMap;
    }

    protected void setCredentialTokens(JobConf jobconf, ActionExecutor.Context context, WorkflowAction action, HashMap<String, CredentialsProperties> credPropertiesMap) throws Exception {
        if (context != null && action != null && credPropertiesMap != null) {
            CredentialsProvider.ensureKerberosLogin();
            for (Map.Entry<String, CredentialsProperties> entry : credPropertiesMap.entrySet()) {
                String credName = entry.getKey();
                CredentialsProperties credProps = entry.getValue();
                if (credProps == null) continue;
                CredentialsProvider credProvider = new CredentialsProvider(credProps.getType());
                Credentials credentialObject = credProvider.createCredentialObject();
                if (credentialObject != null) {
                    credentialObject.addtoJobConf(jobconf, credProps, context);
                    this.LOG.debug("Retrieved Credential '" + credName + "' for action " + action.getId());
                    continue;
                }
                this.LOG.debug("Credentials object is null for name= " + credName + ", type=" + credProps.getType());
                throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "JA020", "Could not load credentials of type [{0}] with name [{1}]]; perhaps it was not defined in oozie-site.xml?", credProps.getType(), credName);
            }
        }
    }

    protected HashMap<String, CredentialsProperties> getActionCredentialsProperties(ActionExecutor.Context context, WorkflowAction action) throws Exception {
        HashMap<String, CredentialsProperties> props = new HashMap<String, CredentialsProperties>();
        if (context != null && action != null) {
            String credsInAction = action.getCred();
            if (credsInAction != null) {
                String[] credNames;
                this.LOG.debug("Get credential '" + credsInAction + "' properties for action : " + action.getId());
                for (String credName : credNames = credsInAction.split(",")) {
                    CredentialsProperties credProps = this.getCredProperties(context, credName);
                    props.put(credName, credProps);
                }
            }
        } else {
            this.LOG.warn("context or action is null");
        }
        return props;
    }

    protected CredentialsProperties getCredProperties(ActionExecutor.Context context, String credName) throws Exception {
        CredentialsProperties credProp = null;
        String workflowXml = ((WorkflowJobBean)context.getWorkflow()).getWorkflowInstance().getApp().getDefinition();
        XConfiguration wfjobConf = this.getWorkflowConf(context);
        Element elementJob = XmlUtils.parseXml(workflowXml);
        Element credentials = elementJob.getChild("credentials", elementJob.getNamespace());
        if (credentials != null) {
            for (Element credential : credentials.getChildren("credential", credentials.getNamespace())) {
                String name = credential.getAttributeValue("name");
                String type = credential.getAttributeValue("type");
                this.LOG.debug("getCredProperties: Name: " + name + ", Type: " + type);
                if (!name.equalsIgnoreCase(credName)) continue;
                credProp = new CredentialsProperties(name, type);
                for (Element property : credential.getChildren("property", credential.getNamespace())) {
                    String propertyName = property.getChildText("name", property.getNamespace());
                    String propertyValue = property.getChildText("value", property.getNamespace());
                    ELEvaluator eval = new ELEvaluator();
                    Iterator i$ = wfjobConf.iterator();
                    while (i$.hasNext()) {
                        Map.Entry entry = (Map.Entry)i$.next();
                        eval.setVariable((String)entry.getKey(), ((String)entry.getValue()).trim());
                    }
                    propertyName = eval.evaluate(propertyName, String.class);
                    propertyValue = eval.evaluate(propertyValue, String.class);
                    credProp.getProperties().put(propertyName, propertyValue);
                    this.LOG.debug("getCredProperties: Properties name :'" + propertyName + "', Value : '" + propertyValue + "'");
                }
            }
        } else {
            this.LOG.debug("credentials is null for the action");
        }
        return credProp;
    }

    @Override
    public void start(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        LogUtils.setLogInfo(action);
        try {
            this.LOG.debug("Starting action " + action.getId() + " getting Action File System");
            FileSystem actionFs = context.getAppFileSystem();
            this.LOG.debug("Preparing action Dir through copying " + context.getActionDir());
            this.prepareActionDir(actionFs, context);
            this.LOG.debug("Action Dir is ready. Submitting the action ");
            this.submitLauncher(actionFs, context, action);
            this.LOG.debug("Action submit completed. Performing check ");
            this.check(context, action);
            this.LOG.debug("Action check is done after submission");
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public void end(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        try {
            String externalStatus = action.getExternalStatus();
            WorkflowAction.Status status = externalStatus.equals(SUCCEEDED) ? WorkflowAction.Status.OK : WorkflowAction.Status.ERROR;
            context.setEndData(status, this.getActionSignal(status));
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
        finally {
            try {
                FileSystem actionFs = context.getAppFileSystem();
                this.cleanUpActionDir(actionFs, context);
            }
            catch (Exception ex) {
                throw this.convertException(ex);
            }
        }
    }

    protected JobClient createJobClient(ActionExecutor.Context context, JobConf jobConf) throws HadoopAccessorException {
        String user = context.getWorkflow().getUser();
        String group = context.getWorkflow().getGroup();
        return Services.get().get(HadoopAccessorService.class).createJobClient(user, jobConf);
    }

    protected RunningJob getRunningJob(ActionExecutor.Context context, WorkflowAction action, JobClient jobClient) throws Exception {
        RunningJob runningJob = jobClient.getJob(JobID.forName((String)action.getExternalId()));
        return runningJob;
    }

    protected String getActualExternalId(WorkflowAction action) {
        return action.getExternalId();
    }

    @Override
    public void check(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        JobClient jobClient = null;
        boolean exception = false;
        LogUtils.setLogInfo(action);
        try {
            Element actionXml = XmlUtils.parseXml(action.getConf());
            FileSystem actionFs = context.getAppFileSystem();
            JobConf jobConf = this.createBaseHadoopConf(context, actionXml);
            jobClient = this.createJobClient(context, jobConf);
            RunningJob runningJob = this.getRunningJob(context, action, jobClient);
            if (runningJob == null) {
                context.setExecutionData(FAILED, null);
                throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "JA017", "Could not lookup launched hadoop Job ID [{0}] which was associated with  action [{1}].  Failing this action!", this.getActualExternalId(action), action.getId());
            }
            if (runningJob.isComplete()) {
                Properties props;
                Path actionDir = context.getActionDir();
                String newId = null;
                Map<String, String> actionData = LauncherMapperHelper.getActionData(actionFs, actionDir, (Configuration)jobConf);
                if (actionData.containsKey("newId")) {
                    newId = actionData.get("newId");
                    String launcherId = action.getExternalId();
                    runningJob = jobClient.getJob(JobID.forName((String)newId));
                    if (runningJob == null) {
                        context.setExternalStatus(FAILED);
                        throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "JA017", "Unknown hadoop job [{0}] associated with action [{1}].  Failing this action!", newId, action.getId());
                    }
                    context.setExternalChildIDs(newId);
                    this.LOG.info(1, "External ID swap, old ID [{0}] new ID [{1}]", launcherId, newId);
                } else {
                    String externalIDs = actionData.get("externalChildIDs");
                    if (externalIDs != null) {
                        context.setExternalChildIDs(externalIDs);
                        this.LOG.info(1, "Hadoop Jobs launched : [{0}]", externalIDs);
                    } else if (LauncherMapperHelper.hasOutputData(actionData) && (props = PropertiesUtils.stringToProperties(actionData.get("output.properties"))).get("hadoopJobs") != null) {
                        externalIDs = (String)props.get("hadoopJobs");
                        context.setExternalChildIDs(externalIDs);
                        this.LOG.info(1, "Hadoop Jobs launched : [{0}]", externalIDs);
                    }
                }
                if (runningJob.isComplete()) {
                    if (newId != null) {
                        actionData = LauncherMapperHelper.getActionData(actionFs, context.getActionDir(), (Configuration)jobConf);
                    }
                    this.LOG.info(1, "action completed, external ID [{0}]", action.getExternalId());
                    if (LauncherMapperHelper.isMainSuccessful(runningJob)) {
                        if (this.getCaptureOutput(action) && LauncherMapperHelper.hasOutputData(actionData)) {
                            context.setExecutionData(SUCCEEDED, PropertiesUtils.stringToProperties(actionData.get("output.properties")));
                            this.LOG.info(1, "action produced output", new Object[0]);
                        } else {
                            context.setExecutionData(SUCCEEDED, null);
                        }
                        if (LauncherMapperHelper.hasStatsData(actionData)) {
                            context.setExecutionStats(actionData.get("stats.properties"));
                            this.LOG.info(1, "action produced stats", new Object[0]);
                        }
                        this.getActionData(actionFs, runningJob, action, context);
                    } else {
                        String errorReason;
                        if (actionData.containsKey("error.properties")) {
                            props = PropertiesUtils.stringToProperties(actionData.get("error.properties"));
                            String errorCode = props.getProperty("error.code");
                            if ("0".equals(errorCode)) {
                                errorCode = "JA018";
                            }
                            if ("-1".equals(errorCode)) {
                                errorCode = "JA019";
                            }
                            errorReason = props.getProperty("error.reason");
                            this.LOG.warn("Launcher ERROR, reason: {0}", errorReason);
                            String exMsg = props.getProperty("exception.message");
                            String errorInfo = exMsg != null ? exMsg : errorReason;
                            context.setErrorInfo(errorCode, errorInfo);
                            String exStackTrace = props.getProperty("exception.stacktrace");
                            if (exMsg != null) {
                                this.LOG.warn("Launcher exception: {0}{E}{1}", exMsg, exStackTrace);
                            }
                        } else {
                            errorReason = XLog.format("LauncherMapper died, check Hadoop LOG for job [{0}:{1}]", action.getTrackerUri(), action.getExternalId());
                            this.LOG.warn(errorReason);
                        }
                        context.setExecutionData(FAILED_KILLED, null);
                    }
                } else {
                    context.setExternalStatus("RUNNING");
                    this.LOG.info(1, "checking action, hadoop job ID [{0}] status [RUNNING]", runningJob.getID());
                }
            } else {
                context.setExternalStatus("RUNNING");
                this.LOG.info(1, "checking action, hadoop job ID [{0}] status [RUNNING]", runningJob.getID());
            }
        }
        catch (Exception ex) {
            this.LOG.warn("Exception in check(). Message[{0}]", ex.getMessage(), ex);
            exception = true;
            throw this.convertException(ex);
        }
        finally {
            if (jobClient != null) {
                try {
                    jobClient.close();
                }
                catch (Exception e) {
                    if (exception) {
                        this.LOG.error((Object)"JobClient error: ", e);
                    }
                    throw this.convertException(e);
                }
            }
        }
    }

    protected void getActionData(FileSystem actionFs, RunningJob runningJob, WorkflowAction action, ActionExecutor.Context context) throws HadoopAccessorException, JDOMException, IOException, URISyntaxException {
    }

    protected boolean getCaptureOutput(WorkflowAction action) throws JDOMException {
        Namespace ns;
        Element eConf = XmlUtils.parseXml(action.getConf());
        Element captureOutput = eConf.getChild("capture-output", ns = eConf.getNamespace());
        return captureOutput != null;
    }

    @Override
    public void kill(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        JobClient jobClient = null;
        boolean exception = false;
        try {
            Element actionXml = XmlUtils.parseXml(action.getConf());
            JobConf jobConf = this.createBaseHadoopConf(context, actionXml);
            jobClient = this.createJobClient(context, jobConf);
            RunningJob runningJob = this.getRunningJob(context, action, jobClient);
            if (runningJob != null) {
                runningJob.killJob();
            }
            context.setExternalStatus(KILLED);
            context.setExecutionData(KILLED, null);
        }
        catch (Exception ex) {
            exception = true;
            throw this.convertException(ex);
        }
        finally {
            try {
                FileSystem actionFs = context.getAppFileSystem();
                this.cleanUpActionDir(actionFs, context);
                if (jobClient != null) {
                    jobClient.close();
                }
            }
            catch (Exception ex) {
                if (exception) {
                    this.LOG.error((Object)"Error: ", ex);
                }
                throw this.convertException(ex);
            }
        }
    }

    @Override
    public boolean isCompleted(String externalStatus) {
        return FINAL_STATUS.contains(externalStatus);
    }

    protected String[] getShareLibNames(ActionExecutor.Context context, Element actionXml, Configuration conf) {
        String[] names = conf.getStrings(ACTION_SHARELIB_FOR + this.getType());
        if (names == null || names.length == 0) {
            try {
                String name;
                XConfiguration jobConf = this.getWorkflowConf(context);
                names = jobConf.getStrings(ACTION_SHARELIB_FOR + this.getType());
                if (!(names != null && names.length != 0 || (names = Services.get().getConf().getStrings(ACTION_SHARELIB_FOR + this.getType())) != null && names.length != 0 || (name = this.getDefaultShareLibName(actionXml)) == null)) {
                    names = new String[]{name};
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("It cannot happen, " + ex.toString(), ex);
            }
        }
        return names;
    }

    protected String getDefaultShareLibName(Element actionXml) {
        return null;
    }

    public String[] getShareLibFilesForActionConf() {
        return null;
    }

    protected void setActionCompletionData(ActionExecutor.Context context, FileSystem actionFs) throws IOException, HadoopAccessorException, URISyntaxException {
    }

    private void injectJobInfo(JobConf launcherJobConf, Configuration actionConf, ActionExecutor.Context context, WorkflowAction action) {
        if (OozieJobInfo.isJobInfoEnabled()) {
            try {
                OozieJobInfo jobInfo = new OozieJobInfo(actionConf, context, action);
                String jobInfoStr = jobInfo.getJobInfo();
                launcherJobConf.set("oozie.job.info", jobInfoStr + "launcher=true");
                actionConf.set("oozie.job.info", jobInfoStr + "launcher=false");
            }
            catch (Exception e) {
                this.LOG.error((Object)"Error while populating job info", e);
            }
        }
    }

    @Override
    public boolean requiresNameNodeJobTracker() {
        return true;
    }

    @Override
    public boolean supportsConfigurationJobXML() {
        return true;
    }

    private XConfiguration getWorkflowConf(ActionExecutor.Context context) throws IOException {
        if (this.workflowConf == null) {
            this.workflowConf = new XConfiguration(new StringReader(context.getWorkflow().getConf()));
        }
        return this.workflowConf;
    }

    static {
        heapPattern = Pattern.compile("-Xmx(([0-9]+)[mMgG])");
        DISALLOWED_PROPERTIES.add(HADOOP_USER);
        DISALLOWED_PROPERTIES.add(HADOOP_JOB_TRACKER);
        DISALLOWED_PROPERTIES.add(HADOOP_NAME_NODE);
        DISALLOWED_PROPERTIES.add(HADOOP_JOB_TRACKER_2);
        DISALLOWED_PROPERTIES.add(HADOOP_YARN_RM);
        SPECIAL_PROPERTIES = new HashSet<String>();
        SPECIAL_PROPERTIES.add(QUEUE_NAME);
        SPECIAL_PROPERTIES.add(ACL_VIEW_JOB);
        SPECIAL_PROPERTIES.add(ACL_MODIFY_JOB);
        FINAL_STATUS = new HashSet<String>();
        FINAL_STATUS.add(SUCCEEDED);
        FINAL_STATUS.add(KILLED);
        FINAL_STATUS.add(FAILED);
        FINAL_STATUS.add(FAILED_KILLED);
    }
}

