/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.StringBlob;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class CoordActionsGetForRecoveryJPAExecutor
implements JPAExecutor<List<CoordinatorActionBean>> {
    private long checkAgeSecs = 0L;

    public CoordActionsGetForRecoveryJPAExecutor(long checkAgeSecs) {
        ParamChecker.notNull(checkAgeSecs, "checkAgeSecs");
        this.checkAgeSecs = checkAgeSecs;
    }

    @Override
    public String getName() {
        return "CoordActionsGetForRecoveryJPAExecutor";
    }

    @Override
    public List<CoordinatorActionBean> execute(EntityManager em) throws JPAExecutorException {
        ArrayList<CoordinatorActionBean> allActions = new ArrayList<CoordinatorActionBean>();
        try {
            CoordinatorActionBean caa;
            Query q = em.createNamedQuery("GET_COORD_ACTIONS_FOR_RECOVERY_OLDER_THAN");
            Timestamp ts = new Timestamp(System.currentTimeMillis() - this.checkAgeSecs * 1000L);
            q.setParameter("lastModifiedTime", (Object)ts);
            List objectArrList = q.getResultList();
            for (Object[] arr : objectArrList) {
                caa = this.getBeanForCoordinatorActionFromArrayForRecovery(arr);
                allActions.add(caa);
            }
            q = em.createNamedQuery("GET_COORD_ACTIONS_WAITING_SUBMITTED_OLDER_THAN");
            q.setParameter("lastModifiedTime", (Object)ts);
            objectArrList = q.getResultList();
            for (Object[] arr : objectArrList) {
                caa = this.getBeanForCoordinatorActionFromArrayForWaiting(arr);
                allActions.add(caa);
            }
            return allActions;
        }
        catch (IllegalStateException e) {
            throw new JPAExecutorException(ErrorCode.E0601, e.getMessage(), e);
        }
    }

    private CoordinatorActionBean getBeanForCoordinatorActionFromArrayForRecovery(Object[] arr) {
        CoordinatorActionBean bean = new CoordinatorActionBean();
        if (arr[0] != null) {
            bean.setId((String)arr[0]);
        }
        if (arr[1] != null) {
            bean.setJobId((String)arr[1]);
        }
        if (arr[2] != null) {
            bean.setStatus(CoordinatorAction.Status.valueOf((String)((String)arr[2])));
        }
        if (arr[3] != null) {
            bean.setExternalId((String)arr[3]);
        }
        if (arr[4] != null) {
            bean.setPending((Integer)arr[4]);
        }
        return bean;
    }

    private CoordinatorActionBean getBeanForCoordinatorActionFromArrayForWaiting(Object[] arr) {
        CoordinatorActionBean bean = new CoordinatorActionBean();
        if (arr[0] != null) {
            bean.setId((String)arr[0]);
        }
        if (arr[1] != null) {
            bean.setJobId((String)arr[1]);
        }
        if (arr[2] != null) {
            bean.setStatus(CoordinatorAction.Status.valueOf((String)((String)arr[2])));
        }
        if (arr[3] != null) {
            bean.setExternalId((String)arr[3]);
        }
        if (arr[4] != null) {
            bean.setPushMissingDependenciesBlob((StringBlob)arr[4]);
        }
        return bean;
    }
}

