/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.QueryExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLARegistrationBean;

public class SLARegistrationQueryExecutor
extends QueryExecutor<SLARegistrationBean, SLARegQuery> {
    private static SLARegistrationQueryExecutor instance = new SLARegistrationQueryExecutor();

    private SLARegistrationQueryExecutor() {
    }

    public static QueryExecutor<SLARegistrationBean, SLARegQuery> getInstance() {
        return instance;
    }

    @Override
    public Query getUpdateQuery(SLARegQuery namedQuery, SLARegistrationBean bean, EntityManager em) throws JPAExecutorException {
        Query query = em.createNamedQuery(namedQuery.name());
        switch (namedQuery) {
            case UPDATE_SLA_REG_ALL: {
                query.setParameter("jobId", (Object)bean.getId());
                query.setParameter("nominalTime", (Object)bean.getNominalTimestamp());
                query.setParameter("expectedStartTime", (Object)bean.getExpectedStartTimestamp());
                query.setParameter("expectedEndTime", (Object)bean.getExpectedEndTimestamp());
                query.setParameter("expectedDuration", (Object)bean.getExpectedDuration());
                query.setParameter("slaConfig", (Object)bean.getSlaConfig());
                query.setParameter("notificationMsg", (Object)bean.getNotificationMsg());
                query.setParameter("upstreamApps", (Object)bean.getUpstreamApps());
                query.setParameter("appType", (Object)bean.getAppType().toString());
                query.setParameter("appName", (Object)bean.getAppName());
                query.setParameter("user", (Object)bean.getUser());
                query.setParameter("parentId", (Object)bean.getParentId());
                query.setParameter("jobData", (Object)bean.getJobData());
                break;
            }
            default: {
                throw new JPAExecutorException(ErrorCode.E0603, "QueryExecutor cannot set parameters for " + namedQuery.name());
            }
        }
        return query;
    }

    @Override
    public Query getSelectQuery(SLARegQuery namedQuery, EntityManager em, Object ... parameters) throws JPAExecutorException {
        Query query = em.createNamedQuery(namedQuery.name());
        switch (namedQuery) {
            case GET_SLA_REG_ALL: 
            case GET_SLA_REG_ON_RESTART: {
                query.setParameter("id", parameters[0]);
                break;
            }
            default: {
                throw new JPAExecutorException(ErrorCode.E0603, "QueryExecutor cannot set parameters for " + namedQuery.name());
            }
        }
        return query;
    }

    @Override
    public int executeUpdate(SLARegQuery namedQuery, SLARegistrationBean jobBean) throws JPAExecutorException {
        JPAService jpaService = Services.get().get(JPAService.class);
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getUpdateQuery(namedQuery, jobBean, em);
        int ret = jpaService.executeUpdate(namedQuery.name(), query, em);
        return ret;
    }

    @Override
    public SLARegistrationBean get(SLARegQuery namedQuery, Object ... parameters) throws JPAExecutorException {
        JPAService jpaService = Services.get().get(JPAService.class);
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getSelectQuery(namedQuery, em, parameters);
        Object ret = jpaService.executeGet(namedQuery.name(), query, em);
        if (ret == null && !namedQuery.equals((Object)SLARegQuery.GET_SLA_REG_ALL)) {
            throw new JPAExecutorException(ErrorCode.E0604, query.toString());
        }
        SLARegistrationBean bean = this.constructBean(namedQuery, ret, parameters);
        return bean;
    }

    @Override
    public List<SLARegistrationBean> getList(SLARegQuery namedQuery, Object ... parameters) throws JPAExecutorException {
        JPAService jpaService = Services.get().get(JPAService.class);
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getSelectQuery(namedQuery, em, parameters);
        List<SLARegistrationBean> beanList = jpaService.executeGetList(namedQuery.name(), query, em);
        return beanList;
    }

    private SLARegistrationBean constructBean(SLARegQuery namedQuery, Object ret, Object ... parameters) throws JPAExecutorException {
        SLARegistrationBean bean;
        switch (namedQuery) {
            case GET_SLA_REG_ALL: {
                bean = (SLARegistrationBean)ret;
                if (bean == null) break;
                bean.setSlaConfig(bean.getSlaConfig());
                break;
            }
            case GET_SLA_REG_ON_RESTART: {
                bean = new SLARegistrationBean();
                Object[] arr = (Object[])ret;
                bean.setNotificationMsg((String)arr[0]);
                bean.setUpstreamApps((String)arr[1]);
                bean.setSlaConfig((String)arr[2]);
                bean.setJobData((String)arr[3]);
                break;
            }
            default: {
                throw new JPAExecutorException(ErrorCode.E0603, "QueryExecutor cannot construct job bean for " + namedQuery.name());
            }
        }
        return bean;
    }

    @Override
    public Object getSingleValue(SLARegQuery namedQuery, Object ... parameters) throws JPAExecutorException {
        throw new UnsupportedOperationException();
    }

    public static enum SLARegQuery {
        UPDATE_SLA_REG_ALL,
        GET_SLA_REG_ALL,
        GET_SLA_REG_ON_RESTART;

    }
}

