/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.control.EndActionExecutor;
import org.apache.oozie.action.control.ForkActionExecutor;
import org.apache.oozie.action.control.JoinActionExecutor;
import org.apache.oozie.action.control.KillActionExecutor;
import org.apache.oozie.action.control.StartActionExecutor;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;

public class ActionService
implements Service,
Instrumentable {
    public static final String CONF_ACTION_EXECUTOR_CLASSES = "oozie.service.ActionService.executor.classes";
    public static final String CONF_ACTION_EXECUTOR_EXT_CLASSES = "oozie.service.ActionService.executor.ext.classes";
    private Services services;
    private Map<String, Class<? extends ActionExecutor>> executors;
    private static XLog LOG = XLog.getLog(ActionService.class);

    @Override
    public void init(Services services) throws ServiceException {
        this.services = services;
        ActionExecutor.enableInit();
        ActionExecutor.resetInitInfo();
        ActionExecutor.disableInit();
        this.executors = new HashMap<String, Class<? extends ActionExecutor>>();
        Class[] classes = new Class[]{StartActionExecutor.class, EndActionExecutor.class, KillActionExecutor.class, ForkActionExecutor.class, JoinActionExecutor.class};
        this.registerExecutors(classes);
        classes = ConfigurationService.getClasses(services.getConf(), CONF_ACTION_EXECUTOR_CLASSES);
        this.registerExecutors(classes);
        classes = ConfigurationService.getClasses(services.getConf(), CONF_ACTION_EXECUTOR_EXT_CLASSES);
        this.registerExecutors(classes);
        this.initExecutors();
    }

    private void registerExecutors(Class<? extends ActionExecutor>[] classes) {
        if (classes != null) {
            for (Class<? extends ActionExecutor> executorClass : classes) {
                ActionExecutor executor = (ActionExecutor)ReflectionUtils.newInstance(executorClass, (Configuration)this.services.getConf());
                this.executors.put(executor.getType(), executorClass);
            }
        }
    }

    private void initExecutors() {
        for (Class<? extends ActionExecutor> executorClass : this.executors.values()) {
            this.initExecutor(executorClass);
        }
        LOG.info("Initialized action types: " + this.getActionTypes());
    }

    @Override
    public void destroy() {
        ActionExecutor.enableInit();
        ActionExecutor.resetInitInfo();
        ActionExecutor.disableInit();
        this.executors = null;
    }

    @Override
    public Class<? extends Service> getInterface() {
        return ActionService.class;
    }

    @Override
    public void instrument(Instrumentation instr) {
        instr.addVariable("configuration", "action.types", new Instrumentation.Variable<String>(){

            @Override
            public String getValue() {
                Set<String> actionTypes = ActionService.this.getActionTypes();
                if (actionTypes != null) {
                    return actionTypes.toString();
                }
                return "(unavailable)";
            }
        });
    }

    @VisibleForTesting
    public void registerAndInitExecutor(Class<? extends ActionExecutor> klass) {
        ActionExecutor.enableInit();
        ActionExecutor.resetInitInfo();
        ActionExecutor.disableInit();
        this.registerExecutors(new Class[]{klass});
        this.initExecutors();
    }

    private void initExecutor(Class<? extends ActionExecutor> klass) {
        ActionExecutor executor = (ActionExecutor)ReflectionUtils.newInstance(klass, (Configuration)this.services.getConf());
        LOG.debug("Initializing action type [{0}] class [{1}]", executor.getType(), klass);
        ActionExecutor.enableInit();
        executor.initActionType();
        ActionExecutor.disableInit();
        LOG.trace("Initialized Executor for action type [{0}] class [{1}]", executor.getType(), klass);
    }

    public ActionExecutor getExecutor(String actionType) {
        ParamChecker.notEmpty(actionType, "actionType");
        Class<? extends ActionExecutor> executorClass = this.executors.get(actionType);
        return executorClass != null ? (ActionExecutor)ReflectionUtils.newInstance(executorClass, null) : null;
    }

    Set<String> getActionTypes() {
        return this.executors.keySet();
    }
}

