/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import com.codahale.metrics.Counter;
import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Timer;
import com.codahale.metrics.json.MetricsModule;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XLog;

public class MetricsInstrumentation
extends Instrumentation {
    private final MetricRegistry metricRegistry = new MetricRegistry();
    private transient ObjectMapper jsonMapper;
    private ScheduledExecutorService scheduler;
    private final LoadingCache<String, Counter> counters;
    private final Map<String, Gauge> gauges;
    private final LoadingCache<String, Timer> timers;
    private final Map<String, Histogram> histograms;
    private Lock timersLock = new ReentrantLock();
    private Lock gaugesLock = new ReentrantLock();
    private Lock countersLock = new ReentrantLock();
    private Lock histogramsLock = new ReentrantLock();
    private static final TimeUnit RATE_UNIT = TimeUnit.MILLISECONDS;
    private static final TimeUnit DURATION_UNIT = TimeUnit.MILLISECONDS;

    public MetricsInstrumentation() {
        this.jsonMapper = new ObjectMapper().registerModule((Module)new MetricsModule(RATE_UNIT, DURATION_UNIT, false));
        MemoryUsageGaugeSet memorySet = new MemoryUsageGaugeSet();
        for (String key : memorySet.getMetrics().keySet()) {
            this.metricRegistry.register(MetricRegistry.name((String)"jvm", (String[])new String[]{"memory", key}), (Metric)memorySet.getMetrics().get(key));
        }
        this.counters = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Counter>(){

            public Counter load(String key) throws Exception {
                Counter counter = new Counter();
                MetricsInstrumentation.this.metricRegistry.register(key, (Metric)counter);
                return counter;
            }
        });
        this.timers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Timer>(){

            public Timer load(String key) throws Exception {
                Timer timer = new Timer((Reservoir)new ExponentiallyDecayingReservoir());
                MetricsInstrumentation.this.metricRegistry.register(key, (Metric)timer);
                return timer;
            }
        });
        this.gauges = new ConcurrentHashMap<String, Gauge>();
        this.histograms = new ConcurrentHashMap<String, Histogram>();
    }

    @Override
    public void addCron(String group, String name, Instrumentation.Cron cron) {
        String key = MetricRegistry.name((String)group, (String[])new String[]{name, "timer"});
        try {
            this.timersLock.lock();
            Timer timer = (Timer)this.timers.get((Object)key);
            timer.update(cron.getOwn(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee);
        }
        finally {
            this.timersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVariable(String group, String name, final Instrumentation.Variable variable) {
        Gauge gauge = new Gauge(){

            public Object getValue() {
                return variable.getValue();
            }
        };
        String key = MetricRegistry.name((String)group, (String[])new String[]{name});
        try {
            this.gaugesLock.lock();
            this.gauges.put(key, gauge);
            if (this.metricRegistry.getGauges().containsKey(key)) {
                XLog.getLog(MetricsInstrumentation.class).debug("A Variable with name [" + key + "] already exists. " + " The old Variable will be overwritten, but this is not recommended");
                this.metricRegistry.remove(key);
            }
            this.metricRegistry.register(key, (Metric)gauge);
        }
        finally {
            this.gaugesLock.unlock();
        }
    }

    @Override
    public void incr(String group, String name, long count) {
        String key = MetricRegistry.name((String)group, (String[])new String[]{name});
        try {
            this.countersLock.lock();
            ((Counter)this.counters.get((Object)key)).inc(count);
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee);
        }
        finally {
            this.countersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSampler(String group, String name, int period, int interval, Instrumentation.Variable<Long> variable) {
        if (this.scheduler == null) {
            throw new IllegalStateException("scheduler not set, cannot sample");
        }
        Histogram histogram = new Histogram((Reservoir)new ExponentiallyDecayingReservoir());
        Sampler sampler = new Sampler(variable, histogram);
        this.scheduler.scheduleAtFixedRate(sampler, 0L, interval, TimeUnit.SECONDS);
        String key = MetricRegistry.name((String)group, (String[])new String[]{name, "histogram"});
        try {
            this.histogramsLock.lock();
            this.histograms.put(key, histogram);
            if (this.metricRegistry.getHistograms().containsKey(key)) {
                XLog.getLog(MetricsInstrumentation.class).debug("A Sampler with name [" + key + "] already exists. " + " The old Sampler will be overwritten, but this is not recommended");
                this.metricRegistry.remove(key);
            }
            this.metricRegistry.register(key, (Metric)histogram);
        }
        finally {
            this.histogramsLock.unlock();
        }
    }

    @Override
    public void setScheduler(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public String toString() {
        try {
            return this.jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.metricRegistry);
        }
        catch (JsonProcessingException jpe) {
            throw new RuntimeException(jpe);
        }
    }

    public void writeJSONResponse(OutputStream os) throws IOException {
        this.jsonMapper.writer().writeValue(os, (Object)this.metricRegistry);
    }

    @VisibleForTesting
    MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    @Override
    public Map<String, Map<String, Map<String, Object>>> getAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Map<String, Instrumentation.Element<Long>>> getCounters() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Map<String, Instrumentation.Element<Double>>> getSamplers() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Map<String, Instrumentation.Element<Instrumentation.Timer>>> getTimers() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Map<String, Instrumentation.Element<Instrumentation.Variable>>> getVariables() {
        throw new UnsupportedOperationException();
    }

    public static class Sampler
    implements Runnable {
        private final Instrumentation.Variable<Long> variable;
        private final Histogram histogram;

        public Sampler(Instrumentation.Variable<Long> variable, Histogram histogram) {
            this.variable = variable;
            this.histogram = histogram;
        }

        @Override
        public void run() {
            this.histogram.update(((Long)this.variable.getValue()).longValue());
        }
    }
}

