/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client.retry;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.URL;

public abstract class ConnectionRetriableClient {
    private final int retryCount;

    public ConnectionRetriableClient(int retryCount) {
        this.retryCount = retryCount;
    }

    public Object execute(URL url, String method) throws IOException {
        int numTries = 0;
        boolean stopRetry = false;
        Exception cliException = null;
        while (numTries < this.retryCount && !stopRetry) {
            try {
                return this.doExecute(url, method);
            }
            catch (ConnectException e) {
                this.sleep(e, numTries++);
                cliException = e;
            }
            catch (SocketException e) {
                if (method.equals("POST") || method.equals("PUT")) {
                    stopRetry = true;
                } else {
                    this.sleep(e, numTries++);
                }
                cliException = e;
            }
            catch (Exception e) {
                stopRetry = true;
                cliException = e;
                ++numTries;
            }
        }
        throw new IOException("Error while connecting Oozie server. No of retries = " + numTries + ". Exception = " + cliException.getMessage(), cliException);
    }

    private void sleep(Exception e, int numTries) {
        try {
            long wait = this.getWaitTimeExp(numTries);
            System.err.println("Connection exception has occurred [ " + e.getClass().getName() + " " + e.getMessage() + " ]. Trying after " + wait / 1000L + " sec." + " Retry count = " + (numTries + 1));
            Thread.sleep(wait);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private long getWaitTimeExp(int retryCount) {
        long waitTime = (long)Math.pow(2.0, retryCount) * 1000L;
        return waitTime;
    }

    public abstract Object doExecute(URL var1, String var2) throws Exception;
}

