/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.mapreduce.converter.converters;

import org.apache.hadoop.io.DoubleWritable;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.mapreduce.converter.TypeConversionException;
import org.pentaho.hadoop.mapreduce.converter.TypeConverterFactory;
import org.pentaho.hadoop.mapreduce.converter.spi.ITypeConverter;

public class KettleTypeToDoubleWritableConverter
implements ITypeConverter<Object, DoubleWritable> {
    @Override
    public boolean canConvert(Class from, Class to) {
        return TypeConverterFactory.isKettleType(from) && DoubleWritable.class.equals((Object)to);
    }

    @Override
    public DoubleWritable convert(ValueMetaInterface meta, Object obj) throws TypeConversionException {
        try {
            DoubleWritable result = new DoubleWritable();
            result.set(meta.getNumber(obj).doubleValue());
            return result;
        }
        catch (KettleValueException ex) {
            throw new TypeConversionException(BaseMessages.getString(TypeConverterFactory.class, (String)"ErrorConverting", (Object[])new Object[]{DoubleWritable.class.getSimpleName(), obj}), ex);
        }
    }
}

