/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAnnotationRegistry;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerateStrategy;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;

@SdkInternalApi
final class DynamoDBAutoGeneratorRegistry {
    DynamoDBAutoGeneratorRegistry() {
    }

    final Generator<Object> generatorOf(Class<?> generatedType, DynamoDBAnnotationRegistry.AnnotationMap annotations) {
        if (annotations.isAutoGeneratedKey()) {
            return this.keyGeneratorOf(generatedType);
        }
        if (annotations.isVersion()) {
            return this.versionGeneratorOf(generatedType);
        }
        if (annotations.isAutoGeneratedTimestamp()) {
            return this.timestampGeneratorOf(generatedType, annotations.getAutoGenerateStrategy());
        }
        return this.neverGeneratorOf(generatedType);
    }

    final Generator<Object> neverGeneratorOf(Class<?> generatedType) {
        NeverGenerator<Object> generator = new NeverGenerator<Object>(generatedType);
        return generator;
    }

    final Generator<Object> keyGeneratorOf(Class<?> generatedType) {
        NeverKeyGenerator generator = String.class.isAssignableFrom(generatedType) ? new UuidStringKeyGenerator() : new NeverKeyGenerator(generatedType);
        return generator;
    }

    final Generator<Object> versionGeneratorOf(Class<?> generatedType) {
        NeverVersionGenerator generator = BigInteger.class.isAssignableFrom(generatedType) ? new BigIntegerVersionGenerator() : (Byte.class.isAssignableFrom(generatedType) || Byte.TYPE.isAssignableFrom(generatedType) ? new ByteVersionGenerator() : (Integer.class.isAssignableFrom(generatedType) || Integer.TYPE.isAssignableFrom(generatedType) ? new IntegerVersionGenerator() : (Long.class.isAssignableFrom(generatedType) || Long.TYPE.isAssignableFrom(generatedType) ? new LongVersionGenerator() : (Short.class.isAssignableFrom(generatedType) || Short.TYPE.isAssignableFrom(generatedType) ? new ShortVersionGenerator() : new NeverVersionGenerator(generatedType)))));
        return generator;
    }

    final Generator<Object> timestampGeneratorOf(Class<?> generatedType, DynamoDBAutoGenerateStrategy strategy) {
        NeverTimestampGenerator generator = Calendar.class.isAssignableFrom(generatedType) ? new CalendarTimestampGenerator(strategy) : (Date.class.isAssignableFrom(generatedType) ? new DateTimestampGenerator(strategy) : (Long.class.isAssignableFrom(generatedType) ? new LongTimestampGenerator(strategy) : new NeverTimestampGenerator(generatedType, strategy)));
        return generator;
    }

    static final class LongTimestampGenerator
    extends NeverTimestampGenerator<Long> {
        private static final TimeZone UTC = TimeZone.getTimeZone("UTC");

        private LongTimestampGenerator(DynamoDBAutoGenerateStrategy strategy) {
            super(Long.class, strategy);
        }

        @Override
        public final Long generate(Long currentValue) {
            return Calendar.getInstance(UTC).getTime().getTime();
        }
    }

    static final class DateTimestampGenerator
    extends NeverTimestampGenerator<Date> {
        private DateTimestampGenerator(DynamoDBAutoGenerateStrategy strategy) {
            super(Date.class, strategy);
        }

        @Override
        public final Date generate(Date currentValue) {
            return Calendar.getInstance().getTime();
        }
    }

    static final class CalendarTimestampGenerator
    extends NeverTimestampGenerator<Calendar> {
        private CalendarTimestampGenerator(DynamoDBAutoGenerateStrategy strategy) {
            super(Calendar.class, strategy);
        }

        @Override
        public final Calendar generate(Calendar currentValue) {
            return Calendar.getInstance();
        }
    }

    static class NeverTimestampGenerator<T>
    extends AbstractGenerator<T> {
        private NeverTimestampGenerator(Class<T> generatedType, DynamoDBAutoGenerateStrategy strategy) {
            super(generatedType, strategy);
        }

        @Override
        public T generate(T currentValue) {
            throw new DynamoDBMappingException("Unsupported type for @DynamoDBAutoGeneratedTimestamp; only Calendar, Date, or Long allowed");
        }
    }

    static final class ShortVersionGenerator
    extends NeverVersionGenerator<Short> {
        private ShortVersionGenerator() {
            super(Short.class);
        }

        @Override
        public final Short generate(Short currentValue) {
            if (currentValue == null) {
                return (short)1;
            }
            return (short)(currentValue + 1);
        }
    }

    static final class LongVersionGenerator
    extends NeverVersionGenerator<Long> {
        private LongVersionGenerator() {
            super(Long.class);
        }

        @Override
        public final Long generate(Long currentValue) {
            if (currentValue == null) {
                return 1L;
            }
            return currentValue + 1L;
        }
    }

    static final class IntegerVersionGenerator
    extends NeverVersionGenerator<Integer> {
        private IntegerVersionGenerator() {
            super(Integer.class);
        }

        @Override
        public final Integer generate(Integer currentValue) {
            if (currentValue == null) {
                return 1;
            }
            return currentValue + 1;
        }
    }

    static final class ByteVersionGenerator
    extends NeverVersionGenerator<Byte> {
        private ByteVersionGenerator() {
            super(Byte.class);
        }

        @Override
        public final Byte generate(Byte currentValue) {
            if (currentValue == null) {
                return (byte)1;
            }
            return (byte)((currentValue + 1) % 127);
        }
    }

    static final class BigIntegerVersionGenerator
    extends NeverVersionGenerator<BigInteger> {
        private BigIntegerVersionGenerator() {
            super(BigInteger.class);
        }

        @Override
        public final BigInteger generate(BigInteger currentValue) {
            if (currentValue == null) {
                return BigInteger.ONE;
            }
            return currentValue.add(BigInteger.ONE);
        }
    }

    static class NeverVersionGenerator<T>
    extends AbstractGenerator<T> {
        private NeverVersionGenerator(Class<T> generatedType) {
            super(generatedType, AlwaysGeneratable.instance());
        }

        @Override
        public T generate(T currentValue) {
            throw new DynamoDBMappingException("Unsupported type for @DynamoDBVersionAttribute; only BigInteger, Byte, Integer or Long allowed");
        }
    }

    static final class UuidStringKeyGenerator
    extends NeverKeyGenerator<String> {
        private UuidStringKeyGenerator() {
            super(String.class);
        }

        @Override
        public final String generate(String currentValue) {
            return UUID.randomUUID().toString();
        }
    }

    static class NeverKeyGenerator<T>
    extends AbstractGenerator<T> {
        private NeverKeyGenerator(Class<T> generatedType) {
            super(generatedType, CreateGeneratable.instance());
        }

        @Override
        public T generate(T currentValue) {
            throw new DynamoDBMappingException("Unsupported type for @DynamoDBAutoGeneratedKey; only String allowed");
        }
    }

    static class NeverGenerator<T>
    extends AbstractGenerator<T> {
        private NeverGenerator(Class<T> generatedType) {
            super(generatedType, NeverGeneratable.instance());
        }
    }

    private static abstract class AbstractGenerator<T>
    implements Generator<T> {
        private final Class<T> generatedType;
        private final Generatable<T> generatable;

        private AbstractGenerator(Class<T> generatedType, Generatable<T> generatable) {
            this.generatedType = generatedType;
            this.generatable = generatable;
        }

        private AbstractGenerator(Class<T> generatedType, DynamoDBAutoGenerateStrategy strategy) {
            this(generatedType, DynamoDBAutoGenerateStrategy.CREATE == strategy ? CreateGeneratable.instance() : AlwaysGeneratable.instance());
        }

        private final Class<T> getGeneratedType() {
            return this.generatedType;
        }

        private final Generatable<T> getGeneratable() {
            return this.generatable;
        }

        @Override
        public boolean canGenerate(T currentValue) {
            return this.getGeneratable().canGenerate(currentValue);
        }

        @Override
        public T generate(T currentValue) {
            throw new DynamoDBMappingException("Generate not supported for " + this.getGeneratedType());
        }
    }

    static interface Generator<T>
    extends Generatable<T> {
        public T generate(T var1);
    }

    static final class CreateGeneratable<T>
    implements Generatable<T> {
        private static final Generatable<Object> INSTANCE = new CreateGeneratable<Object>();

        CreateGeneratable() {
        }

        private static final <T> Generatable<T> instance() {
            return INSTANCE;
        }

        @Override
        public final boolean canGenerate(T currentValue) {
            return currentValue == null;
        }
    }

    static final class AlwaysGeneratable<T>
    implements Generatable<T> {
        private static final Generatable<Object> INSTANCE = new AlwaysGeneratable<Object>();

        AlwaysGeneratable() {
        }

        private static final <T> Generatable<T> instance() {
            return INSTANCE;
        }

        @Override
        public final boolean canGenerate(T currentValue) {
            return true;
        }
    }

    static final class NeverGeneratable<T>
    implements Generatable<T> {
        private static final Generatable<Object> INSTANCE = new NeverGeneratable<Object>();

        NeverGeneratable() {
        }

        private static final <T> Generatable<T> instance() {
            return INSTANCE;
        }

        @Override
        public final boolean canGenerate(T currentValue) {
            return false;
        }
    }

    static interface Generatable<T> {
        public boolean canGenerate(T var1);
    }
}

