/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.util.List;
import java.util.Map;

public class KeysAndAttributesJsonMarshaller {
    private static KeysAndAttributesJsonMarshaller instance;

    public void marshall(KeysAndAttributes keysAndAttributes, StructuredJsonGenerator jsonGenerator) {
        if (keysAndAttributes == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, String> expressionAttributeNamesMap;
            List<String> attributesToGetList;
            jsonGenerator.writeStartObject();
            List<Map<String, AttributeValue>> keysList = keysAndAttributes.getKeys();
            if (keysList != null) {
                jsonGenerator.writeFieldName("Keys");
                jsonGenerator.writeStartArray();
                for (Map<String, AttributeValue> keysListValue : keysList) {
                    if (keysListValue == null) continue;
                    jsonGenerator.writeStartObject();
                    for (Map.Entry<Object, Object> entry : keysListValue.entrySet()) {
                        if (entry.getValue() == null) continue;
                        jsonGenerator.writeFieldName((String)entry.getKey());
                        AttributeValueJsonMarshaller.getInstance().marshall((AttributeValue)entry.getValue(), jsonGenerator);
                    }
                    jsonGenerator.writeEndObject();
                }
                jsonGenerator.writeEndArray();
            }
            if ((attributesToGetList = keysAndAttributes.getAttributesToGet()) != null) {
                jsonGenerator.writeFieldName("AttributesToGet");
                jsonGenerator.writeStartArray();
                for (String attributesToGetListValue : attributesToGetList) {
                    if (attributesToGetListValue == null) continue;
                    jsonGenerator.writeValue(attributesToGetListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (keysAndAttributes.getConsistentRead() != null) {
                jsonGenerator.writeFieldName("ConsistentRead").writeValue(keysAndAttributes.getConsistentRead().booleanValue());
            }
            if (keysAndAttributes.getProjectionExpression() != null) {
                jsonGenerator.writeFieldName("ProjectionExpression").writeValue(keysAndAttributes.getProjectionExpression());
            }
            if ((expressionAttributeNamesMap = keysAndAttributes.getExpressionAttributeNames()) != null) {
                jsonGenerator.writeFieldName("ExpressionAttributeNames");
                jsonGenerator.writeStartObject();
                for (Map.Entry<Object, Object> entry : expressionAttributeNamesMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)entry.getKey());
                    jsonGenerator.writeValue((String)entry.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static KeysAndAttributesJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new KeysAndAttributesJsonMarshaller();
        }
        return instance;
    }
}

