/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.registry.util;

import java.util.regex.Pattern;
import org.pentaho.metadata.registry.Entity;
import org.pentaho.metadata.registry.IMetadataRegistry;
import org.pentaho.metadata.registry.RegistryFactory;
import org.pentaho.metadata.registry.Type;

public class RegistryUtil {
    public static final String COMPOUND_ID_SEPARATOR = "~";
    public static final String NULL = "$NULL$";
    public static final String EMPTY = "$EMPTY$";
    private static final Pattern COMPOUND_ID_SEPARATOR_PATTERN = Pattern.compile("~");

    public String generateTypedId(String name, String type) {
        return this.generateCompositeId(type, name);
    }

    public String generateTableId(String databaseName, String schemaName, String tableName) {
        return this.generateCompositeId(databaseName, schemaName, tableName);
    }

    public String generateDocumentId(String documentName, String documentIdOrPath) {
        return this.generateCompositeId(documentName, documentIdOrPath);
    }

    public String generateCompositeId(String ... parts) {
        if (parts == null || parts.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            String s;
            if (i != 0) {
                sb.append(COMPOUND_ID_SEPARATOR);
            }
            if ((s = parts[i]) == null) {
                s = NULL;
            } else if (s.length() == 0) {
                s = EMPTY;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public String[] splitCompositeId(String id) {
        if (id == null) {
            return null;
        }
        String[] parts = COMPOUND_ID_SEPARATOR_PATTERN.split(id);
        for (int i = 0; i < parts.length; ++i) {
            if (NULL.equals(parts[i])) {
                parts[i] = null;
                continue;
            }
            if (!EMPTY.equals(parts[i])) continue;
            parts[i] = "";
        }
        return parts;
    }

    public Entity getTableEntity(String databaseName, String schemaName, String tableName, boolean create) {
        String id = this.generateTableId(databaseName, schemaName, tableName);
        RegistryFactory factory = RegistryFactory.getInstance();
        IMetadataRegistry registry = factory.getMetadataRegistry();
        Entity entity = registry.getEntity(id, Type.TYPE_PHYSICAL_TABLE.getId());
        if (entity == null && create) {
            entity = new Entity(id, tableName, Type.TYPE_PHYSICAL_TABLE.getId());
            registry.addEntity(entity);
        }
        return entity;
    }

    public boolean updateAttribute(String entityId, String typeId, String attrId, long offset) {
        RegistryFactory factory = RegistryFactory.getInstance();
        IMetadataRegistry registry = factory.getMetadataRegistry();
        Entity entity = registry.getEntity(entityId, typeId);
        if (entity == null) {
            return false;
        }
        return this.updateAttribute(entity, attrId, offset);
    }

    public boolean updateAttribute(Entity entity, String attrId, long offset) {
        String attrValue = entity.getAttribute(attrId);
        long newValue = 0L;
        if (attrValue == null) {
            newValue = offset;
        } else {
            long value = Long.parseLong(attrValue);
            newValue = value + offset;
        }
        return this.setAttribute(entity, attrId, newValue);
    }

    public boolean setAttribute(String entityId, String typeId, String attrId, long value) {
        RegistryFactory factory = RegistryFactory.getInstance();
        IMetadataRegistry registry = factory.getMetadataRegistry();
        Entity entity = registry.getEntity(entityId, typeId);
        if (entity == null) {
            return false;
        }
        return this.setAttribute(entity, attrId, Long.toString(value));
    }

    public boolean setAttribute(String entityId, String typeId, String attrId, String value) {
        RegistryFactory factory = RegistryFactory.getInstance();
        IMetadataRegistry registry = factory.getMetadataRegistry();
        Entity entity = registry.getEntity(entityId, typeId);
        if (entity == null) {
            return false;
        }
        return this.setAttribute(entity, attrId, value);
    }

    public boolean setAttribute(Entity entity, String attrId, long value) {
        return this.setAttribute(entity, attrId, Long.toString(value));
    }

    public boolean setAttribute(Entity entity, String attrId, String value) {
        entity.setAttribute(attrId, value);
        return true;
    }
}

