/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.registry;

import org.pentaho.reporting.libraries.fonts.registry.BaselineInfo;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.registry.FontNativeContext;
import org.pentaho.reporting.libraries.fonts.tools.FontStrictGeomUtility;

public class EmptyFontMetrics
implements FontMetrics {
    private long baseSize;
    private long baseWidth;
    private FontNativeContext record;

    public EmptyFontMetrics(FontNativeContext record, double baseWidth, double baseHeight) {
        this.record = record;
        this.baseSize = FontStrictGeomUtility.toInternalValue(baseHeight);
        this.baseWidth = FontStrictGeomUtility.toInternalValue(baseWidth);
    }

    public EmptyFontMetrics(FontNativeContext record, long baseWidth, long baseHeight) {
        this.record = record;
        this.baseWidth = baseWidth;
        this.baseSize = baseHeight;
    }

    @Override
    public boolean isUniformFontMetrics() {
        return true;
    }

    @Override
    public long getAscent() {
        return FontStrictGeomUtility.toInternalValue((double)this.baseSize * 0.7);
    }

    @Override
    public long getDescent() {
        return FontStrictGeomUtility.toInternalValue((double)this.baseSize * 0.3);
    }

    @Override
    public long getLeading() {
        return 0L;
    }

    @Override
    public long getXHeight() {
        return FontStrictGeomUtility.toInternalValue((double)this.baseSize * 0.5);
    }

    @Override
    public long getOverlinePosition() {
        return this.getLeading() - Math.max(1000L, this.baseSize / 20L);
    }

    @Override
    public long getUnderlinePosition() {
        return this.getAscent() + Math.max(1000L, this.baseSize / 20L);
    }

    @Override
    public long getStrikeThroughPosition() {
        return FontStrictGeomUtility.toInternalValue((double)this.getXHeight() * 0.5);
    }

    @Override
    public long getMaxAscent() {
        return this.getAscent();
    }

    @Override
    public long getMaxDescent() {
        return this.getDescent();
    }

    @Override
    public long getMaxHeight() {
        return this.baseSize;
    }

    @Override
    public long getMaxCharAdvance() {
        return this.baseWidth;
    }

    @Override
    public long getCharWidth(int codePoint) {
        return this.baseWidth;
    }

    @Override
    public long getKerning(int previous, int codePoint) {
        return 0L;
    }

    @Override
    public BaselineInfo getBaselines(int c, BaselineInfo info) {
        if (info == null) {
            info = new BaselineInfo();
        }
        long maxAscent = this.getMaxAscent();
        info.setBaseline(1, maxAscent - this.getXHeight());
        info.setBaseline(5, this.getMaxHeight());
        info.setBaseline(3, maxAscent / 2L);
        info.setBaseline(4, maxAscent);
        info.setBaseline(2, maxAscent / 2L);
        info.setBaseline(0, maxAscent - this.getXHeight());
        info.setDominantBaseline(4);
        return info;
    }

    @Override
    public long getItalicAngle() {
        return 0L;
    }

    @Override
    public FontNativeContext getNativeContext() {
        return this.record;
    }
}

