/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.openerp.writer;

import com.debortoliwines.openerp.reporting.di.OpenERPConfiguration;
import com.debortoliwines.openerp.reporting.di.OpenERPFieldInfo;
import com.debortoliwines.openerp.reporting.di.OpenERPFilterInfo;
import java.io.IOException;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PasswordEncryptionService;
import org.pentaho.reporting.engine.classic.extensions.datasources.openerp.OpenERPDataFactory;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class OpenERPDataFactoryHelper {
    public static void writeXML(OpenERPDataFactory dataFactory, XmlWriter xmlWriter) throws IOException {
        OpenERPConfiguration config;
        AttributeList rootAttrs = new AttributeList();
        rootAttrs.addNamespaceDeclaration("data", "http://jfreereport.sourceforge.net/namespaces/datasources/openerp");
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "openerp-datasource", rootAttrs, false);
        AttributeList configAttrs = new AttributeList();
        if (!StringUtils.isEmpty((String)dataFactory.getQueryName())) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "queryName", dataFactory.getQueryName());
        }
        if (!StringUtils.isEmpty((String)(config = dataFactory.getConfig()).getHostName())) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "hostName", config.getHostName());
        }
        configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "portNumber", Integer.toString(config.getPortNumber()));
        if (!StringUtils.isEmpty((String)config.getDatabaseName())) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "databaseName", config.getDatabaseName());
        }
        if (!StringUtils.isEmpty((String)config.getUserName())) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "userName", config.getUserName());
        }
        if (!StringUtils.isEmpty((String)config.getPassword())) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "password", PasswordEncryptionService.getInstance().encrypt(config.getPassword()));
        }
        if (!StringUtils.isEmpty((String)config.getModelName())) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "modelName", config.getModelName());
        }
        if (config.getDataSource() != null) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "dataSource", config.getDataSource().name());
        }
        if (!StringUtils.isEmpty((String)config.getCustomFunctionName())) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "customFunctionName", config.getCustomFunctionName());
        }
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "config", configAttrs, true);
        for (OpenERPFilterInfo filter : config.getFilters()) {
            AttributeList filterAttrs = new AttributeList();
            filterAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "modelPath", filter.getModelPath());
            filterAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "instanceNum", Integer.toString(filter.getInstanceNum()));
            filterAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "operator", filter.getOperator());
            filterAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "fieldName", filter.getFieldName());
            filterAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "comparator", filter.getComparator());
            filterAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "value", filter.getValue().toString());
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "filter", filterAttrs, true);
        }
        for (OpenERPFieldInfo field : config.getSelectedFields()) {
            OpenERPDataFactoryHelper.writeFieldInfo(xmlWriter, field);
        }
        xmlWriter.writeCloseTag();
        xmlWriter.close();
    }

    private static void writeFieldInfo(XmlWriter xmlWriter, OpenERPFieldInfo field) throws IOException {
        AttributeList selectedFieldAttrs = new AttributeList();
        selectedFieldAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "modelName", field.getModelName());
        selectedFieldAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "fieldName", field.getFieldName());
        selectedFieldAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "fieldType", field.getFieldType().name());
        selectedFieldAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "instanceNum", Integer.toString(field.getInstanceNum()));
        selectedFieldAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "sortIndex", Integer.toString(field.getSortIndex()));
        selectedFieldAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "sortDirection", Integer.toString(field.getSortDirection()));
        selectedFieldAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "renamedFieldName", field.getRenamedFieldName());
        selectedFieldAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "relatedChildModelName", field.getRelatedChildModelName());
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/openerp", "selectedField", selectedFieldAttrs, false);
        if (field.getParentField() != null) {
            OpenERPDataFactoryHelper.writeFieldInfo(xmlWriter, field.getParentField());
        }
        xmlWriter.writeCloseTag();
    }
}

