/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.ColumnMatcher;
import com.healthmarketscience.jackcess.ErrorHandler;
import com.healthmarketscience.jackcess.Index;
import com.healthmarketscience.jackcess.IndexCursor;
import com.healthmarketscience.jackcess.JetFormat;
import com.healthmarketscience.jackcess.PageChannel;
import com.healthmarketscience.jackcess.RowId;
import com.healthmarketscience.jackcess.SimpleColumnMatcher;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.UsageMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Cursor
implements Iterable<Map<String, Object>> {
    private static final Log LOG = LogFactory.getLog(Cursor.class);
    public static final boolean MOVE_FORWARD = true;
    public static final boolean MOVE_REVERSE = false;
    private static final ScanPosition FIRST_SCAN_POSITION = new ScanPosition(RowId.FIRST_ROW_ID);
    private static final ScanPosition LAST_SCAN_POSITION = new ScanPosition(RowId.LAST_ROW_ID);
    private final Id _id;
    private final Table _table;
    private final Table.RowState _rowState;
    private final Position _firstPos;
    private final Position _lastPos;
    protected Position _prevPos;
    protected Position _curPos;
    protected ColumnMatcher _columnMatcher = SimpleColumnMatcher.INSTANCE;

    protected Cursor(Id id, Table table, Position firstPos, Position lastPos) {
        this._id = id;
        this._table = table;
        this._rowState = this._table.createRowState();
        this._firstPos = firstPos;
        this._lastPos = lastPos;
        this._curPos = firstPos;
        this._prevPos = firstPos;
    }

    public static Cursor createCursor(Table table) {
        return new TableScanCursor(table);
    }

    public static Cursor createIndexCursor(Table table, Index index) throws IOException {
        return IndexCursor.createCursor(table, index);
    }

    public static Cursor createIndexCursor(Table table, Index index, Object[] startRow, Object[] endRow) throws IOException {
        return IndexCursor.createCursor(table, index, startRow, endRow);
    }

    public static Cursor createIndexCursor(Table table, Index index, Object[] startRow, boolean startInclusive, Object[] endRow, boolean endInclusive) throws IOException {
        return IndexCursor.createCursor(table, index, startRow, startInclusive, endRow, endInclusive);
    }

    public static Map<String, Object> findRow(Table table, Map<String, Object> rowPattern) throws IOException {
        Cursor cursor = Cursor.createCursor(table);
        if (cursor.findRow(rowPattern)) {
            return cursor.getCurrentRow();
        }
        return null;
    }

    public static Object findValue(Table table, Column column, Column columnPattern, Object valuePattern) throws IOException {
        Cursor cursor = Cursor.createCursor(table);
        if (cursor.findRow(columnPattern, valuePattern)) {
            return cursor.getCurrentRowValue(column);
        }
        return null;
    }

    public static Map<String, Object> findRow(Table table, Index index, Map<String, Object> rowPattern) throws IOException {
        Cursor cursor = Cursor.createIndexCursor(table, index);
        if (cursor.findRow(rowPattern)) {
            return cursor.getCurrentRow();
        }
        return null;
    }

    public static Object findValue(Table table, Index index, Column column, Column columnPattern, Object valuePattern) throws IOException {
        Cursor cursor = Cursor.createIndexCursor(table, index);
        if (cursor.findRow(columnPattern, valuePattern)) {
            return cursor.getCurrentRowValue(column);
        }
        return null;
    }

    public Id getId() {
        return this._id;
    }

    public Table getTable() {
        return this._table;
    }

    public JetFormat getFormat() {
        return this.getTable().getFormat();
    }

    public PageChannel getPageChannel() {
        return this.getTable().getPageChannel();
    }

    public ErrorHandler getErrorHandler() {
        return this._rowState.getErrorHandler();
    }

    public void setErrorHandler(ErrorHandler newErrorHandler) {
        this._rowState.setErrorHandler(newErrorHandler);
    }

    public ColumnMatcher getColumnMatcher() {
        return this._columnMatcher;
    }

    public void setColumnMatcher(ColumnMatcher columnMatcher) {
        if (columnMatcher == null) {
            columnMatcher = this.getDefaultColumnMatcher();
        }
        this._columnMatcher = columnMatcher;
    }

    protected ColumnMatcher getDefaultColumnMatcher() {
        return SimpleColumnMatcher.INSTANCE;
    }

    public Savepoint getSavepoint() {
        return new Savepoint(this._id, this._curPos, this._prevPos);
    }

    public void restoreSavepoint(Savepoint savepoint) throws IOException {
        if (!this._id.equals(savepoint.getCursorId())) {
            throw new IllegalArgumentException("Savepoint " + savepoint + " is not valid for this cursor with id " + this._id);
        }
        this.restorePosition(savepoint.getCurrentPosition(), savepoint.getPreviousPosition());
    }

    protected Position getFirstPosition() {
        return this._firstPos;
    }

    protected Position getLastPosition() {
        return this._lastPos;
    }

    public void reset() {
        this.beforeFirst();
    }

    public void beforeFirst() {
        this.reset(true);
    }

    public void afterLast() {
        this.reset(false);
    }

    public boolean isBeforeFirst() throws IOException {
        if (this.getFirstPosition().equals(this._curPos)) {
            return !this.recheckPosition(false);
        }
        return false;
    }

    public boolean isAfterLast() throws IOException {
        if (this.getLastPosition().equals(this._curPos)) {
            return !this.recheckPosition(true);
        }
        return false;
    }

    public boolean isCurrentRowDeleted() throws IOException {
        Table.positionAtRowData(this._rowState, this._curPos.getRowId());
        return this._rowState.isDeleted();
    }

    protected void reset(boolean moveForward) {
        this._prevPos = this._curPos = this.getDirHandler(moveForward).getBeginningPosition();
        this._rowState.reset();
    }

    public Iterable<Map<String, Object>> reverseIterable() {
        return this.reverseIterable(null);
    }

    public Iterable<Map<String, Object>> reverseIterable(final Collection<String> columnNames) {
        return new Iterable<Map<String, Object>>(){

            @Override
            public Iterator<Map<String, Object>> iterator() {
                return new RowIterator(columnNames, false);
            }
        };
    }

    @Override
    public Iterator<Map<String, Object>> iterator() {
        return this.iterator(null);
    }

    public Iterable<Map<String, Object>> iterable(final Collection<String> columnNames) {
        return new Iterable<Map<String, Object>>(){

            @Override
            public Iterator<Map<String, Object>> iterator() {
                return Cursor.this.iterator(columnNames);
            }
        };
    }

    public Iterator<Map<String, Object>> iterator(Collection<String> columnNames) {
        return new RowIterator(columnNames, true);
    }

    public void deleteCurrentRow() throws IOException {
        this._table.deleteRow(this._rowState, this._curPos.getRowId());
    }

    public void updateCurrentRow(Object ... row) throws IOException {
        this._table.updateRow(this._rowState, this._curPos.getRowId(), row);
    }

    public Map<String, Object> getNextRow() throws IOException {
        return this.getNextRow(null);
    }

    public Map<String, Object> getNextRow(Collection<String> columnNames) throws IOException {
        return this.getAnotherRow(columnNames, true);
    }

    public Map<String, Object> getPreviousRow() throws IOException {
        return this.getPreviousRow(null);
    }

    public Map<String, Object> getPreviousRow(Collection<String> columnNames) throws IOException {
        return this.getAnotherRow(columnNames, false);
    }

    private Map<String, Object> getAnotherRow(Collection<String> columnNames, boolean moveForward) throws IOException {
        if (this.moveToAnotherRow(moveForward)) {
            return this.getCurrentRow(columnNames);
        }
        return null;
    }

    public boolean moveToNextRow() throws IOException {
        return this.moveToAnotherRow(true);
    }

    public boolean moveToPreviousRow() throws IOException {
        return this.moveToAnotherRow(false);
    }

    private boolean moveToAnotherRow(boolean moveForward) throws IOException {
        if (this._curPos.equals(this.getDirHandler(moveForward).getEndPosition())) {
            return this.recheckPosition(moveForward);
        }
        return this.moveToAnotherRowImpl(moveForward);
    }

    protected void restorePosition(Position curPos) throws IOException {
        this.restorePosition(curPos, this._curPos);
    }

    protected final void restorePosition(Position curPos, Position prevPos) throws IOException {
        if (!curPos.equals(this._curPos) || !prevPos.equals(this._prevPos)) {
            this.restorePositionImpl(curPos, prevPos);
        }
    }

    protected void restorePositionImpl(Position curPos, Position prevPos) throws IOException {
        this._prevPos = this._curPos;
        this._curPos = curPos;
        this._rowState.reset();
    }

    private boolean recheckPosition(boolean moveForward) throws IOException {
        if (this.isUpToDate()) {
            return false;
        }
        this.restorePosition(this._prevPos);
        return this.moveToAnotherRowImpl(moveForward);
    }

    private boolean moveToAnotherRowImpl(boolean moveForward) throws IOException {
        this._rowState.reset();
        this._prevPos = this._curPos;
        this._curPos = this.findAnotherPosition(this._rowState, this._curPos, moveForward);
        Table.positionAtRowHeader(this._rowState, this._curPos.getRowId());
        return !this._curPos.equals(this.getDirHandler(moveForward).getEndPosition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean findRow(Column columnPattern, Object valuePattern) throws IOException {
        Position curPos = this._curPos;
        Position prevPos = this._prevPos;
        boolean found = false;
        try {
            boolean bl = found = this.findRowImpl(columnPattern, valuePattern);
            return bl;
        }
        finally {
            if (!found) {
                try {
                    this.restorePosition(curPos, prevPos);
                }
                catch (IOException e) {
                    LOG.error((Object)"Failed restoring position", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean findRow(Map<String, Object> rowPattern) throws IOException {
        Position curPos = this._curPos;
        Position prevPos = this._prevPos;
        boolean found = false;
        try {
            boolean bl = found = this.findRowImpl(rowPattern);
            return bl;
        }
        finally {
            if (!found) {
                try {
                    this.restorePosition(curPos, prevPos);
                }
                catch (IOException e) {
                    LOG.error((Object)"Failed restoring position", (Throwable)e);
                }
            }
        }
    }

    public boolean currentRowMatches(Column columnPattern, Object valuePattern) throws IOException {
        return this._columnMatcher.matches(this.getTable(), columnPattern.getName(), valuePattern, this.getCurrentRowValue(columnPattern));
    }

    public boolean currentRowMatches(Map<String, Object> rowPattern) throws IOException {
        Map<String, Object> row = this.getCurrentRow(rowPattern.keySet());
        if (rowPattern.size() != row.size()) {
            return false;
        }
        for (Map.Entry<String, Object> e : row.entrySet()) {
            String columnName = e.getKey();
            if (this._columnMatcher.matches(this.getTable(), columnName, rowPattern.get(columnName), e.getValue())) continue;
            return false;
        }
        return true;
    }

    protected boolean findRowImpl(Column columnPattern, Object valuePattern) throws IOException {
        this.beforeFirst();
        while (this.moveToNextRow()) {
            if (!this.currentRowMatches(columnPattern, valuePattern)) continue;
            return true;
        }
        return false;
    }

    protected boolean findRowImpl(Map<String, Object> rowPattern) throws IOException {
        this.beforeFirst();
        while (this.moveToNextRow()) {
            if (!this.currentRowMatches(rowPattern)) continue;
            return true;
        }
        return false;
    }

    public int moveNextRows(int numRows) throws IOException {
        return this.moveSomeRows(numRows, true);
    }

    public int movePreviousRows(int numRows) throws IOException {
        return this.moveSomeRows(numRows, false);
    }

    private int moveSomeRows(int numRows, boolean moveForward) throws IOException {
        int numMovedRows;
        for (numMovedRows = 0; numMovedRows < numRows && this.moveToAnotherRow(moveForward); ++numMovedRows) {
        }
        return numMovedRows;
    }

    public Map<String, Object> getCurrentRow() throws IOException {
        return this.getCurrentRow(null);
    }

    public Map<String, Object> getCurrentRow(Collection<String> columnNames) throws IOException {
        return this._table.getRow(this._rowState, this._curPos.getRowId(), columnNames);
    }

    public Object getCurrentRowValue(Column column) throws IOException {
        return this._table.getRowValue(this._rowState, this._curPos.getRowId(), column);
    }

    public void setCurrentRowValue(Column column, Object value) throws IOException {
        Object[] row = new Object[this._table.getColumnCount()];
        Arrays.fill(row, Column.KEEP_VALUE);
        column.setRowValue(row, value);
        this._table.updateRow(this._rowState, this._curPos.getRowId(), row);
    }

    protected boolean isUpToDate() {
        return this._rowState.isUpToDate();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " CurPosition " + this._curPos + ", PrevPosition " + this._prevPos;
    }

    protected abstract Position findAnotherPosition(Table.RowState var1, Position var2, boolean var3) throws IOException;

    protected abstract DirHandler getDirHandler(boolean var1);

    private static final class ScanPosition
    extends Position {
        private final RowId _rowId;

        private ScanPosition(RowId rowId) {
            this._rowId = rowId;
        }

        public RowId getRowId() {
            return this._rowId;
        }

        protected boolean equalsImpl(Object o) {
            return this.getRowId().equals(((ScanPosition)o).getRowId());
        }

        public String toString() {
            return "RowId = " + this.getRowId();
        }
    }

    public static abstract class Position {
        protected Position() {
        }

        public final int hashCode() {
            return this.getRowId().hashCode();
        }

        public final boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this.equalsImpl(o);
        }

        public abstract RowId getRowId();

        protected abstract boolean equalsImpl(Object var1);
    }

    public static final class Savepoint {
        private final Id _cursorId;
        private final Position _curPos;
        private final Position _prevPos;

        private Savepoint(Id cursorId, Position curPos, Position prevPos) {
            this._cursorId = cursorId;
            this._curPos = curPos;
            this._prevPos = prevPos;
        }

        public Id getCursorId() {
            return this._cursorId;
        }

        public Position getCurrentPosition() {
            return this._curPos;
        }

        private Position getPreviousPosition() {
            return this._prevPos;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " " + this._cursorId + " CurPosition " + this._curPos + ", PrevPosition " + this._prevPos;
        }
    }

    public static final class Id {
        private final String _tableName;
        private final String _indexName;

        protected Id(Table table, Index index) {
            this._tableName = table.getName();
            this._indexName = index != null ? index.getName() : null;
        }

        public int hashCode() {
            return this._tableName.hashCode();
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && ObjectUtils.equals((Object)this._tableName, (Object)((Id)o)._tableName) && ObjectUtils.equals((Object)this._indexName, (Object)((Id)o)._indexName);
        }

        public String toString() {
            return this.getClass().getSimpleName() + " " + this._tableName + ":" + this._indexName;
        }
    }

    private static final class TableScanCursor
    extends Cursor {
        private final ScanDirHandler _forwardDirHandler = new ForwardScanDirHandler();
        private final ScanDirHandler _reverseDirHandler = new ReverseScanDirHandler();
        private final UsageMap.PageCursor _ownedPagesCursor;

        private TableScanCursor(Table table) {
            super(new Id(table, null), table, FIRST_SCAN_POSITION, LAST_SCAN_POSITION);
            this._ownedPagesCursor = table.getOwnedPagesCursor();
        }

        protected ScanDirHandler getDirHandler(boolean moveForward) {
            return moveForward ? this._forwardDirHandler : this._reverseDirHandler;
        }

        protected boolean isUpToDate() {
            return super.isUpToDate() && this._ownedPagesCursor.isUpToDate();
        }

        protected void reset(boolean moveForward) {
            this._ownedPagesCursor.reset(moveForward);
            super.reset(moveForward);
        }

        protected void restorePositionImpl(Position curPos, Position prevPos) throws IOException {
            if (!(curPos instanceof ScanPosition) || !(prevPos instanceof ScanPosition)) {
                throw new IllegalArgumentException("Restored positions must be scan positions");
            }
            this._ownedPagesCursor.restorePosition(curPos.getRowId().getPageNumber(), prevPos.getRowId().getPageNumber());
            super.restorePositionImpl(curPos, prevPos);
        }

        protected Position findAnotherPosition(Table.RowState rowState, Position curPos, boolean moveForward) throws IOException {
            ScanDirHandler handler = this.getDirHandler(moveForward);
            RowId curRowId = curPos.getRowId();
            Table.positionAtRowHeader(rowState, curRowId);
            int currentRowNumber = curRowId.getRowNumber();
            while (true) {
                currentRowNumber = handler.getAnotherRowNumber(currentRowNumber);
                curRowId = new RowId(curRowId.getPageNumber(), currentRowNumber);
                Table.positionAtRowHeader(rowState, curRowId);
                if (!rowState.isValid()) {
                    curRowId = new RowId(handler.getAnotherPageNumber(), -1);
                    Table.positionAtRowHeader(rowState, curRowId);
                    if (!rowState.isHeaderPageNumberValid()) {
                        return handler.getEndPosition();
                    }
                    currentRowNumber = handler.getInitialRowNumber(rowState.getRowsOnHeaderPage());
                    continue;
                }
                if (!rowState.isDeleted()) break;
            }
            return new ScanPosition(curRowId);
        }

        private final class ReverseScanDirHandler
        extends ScanDirHandler {
            private ReverseScanDirHandler() {
            }

            public Position getBeginningPosition() {
                return TableScanCursor.this.getLastPosition();
            }

            public Position getEndPosition() {
                return TableScanCursor.this.getFirstPosition();
            }

            public int getAnotherRowNumber(int curRowNumber) {
                return curRowNumber - 1;
            }

            public int getAnotherPageNumber() {
                return TableScanCursor.this._ownedPagesCursor.getPreviousPage();
            }

            public int getInitialRowNumber(int rowsOnPage) {
                return rowsOnPage;
            }
        }

        private final class ForwardScanDirHandler
        extends ScanDirHandler {
            private ForwardScanDirHandler() {
            }

            public Position getBeginningPosition() {
                return TableScanCursor.this.getFirstPosition();
            }

            public Position getEndPosition() {
                return TableScanCursor.this.getLastPosition();
            }

            public int getAnotherRowNumber(int curRowNumber) {
                return curRowNumber + 1;
            }

            public int getAnotherPageNumber() {
                return TableScanCursor.this._ownedPagesCursor.getNextPage();
            }

            public int getInitialRowNumber(int rowsOnPage) {
                return -1;
            }
        }

        private abstract class ScanDirHandler
        extends DirHandler {
            private ScanDirHandler() {
            }

            public abstract int getAnotherRowNumber(int var1);

            public abstract int getAnotherPageNumber();

            public abstract int getInitialRowNumber(int var1);
        }
    }

    protected abstract class DirHandler {
        protected DirHandler() {
        }

        public abstract Position getBeginningPosition();

        public abstract Position getEndPosition();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RowIterator
    extends BaseIterator {
        private final boolean _moveForward;

        private RowIterator(Collection<String> columnNames, boolean moveForward) {
            super(columnNames);
            this._moveForward = moveForward;
            Cursor.this.reset(this._moveForward);
        }

        @Override
        protected boolean findNext() throws IOException {
            return Cursor.this.moveToAnotherRow(this._moveForward);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class BaseIterator
    implements Iterator<Map<String, Object>> {
        protected final Collection<String> _columnNames;
        protected Boolean _hasNext;
        protected boolean _validRow;

        protected BaseIterator(Collection<String> columnNames) {
            this._columnNames = columnNames;
        }

        @Override
        public boolean hasNext() {
            if (this._hasNext == null) {
                try {
                    this._hasNext = this.findNext();
                    this._validRow = this._hasNext;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            return this._hasNext;
        }

        @Override
        public Map<String, Object> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                Map<String, Object> rtn = Cursor.this.getCurrentRow(this._columnNames);
                this._hasNext = null;
                return rtn;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void remove() {
            if (this._validRow) {
                try {
                    Cursor.this.deleteCurrentRow();
                    this._validRow = false;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            } else {
                throw new IllegalStateException("Not at valid row");
            }
        }

        protected abstract boolean findNext() throws IOException;
    }
}

