/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.complex;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.complex.Attachment;
import com.healthmarketscience.jackcess.complex.AttachmentColumnInfo;
import com.healthmarketscience.jackcess.complex.ComplexColumnInfo;
import com.healthmarketscience.jackcess.complex.ComplexDataType;
import com.healthmarketscience.jackcess.complex.ComplexValue;
import com.healthmarketscience.jackcess.complex.MultiValueColumnInfo;
import com.healthmarketscience.jackcess.complex.SingleValue;
import com.healthmarketscience.jackcess.complex.UnsupportedColumnInfo;
import com.healthmarketscience.jackcess.complex.UnsupportedValue;
import com.healthmarketscience.jackcess.complex.Version;
import com.healthmarketscience.jackcess.complex.VersionHistoryColumnInfo;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexValueForeignKey
extends Number {
    private static final long serialVersionUID = 20110805L;
    private final Column _column;
    private final int _value;
    private transient List<? extends ComplexValue> _values;

    public ComplexValueForeignKey(Column column, int value) {
        this._column = column;
        this._value = value;
    }

    public int get() {
        return this._value;
    }

    public Column getColumn() {
        return this._column;
    }

    @Override
    public byte byteValue() {
        return (byte)this.get();
    }

    @Override
    public short shortValue() {
        return (short)this.get();
    }

    @Override
    public int intValue() {
        return this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    public ComplexDataType getComplexType() {
        return this.getComplexInfo().getType();
    }

    protected ComplexColumnInfo<? extends ComplexValue> getComplexInfo() {
        return this._column.getComplexInfo();
    }

    protected VersionHistoryColumnInfo getVersionInfo() {
        return (VersionHistoryColumnInfo)this.getComplexInfo();
    }

    protected AttachmentColumnInfo getAttachmentInfo() {
        return (AttachmentColumnInfo)this.getComplexInfo();
    }

    protected MultiValueColumnInfo getMultiValueInfo() {
        return (MultiValueColumnInfo)this.getComplexInfo();
    }

    protected UnsupportedColumnInfo getUnsupportedInfo() {
        return (UnsupportedColumnInfo)this.getComplexInfo();
    }

    public int countValues() throws IOException {
        return this.getComplexInfo().countValues(this.get());
    }

    public List<Map<String, Object>> getRawValues() throws IOException {
        return this.getComplexInfo().getRawValues(this.get());
    }

    public List<? extends ComplexValue> getValues() throws IOException {
        if (this._values == null) {
            this._values = this.getComplexInfo().getValues(this);
        }
        return this._values;
    }

    public List<Version> getVersions() throws IOException {
        if (this.getComplexType() != ComplexDataType.VERSION_HISTORY) {
            throw new UnsupportedOperationException();
        }
        return this.getValues();
    }

    public List<Attachment> getAttachments() throws IOException {
        if (this.getComplexType() != ComplexDataType.ATTACHMENT) {
            throw new UnsupportedOperationException();
        }
        return this.getValues();
    }

    public List<SingleValue> getMultiValues() throws IOException {
        if (this.getComplexType() != ComplexDataType.MULTI_VALUE) {
            throw new UnsupportedOperationException();
        }
        return this.getValues();
    }

    public List<UnsupportedValue> getUnsupportedValues() throws IOException {
        if (this.getComplexType() != ComplexDataType.UNSUPPORTED) {
            throw new UnsupportedOperationException();
        }
        return this.getValues();
    }

    public void reset() {
        this._values = null;
    }

    public Version addVersion(String value) throws IOException {
        return this.addVersion(value, new Date());
    }

    public Version addVersion(String value, Date modifiedDate) throws IOException {
        this.reset();
        Version v = VersionHistoryColumnInfo.newVersion(this, value, modifiedDate);
        this.getVersionInfo().addValue(v);
        return v;
    }

    public Attachment addAttachment(byte[] data) throws IOException {
        return this.addAttachment(null, null, null, data, null, null);
    }

    public Attachment addAttachment(String url, String name, String type, byte[] data, Date timeStamp, Integer flags) throws IOException {
        this.reset();
        Attachment a = AttachmentColumnInfo.newAttachment(this, url, name, type, data, timeStamp, flags);
        this.getAttachmentInfo().addValue(a);
        return a;
    }

    public Attachment updateAttachment(Attachment attachment) throws IOException {
        this.reset();
        this.getAttachmentInfo().updateValue(attachment);
        return attachment;
    }

    public Attachment deleteAttachment(Attachment attachment) throws IOException {
        this.reset();
        this.getAttachmentInfo().deleteValue(attachment);
        return attachment;
    }

    public SingleValue addMultiValue(Object value) throws IOException {
        this.reset();
        SingleValue v = MultiValueColumnInfo.newSingleValue(this, value);
        this.getMultiValueInfo().addValue(v);
        return v;
    }

    public SingleValue updateMultiValue(SingleValue value) throws IOException {
        this.reset();
        this.getMultiValueInfo().updateValue(value);
        return value;
    }

    public SingleValue deleteMultiValue(SingleValue value) throws IOException {
        this.reset();
        this.getMultiValueInfo().deleteValue(value);
        return value;
    }

    public UnsupportedValue addUnsupportedValue(Map<String, ? extends Object> values) throws IOException {
        this.reset();
        UnsupportedValue v = UnsupportedColumnInfo.newValue(this, values);
        this.getUnsupportedInfo().addValue(v);
        return v;
    }

    public UnsupportedValue updateUnsupportedValue(UnsupportedValue value) throws IOException {
        this.reset();
        this.getUnsupportedInfo().updateValue(value);
        return value;
    }

    public UnsupportedValue deleteUnsupportedValue(UnsupportedValue value) throws IOException {
        this.reset();
        this.getUnsupportedInfo().deleteValue(value);
        return value;
    }

    public void deleteAllValues() throws IOException {
        this.reset();
        this.getComplexInfo().deleteAllValues(this);
    }

    private Object writeReplace() throws ObjectStreamException {
        return this._value;
    }

    public int hashCode() {
        return this._value;
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this._value == ((ComplexValueForeignKey)o)._value && this._column == ((ComplexValueForeignKey)o)._column;
    }

    public String toString() {
        return String.valueOf(this._value);
    }
}

