/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.history;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.history.HiveHistory;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.util.StringUtils;

public class HiveHistoryImpl
implements HiveHistory {
    PrintWriter histStream;
    String histFileName;
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.exec.HiveHistoryImpl");
    private static final Random randGen = new Random();
    private SessionState.LogHelper console;
    private Map<String, String> idToTableMap = null;
    private final HashMap<String, HiveHistory.QueryInfo> queryInfoMap = new HashMap();
    private final HashMap<String, HiveHistory.TaskInfo> taskInfoMap = new HashMap();
    private static final String DELIMITER = " ";
    private static final String ROW_COUNT_PATTERN = "RECORDS_OUT_(\\d+)(_)*(\\S+)*";
    private static final Pattern rowCountPattern = Pattern.compile("RECORDS_OUT_(\\d+)(_)*(\\S+)*");
    static ThreadLocal<Map<String, String>> ctrMapFactory = new ThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> initialValue() {
            return new HashMap<String, String>();
        }
    };

    public HiveHistoryImpl(SessionState ss) {
        try {
            this.console = new SessionState.LogHelper(LOG);
            String conf_file_loc = ss.getConf().getVar(HiveConf.ConfVars.HIVEHISTORYFILELOC);
            if (conf_file_loc == null || conf_file_loc.length() == 0) {
                this.console.printError("No history file location given");
                return;
            }
            File histDir = new File(conf_file_loc);
            if (!histDir.exists() && !histDir.mkdirs()) {
                this.console.printError("Unable to create log directory " + conf_file_loc);
                return;
            }
            do {
                this.histFileName = conf_file_loc + File.separator + "hive_job_log_" + ss.getSessionId() + "_" + Math.abs(randGen.nextInt()) + ".txt";
            } while (!new File(this.histFileName).createNewFile());
            this.console.printInfo("Hive history file=" + this.histFileName);
            this.histStream = new PrintWriter(this.histFileName);
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put(HiveHistory.Keys.SESSION_ID.name(), ss.getSessionId());
            this.log(HiveHistory.RecordTypes.SessionStart, hm);
        }
        catch (IOException e) {
            this.console.printError("FAILED: Failed to open Query Log : " + this.histFileName + DELIMITER + e.getMessage(), "\n" + StringUtils.stringifyException((Throwable)e));
        }
    }

    @Override
    public String getHistFileName() {
        return this.histFileName;
    }

    void log(HiveHistory.RecordTypes rt, Map<String, String> keyValMap) {
        if (this.histStream == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(rt.name());
        for (Map.Entry<String, String> ent : keyValMap.entrySet()) {
            sb.append(DELIMITER);
            String key = ent.getKey();
            String val = ent.getValue();
            if (val != null) {
                val = val.replace(System.getProperty("line.separator"), DELIMITER);
            }
            sb.append(key + "=\"" + val + "\"");
        }
        sb.append(DELIMITER);
        sb.append(HiveHistory.Keys.TIME.name() + "=\"" + System.currentTimeMillis() + "\"");
        this.histStream.println(sb);
        this.histStream.flush();
    }

    @Override
    public void startQuery(String cmd, String id) {
        SessionState ss = SessionState.get();
        if (ss == null) {
            return;
        }
        HiveHistory.QueryInfo ji = new HiveHistory.QueryInfo();
        ji.hm.put(HiveHistory.Keys.QUERY_ID.name(), id);
        ji.hm.put(HiveHistory.Keys.QUERY_STRING.name(), cmd);
        this.queryInfoMap.put(id, ji);
        this.log(HiveHistory.RecordTypes.QueryStart, ji.hm);
    }

    @Override
    public void setQueryProperty(String queryId, HiveHistory.Keys propName, String propValue) {
        HiveHistory.QueryInfo ji = this.queryInfoMap.get(queryId);
        if (ji == null) {
            return;
        }
        ji.hm.put(propName.name(), propValue);
    }

    @Override
    public void setTaskProperty(String queryId, String taskId, HiveHistory.Keys propName, String propValue) {
        String id = queryId + ":" + taskId;
        HiveHistory.TaskInfo ti = this.taskInfoMap.get(id);
        if (ti == null) {
            return;
        }
        ti.hm.put(propName.name(), propValue);
    }

    @Override
    public void setTaskCounters(String queryId, String taskId, Counters ctrs) {
        String id = queryId + ":" + taskId;
        HiveHistory.QueryInfo ji = this.queryInfoMap.get(queryId);
        StringBuilder sb1 = new StringBuilder("");
        HiveHistory.TaskInfo ti = this.taskInfoMap.get(id);
        if (ti == null || ctrs == null) {
            return;
        }
        StringBuilder sb = new StringBuilder("");
        try {
            boolean first = true;
            for (Counters.Group group : ctrs) {
                for (Counters.Counter counter : group) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(',');
                    }
                    sb.append(group.getDisplayName());
                    sb.append('.');
                    sb.append(counter.getDisplayName());
                    sb.append(':');
                    sb.append(counter.getCounter());
                    String tab = this.getRowCountTableName(counter.getDisplayName());
                    if (tab == null) continue;
                    if (sb1.length() > 0) {
                        sb1.append(",");
                    }
                    sb1.append(tab);
                    sb1.append('~');
                    sb1.append(counter.getCounter());
                    ji.rowCountMap.put(tab, counter.getCounter());
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)StringUtils.stringifyException((Throwable)e));
        }
        if (sb1.length() > 0) {
            this.taskInfoMap.get((Object)id).hm.put(HiveHistory.Keys.ROWS_INSERTED.name(), sb1.toString());
            this.queryInfoMap.get((Object)queryId).hm.put(HiveHistory.Keys.ROWS_INSERTED.name(), sb1.toString());
        }
        if (sb.length() > 0) {
            this.taskInfoMap.get((Object)id).hm.put(HiveHistory.Keys.TASK_COUNTERS.name(), sb.toString());
        }
    }

    @Override
    public void printRowCount(String queryId) {
        HiveHistory.QueryInfo ji = this.queryInfoMap.get(queryId);
        if (ji == null) {
            return;
        }
        for (String tab : ji.rowCountMap.keySet()) {
            this.console.printInfo(ji.rowCountMap.get(tab) + " Rows loaded to " + tab);
        }
    }

    @Override
    public void endQuery(String queryId) {
        HiveHistory.QueryInfo ji = this.queryInfoMap.get(queryId);
        if (ji == null) {
            return;
        }
        this.log(HiveHistory.RecordTypes.QueryEnd, ji.hm);
        this.queryInfoMap.remove(queryId);
    }

    @Override
    public void startTask(String queryId, Task<? extends Serializable> task, String taskName) {
        SessionState ss = SessionState.get();
        if (ss == null) {
            return;
        }
        HiveHistory.TaskInfo ti = new HiveHistory.TaskInfo();
        ti.hm.put(HiveHistory.Keys.QUERY_ID.name(), ss.getQueryId());
        ti.hm.put(HiveHistory.Keys.TASK_ID.name(), task.getId());
        ti.hm.put(HiveHistory.Keys.TASK_NAME.name(), taskName);
        String id = queryId + ":" + task.getId();
        this.taskInfoMap.put(id, ti);
        this.log(HiveHistory.RecordTypes.TaskStart, ti.hm);
    }

    @Override
    public void endTask(String queryId, Task<? extends Serializable> task) {
        String id = queryId + ":" + task.getId();
        HiveHistory.TaskInfo ti = this.taskInfoMap.get(id);
        if (ti == null) {
            return;
        }
        this.log(HiveHistory.RecordTypes.TaskEnd, ti.hm);
        this.taskInfoMap.remove(id);
    }

    @Override
    public void progressTask(String queryId, Task<? extends Serializable> task) {
        String id = queryId + ":" + task.getId();
        HiveHistory.TaskInfo ti = this.taskInfoMap.get(id);
        if (ti == null) {
            return;
        }
        this.log(HiveHistory.RecordTypes.TaskProgress, ti.hm);
    }

    @Override
    public void logPlanProgress(QueryPlan plan) throws IOException {
        if (plan != null) {
            Map<String, String> ctrmap = ctrMapFactory.get();
            ctrmap.put("plan", plan.toString());
            this.log(HiveHistory.RecordTypes.Counters, ctrmap);
        }
    }

    @Override
    public void setIdToTableMap(Map<String, String> map) {
        this.idToTableMap = map;
    }

    String getRowCountTableName(String name) {
        if (this.idToTableMap == null) {
            return null;
        }
        Matcher m = rowCountPattern.matcher(name);
        if (m.find()) {
            String tuple = m.group(1);
            String tableName = m.group(3);
            if (tableName != null) {
                return tableName;
            }
            return this.idToTableMap.get(tuple);
        }
        return null;
    }

    @Override
    public void closeStream() {
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.histStream});
    }

    public void finalize() throws Throwable {
        this.closeStream();
        super.finalize();
    }
}

