/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveVariableSource;
import org.apache.hadoop.hive.conf.VariableSubstitution;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.QBParseInfo;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;

public class ColumnStatsSemanticAnalyzer
extends SemanticAnalyzer {
    private static final Log LOG = LogFactory.getLog(ColumnStatsSemanticAnalyzer.class);
    private ASTNode originalTree;
    private ASTNode rewrittenTree;
    private String rewrittenQuery;
    private Context ctx;
    private boolean isRewritten;
    private boolean isTableLevel;
    private List<String> colNames;
    private List<String> colType;
    private Table tbl;

    public ColumnStatsSemanticAnalyzer(HiveConf conf) throws SemanticException {
        super(conf);
    }

    private boolean shouldRewrite(ASTNode tree) {
        ASTNode child1;
        ASTNode child0;
        boolean rwt = false;
        if (tree.getChildCount() > 1 && (child0 = (ASTNode)tree.getChild(0)).getToken().getType() == 847 && (child0 = (ASTNode)child0.getChild(0)).getToken().getType() == 875 && (child1 = (ASTNode)tree.getChild(1)).getToken().getType() == 58) {
            rwt = true;
        }
        return rwt;
    }

    private boolean isPartitionLevelStats(ASTNode tree) {
        boolean isPartitioned = false;
        ASTNode child = (ASTNode)tree.getChild(0);
        if (child.getChildCount() > 1 && (child = (ASTNode)child.getChild(1)).getToken().getType() == 767) {
            isPartitioned = true;
        }
        return isPartitioned;
    }

    private Table getTable(ASTNode tree) throws SemanticException {
        String tableName = ColumnStatsSemanticAnalyzer.getUnescapedName((ASTNode)tree.getChild(0).getChild(0));
        String currentDb = SessionState.get().getCurrentDatabase();
        String[] names = Utilities.getDbTableName(currentDb, tableName);
        return this.getTable(names[0], names[1], true);
    }

    private Map<String, String> getPartKeyValuePairsFromAST(ASTNode tree) {
        ASTNode child = (ASTNode)tree.getChild(0).getChild(1);
        HashMap<String, String> partSpec = new HashMap<String, String>();
        if (null == child) {
            return partSpec;
        }
        for (int i = 0; i < child.getChildCount(); ++i) {
            String partValue;
            String partKey = new String(ColumnStatsSemanticAnalyzer.getUnescapedName((ASTNode)child.getChild(i).getChild(0))).toLowerCase();
            if (child.getChild(i).getChildCount() > 1) {
                partValue = new String(ColumnStatsSemanticAnalyzer.getUnescapedName((ASTNode)child.getChild(i).getChild(1)));
                partValue = partValue.replaceAll("'", "");
            } else {
                partValue = null;
            }
            partSpec.put(partKey, partValue);
        }
        return partSpec;
    }

    private List<String> getColumnName(ASTNode tree) throws SemanticException {
        switch (tree.getChildCount()) {
            case 2: {
                return Utilities.getColumnNamesFromFieldSchema(this.tbl.getCols());
            }
            case 3: {
                int numCols = tree.getChild(2).getChildCount();
                LinkedList<String> colName = new LinkedList<String>();
                for (int i = 0; i < numCols; ++i) {
                    colName.add(i, new String(ColumnStatsSemanticAnalyzer.getUnescapedName((ASTNode)tree.getChild(2).getChild(i))));
                }
                return colName;
            }
        }
        throw new SemanticException("Internal error. Expected number of children of ASTNode to be either 2 or 3. Found : " + tree.getChildCount());
    }

    private void handlePartialPartitionSpec(Map<String, String> partSpec) throws SemanticException {
        int partValsSpecified = 0;
        for (String partKey : partSpec.keySet()) {
            partValsSpecified += partSpec.get(partKey) == null ? 0 : 1;
        }
        try {
            if (partValsSpecified == this.tbl.getPartitionKeys().size() && this.db.getPartition(this.tbl, partSpec, false, null, false) == null) {
                throw new SemanticException(ErrorMsg.COLUMNSTATSCOLLECTOR_INVALID_PARTITION.getMsg() + " : " + partSpec);
            }
        }
        catch (HiveException he) {
            throw new SemanticException(ErrorMsg.COLUMNSTATSCOLLECTOR_INVALID_PARTITION.getMsg() + " : " + partSpec);
        }
        List<String> partKeys = Utilities.getColumnNamesFromFieldSchema(this.tbl.getPartitionKeys());
        for (String partKey : partKeys) {
            if (partSpec.containsKey(partKey)) continue;
            partSpec.put(partKey, null);
        }
        for (String partKey : partSpec.keySet()) {
            if (partKeys.contains(partKey)) continue;
            throw new SemanticException(ErrorMsg.COLUMNSTATSCOLLECTOR_INVALID_PART_KEY.getMsg() + " : " + partKey);
        }
    }

    private StringBuilder genPartitionClause(Map<String, String> partSpec) throws SemanticException {
        StringBuilder whereClause = new StringBuilder(" where ");
        boolean predPresent = false;
        StringBuilder groupByClause = new StringBuilder(" group by ");
        boolean aggPresent = false;
        for (String partKey : partSpec.keySet()) {
            String value = partSpec.get(partKey);
            if (value == null) continue;
            if (!predPresent) {
                predPresent = true;
            } else {
                whereClause.append(" and ");
            }
            whereClause.append(partKey).append(" = ").append(this.genPartValueString(partKey, value));
        }
        for (FieldSchema fs : this.tbl.getPartitionKeys()) {
            if (!aggPresent) {
                aggPresent = true;
            } else {
                groupByClause.append(",");
            }
            groupByClause.append(fs.getName());
        }
        return predPresent ? whereClause.append((CharSequence)groupByClause) : groupByClause;
    }

    private String genPartValueString(String partKey, String partVal) throws SemanticException {
        String returnVal = partVal;
        String partColType = this.getColTypeOf(partKey);
        returnVal = partColType.equals("string") || partColType.contains("varchar") || partColType.contains("char") ? "'" + partVal + "'" : (partColType.equals("tinyint") ? partVal + "Y" : (partColType.equals("smallint") ? partVal + "S" : (partColType.equals("int") ? partVal : (partColType.equals("bigint") ? partVal + "L" : (partColType.contains("decimal") ? partVal + "BD" : (partColType.equals("date") || partColType.equals("timestamp") ? partColType + " '" + partVal + "'" : "'" + partVal + "'"))))));
        return returnVal;
    }

    private String getColTypeOf(String partKey) throws SemanticException {
        for (FieldSchema fs : this.tbl.getPartitionKeys()) {
            if (!partKey.equalsIgnoreCase(fs.getName())) continue;
            return fs.getType().toLowerCase();
        }
        throw new SemanticException("Unknown partition key : " + partKey);
    }

    private int getNumBitVectorsForNDVEstimation(HiveConf conf) throws SemanticException {
        int numBitVectors;
        float percentageError = HiveConf.getFloatVar(conf, HiveConf.ConfVars.HIVE_STATS_NDV_ERROR);
        if ((double)percentageError < 0.0) {
            throw new SemanticException("hive.stats.ndv.error can't be negative");
        }
        if ((double)percentageError <= 2.4) {
            numBitVectors = 1024;
            LOG.info((Object)("Lowest error achievable is 2.4% but error requested is " + percentageError + "%"));
            LOG.info((Object)"Choosing 1024 bit vectors..");
        } else if ((double)percentageError <= 3.4) {
            numBitVectors = 1024;
            LOG.info((Object)("Error requested is " + percentageError + "%"));
            LOG.info((Object)"Choosing 1024 bit vectors..");
        } else if ((double)percentageError <= 4.8) {
            numBitVectors = 512;
            LOG.info((Object)("Error requested is " + percentageError + "%"));
            LOG.info((Object)"Choosing 512 bit vectors..");
        } else if ((double)percentageError <= 6.8) {
            numBitVectors = 256;
            LOG.info((Object)("Error requested is " + percentageError + "%"));
            LOG.info((Object)"Choosing 256 bit vectors..");
        } else if ((double)percentageError <= 9.7) {
            numBitVectors = 128;
            LOG.info((Object)("Error requested is " + percentageError + "%"));
            LOG.info((Object)"Choosing 128 bit vectors..");
        } else if ((double)percentageError <= 13.8) {
            numBitVectors = 64;
            LOG.info((Object)("Error requested is " + percentageError + "%"));
            LOG.info((Object)"Choosing 64 bit vectors..");
        } else if ((double)percentageError <= 19.6) {
            numBitVectors = 32;
            LOG.info((Object)("Error requested is " + percentageError + "%"));
            LOG.info((Object)"Choosing 32 bit vectors..");
        } else if ((double)percentageError <= 28.2) {
            numBitVectors = 16;
            LOG.info((Object)("Error requested is " + percentageError + "%"));
            LOG.info((Object)"Choosing 16 bit vectors..");
        } else if ((double)percentageError <= 40.9) {
            numBitVectors = 8;
            LOG.info((Object)("Error requested is " + percentageError + "%"));
            LOG.info((Object)"Choosing 8 bit vectors..");
        } else if ((double)percentageError <= 61.0) {
            numBitVectors = 4;
            LOG.info((Object)("Error requested is " + percentageError + "%"));
            LOG.info((Object)"Choosing 4 bit vectors..");
        } else {
            numBitVectors = 2;
            LOG.info((Object)("Error requested is " + percentageError + "%"));
            LOG.info((Object)"Choosing 2 bit vectors..");
        }
        return numBitVectors;
    }

    private List<String> getColumnTypes(List<String> colNames) throws SemanticException {
        LinkedList<String> colTypes = new LinkedList<String>();
        List<FieldSchema> cols = this.tbl.getCols();
        for (String colName : colNames) {
            for (FieldSchema col : cols) {
                if (!colName.equalsIgnoreCase(col.getName())) continue;
                colTypes.add(new String(col.getType()));
            }
        }
        return colTypes;
    }

    private String genRewrittenQuery(List<String> colNames, int numBitVectors, Map<String, String> partSpec, boolean isPartitionStats) throws SemanticException {
        StringBuilder rewrittenQueryBuilder = new StringBuilder("select ");
        for (int i = 0; i < colNames.size(); ++i) {
            if (i > 0) {
                rewrittenQueryBuilder.append(" , ");
            }
            rewrittenQueryBuilder.append("compute_stats(");
            rewrittenQueryBuilder.append(colNames.get(i));
            rewrittenQueryBuilder.append(" , ");
            rewrittenQueryBuilder.append(numBitVectors);
            rewrittenQueryBuilder.append(" )");
        }
        if (isPartitionStats) {
            for (FieldSchema fs : this.tbl.getPartCols()) {
                rewrittenQueryBuilder.append(" , " + fs.getName());
            }
        }
        rewrittenQueryBuilder.append(" from ");
        rewrittenQueryBuilder.append(this.tbl.getDbName());
        rewrittenQueryBuilder.append(".");
        rewrittenQueryBuilder.append(this.tbl.getTableName());
        this.isRewritten = true;
        if (isPartitionStats) {
            rewrittenQueryBuilder.append((CharSequence)this.genPartitionClause(partSpec));
        }
        String rewrittenQuery = rewrittenQueryBuilder.toString();
        rewrittenQuery = new VariableSubstitution(new HiveVariableSource(){

            @Override
            public Map<String, String> getHiveVariable() {
                return SessionState.get().getHiveVariables();
            }
        }).substitute(this.conf, rewrittenQuery);
        return rewrittenQuery;
    }

    private ASTNode genRewrittenTree(String rewrittenQuery) throws SemanticException {
        ASTNode rewrittenTree;
        try {
            this.ctx = new Context(this.conf);
        }
        catch (IOException e) {
            throw new SemanticException(ErrorMsg.COLUMNSTATSCOLLECTOR_IO_ERROR.getMsg());
        }
        this.ctx.setCmd(rewrittenQuery);
        ParseDriver pd = new ParseDriver();
        try {
            rewrittenTree = pd.parse(rewrittenQuery, this.ctx);
        }
        catch (ParseException e) {
            throw new SemanticException(ErrorMsg.COLUMNSTATSCOLLECTOR_PARSE_ERROR.getMsg());
        }
        rewrittenTree = ParseUtils.findRootNonNullToken(rewrittenTree);
        return rewrittenTree;
    }

    private void validateSpecifiedColumnNames(List<String> specifiedCols) throws SemanticException {
        List<String> tableCols = Utilities.getColumnNamesFromFieldSchema(this.tbl.getCols());
        for (String sc : specifiedCols) {
            if (tableCols.contains(sc.toLowerCase())) continue;
            String msg = "'" + sc + "' (possible columns are " + tableCols.toString() + ")";
            throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(msg));
        }
    }

    private void checkForPartitionColumns(List<String> specifiedCols, List<String> partCols) throws SemanticException {
        for (String pc : partCols) {
            for (String sc : specifiedCols) {
                if (!pc.equalsIgnoreCase(sc)) continue;
                throw new SemanticException(ErrorMsg.COLUMNSTATSCOLLECTOR_INVALID_COLUMN.getMsg() + " [Try removing column '" + sc + "' from column list]");
            }
        }
    }

    @Override
    public void analyze(ASTNode ast, Context origCtx) throws SemanticException {
        this.init(true);
        super.processNoScanCommand(ast);
        super.processPartialScanCommand(ast);
        if (this.shouldRewrite(ast)) {
            this.tbl = this.getTable(ast);
            this.colNames = this.getColumnName(ast);
            this.originalTree = ast;
            boolean isPartitionStats = this.isPartitionLevelStats(ast);
            Map<String, String> partSpec = null;
            this.checkForPartitionColumns(this.colNames, Utilities.getColumnNamesFromFieldSchema(this.tbl.getPartitionKeys()));
            this.validateSpecifiedColumnNames(this.colNames);
            if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_COLLECT_PART_LEVEL_STATS) && this.tbl.isPartitioned()) {
                isPartitionStats = true;
            }
            if (isPartitionStats) {
                this.isTableLevel = false;
                partSpec = this.getPartKeyValuePairsFromAST(ast);
                this.handlePartialPartitionSpec(partSpec);
            } else {
                this.isTableLevel = true;
            }
            this.colType = this.getColumnTypes(this.colNames);
            int numBitVectors = this.getNumBitVectorsForNDVEstimation(this.conf);
            this.rewrittenQuery = this.genRewrittenQuery(this.colNames, numBitVectors, partSpec, isPartitionStats);
            this.rewrittenTree = this.genRewrittenTree(this.rewrittenQuery);
        } else {
            this.originalTree = this.rewrittenTree = ast;
            this.rewrittenQuery = null;
            this.isRewritten = false;
        }
        if (this.isRewritten) {
            QB qb = this.getQB();
            qb.setAnalyzeRewrite(true);
            QBParseInfo qbp = qb.getParseInfo();
            qbp.setTableName(this.tbl.getDbName() + "." + this.tbl.getTableName());
            qbp.setTblLvl(this.isTableLevel);
            qbp.setColName(this.colNames);
            qbp.setColType(this.colType);
            this.initCtx(this.ctx);
            LOG.info((Object)"Invoking analyze on rewritten query");
            this.analyzeInternal(this.rewrittenTree);
        } else {
            this.initCtx(origCtx);
            LOG.info((Object)"Invoking analyze on original query");
            this.analyzeInternal(this.originalTree);
        }
    }
}

