/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark.client;

import com.google.common.collect.Lists;
import io.netty.util.concurrent.Promise;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hive.spark.client.JobHandle;
import org.apache.hive.spark.client.MetricsCollection;
import org.apache.hive.spark.client.SparkClientImpl;
import org.apache.hive.spark.counter.SparkCounters;

class JobHandleImpl<T extends Serializable>
implements JobHandle<T> {
    private final SparkClientImpl client;
    private final String jobId;
    private final MetricsCollection metrics;
    private final Promise<T> promise;
    private final List<Integer> sparkJobIds;
    private final List<JobHandle.Listener> listeners;
    private volatile JobHandle.State state;
    private volatile SparkCounters sparkCounters;

    JobHandleImpl(SparkClientImpl client, Promise<T> promise, String jobId) {
        this.client = client;
        this.jobId = jobId;
        this.promise = promise;
        this.listeners = Lists.newLinkedList();
        this.metrics = new MetricsCollection();
        this.sparkJobIds = new CopyOnWriteArrayList<Integer>();
        this.state = JobHandle.State.SENT;
        this.sparkCounters = null;
    }

    @Override
    public boolean cancel(boolean mayInterrupt) {
        if (this.changeState(JobHandle.State.CANCELLED)) {
            this.client.cancel(this.jobId);
            this.promise.cancel(mayInterrupt);
            return true;
        }
        return false;
    }

    @Override
    public T get() throws ExecutionException, InterruptedException {
        return (T)((Serializable)this.promise.get());
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        return (T)((Serializable)this.promise.get(timeout, unit));
    }

    @Override
    public boolean isCancelled() {
        return this.promise.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.promise.isDone();
    }

    @Override
    public String getClientJobId() {
        return this.jobId;
    }

    @Override
    public MetricsCollection getMetrics() {
        return this.metrics;
    }

    @Override
    public List<Integer> getSparkJobIds() {
        return this.sparkJobIds;
    }

    @Override
    public SparkCounters getSparkCounters() {
        return this.sparkCounters;
    }

    @Override
    public JobHandle.State getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(JobHandle.Listener l) {
        List<JobHandle.Listener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
            if (this.state.ordinal() >= JobHandle.State.CANCELLED.ordinal()) {
                for (Integer i : this.sparkJobIds) {
                    l.onSparkJobStarted(this, i);
                }
            }
            this.fireStateChange(this.state, l);
            if (this.state.ordinal() < JobHandle.State.CANCELLED.ordinal()) {
                for (Integer i : this.sparkJobIds) {
                    l.onSparkJobStarted(this, i);
                }
            }
        }
    }

    public void setSparkCounters(SparkCounters sparkCounters) {
        this.sparkCounters = sparkCounters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSuccess(Object result) {
        List<JobHandle.Listener> list = this.listeners;
        synchronized (list) {
            this.promise.setSuccess((Object)((Serializable)result));
            this.changeState(JobHandle.State.SUCCEEDED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFailure(Throwable error) {
        List<JobHandle.Listener> list = this.listeners;
        synchronized (list) {
            this.promise.setFailure(error);
            this.changeState(JobHandle.State.FAILED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean changeState(JobHandle.State newState) {
        List<JobHandle.Listener> list = this.listeners;
        synchronized (list) {
            if (newState.ordinal() > this.state.ordinal() && this.state.ordinal() < JobHandle.State.CANCELLED.ordinal()) {
                this.state = newState;
                for (JobHandle.Listener l : this.listeners) {
                    this.fireStateChange(newState, l);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSparkJobId(int sparkJobId) {
        List<JobHandle.Listener> list = this.listeners;
        synchronized (list) {
            this.sparkJobIds.add(sparkJobId);
            for (JobHandle.Listener l : this.listeners) {
                l.onSparkJobStarted(this, sparkJobId);
            }
        }
    }

    private void fireStateChange(JobHandle.State s, JobHandle.Listener l) {
        switch (s) {
            case SENT: {
                break;
            }
            case QUEUED: {
                l.onJobQueued(this);
                break;
            }
            case STARTED: {
                l.onJobStarted(this);
                break;
            }
            case CANCELLED: {
                l.onJobCancelled(this);
                break;
            }
            case FAILED: {
                l.onJobFailed(this, this.promise.cause());
                break;
            }
            case SUCCEEDED: {
                try {
                    l.onJobSucceeded(this, (Serializable)this.promise.get());
                    break;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    protected void finalize() {
        if (!this.isDone()) {
            this.cancel(true);
        }
    }
}

