/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.net.ProxySelector;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.text.StyleContext;
import org.pentaho.reporting.designer.core.ReportDesignerBoot;
import org.pentaho.reporting.designer.core.ReportDesignerFrame;
import org.pentaho.reporting.designer.core.editor.expressions.ExpressionUtil;
import org.pentaho.reporting.designer.core.editor.expressions.ExpressionsTreeModel;
import org.pentaho.reporting.designer.core.settings.SettingsUtil;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.settings.prefs.BinaryPreferencesFactory;
import org.pentaho.reporting.designer.core.splash.SplashScreen;
import org.pentaho.reporting.designer.core.status.ExceptionDialog;
import org.pentaho.reporting.designer.core.util.exceptions.ThrowableHandler;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.firewall.FirewallingProxySelector;
import org.pentaho.reporting.designer.core.util.firewall.FirewallingSecurityManager;
import org.pentaho.reporting.designer.core.versionchecker.VersionCheckerUtility;
import org.pentaho.reporting.designer.core.welcome.SamplesTreeBuilder;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementTypeRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionRegistry;
import org.pentaho.reporting.engine.classic.core.util.ImageUtils;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.designtime.swing.propertyeditors.ColorPropertyEditor;
import org.pentaho.reporting.libraries.fonts.LibFontBoot;
import org.pentaho.reporting.libraries.resourceloader.LibLoaderBoot;

public class ReportDesigner {
    private static SplashScreen splashScreen;
    private static ReportDesignerFrame reportDesignerFrame;

    private ReportDesigner() {
    }

    public static void main(String[] args) {
        int parsePos;
        boolean offlineMode = false;
        boolean offlineModeSecurityManager = false;
        for (parsePos = 0; parsePos < args.length; ++parsePos) {
            String arg = args[parsePos];
            if ("--offline".equals(arg) || "-o".equals(arg)) {
                offlineMode = true;
                continue;
            }
            if (!"--with-offline-mode-security-manager".equals(arg)) break;
            offlineModeSecurityManager = true;
        }
        File[] files = new File[args.length - parsePos];
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            files[i] = new File(arg);
        }
        System.setProperty("sun.awt.exception.handler", ThrowableHandler.class.getName());
        Thread.setDefaultUncaughtExceptionHandler(ThrowableHandler.getInstance());
        System.setProperty("java.util.prefs.PreferencesFactory", BinaryPreferencesFactory.class.getName());
        System.setProperty("sun.swing.enableImprovedDragGesture", "true");
        ProxySelector.setDefault(new FirewallingProxySelector(ProxySelector.getDefault()));
        if (offlineModeSecurityManager) {
            try {
                System.setSecurityManager(new FirewallingSecurityManager());
            }
            catch (SecurityException se) {
                DebugLog.log((Object)"Unable to set security manager. An other security manager prevented us from gaining control.");
            }
        }
        if (offlineMode) {
            WorkspaceSettings.getInstance().setOfflineMode(true);
        }
        PropertyEditorManager.registerEditor(Color.class, ColorPropertyEditor.class);
        try {
            SwingUtilities.invokeAndWait(new SetLookAndFeelTask());
            SwingUtilities.invokeAndWait(new InstallAWTHandlerRunnable());
            SwingUtilities.invokeAndWait(new InitializeSplashScreenTask());
            SwingUtilities.invokeAndWait(new UpdateStatusTask("Booting Base Libraries .."));
            LibLoaderBoot.getInstance().start();
            if (LibLoaderBoot.getInstance().isBootFailed()) {
                throw new IllegalStateException("Booting failed", LibLoaderBoot.getInstance().getBootFailureReason());
            }
            SwingUtilities.invokeAndWait(new UpdateStatusTask("Booting Font Rendering System .."));
            LibFontBoot.getInstance().start();
            if (LibFontBoot.getInstance().isBootFailed()) {
                throw new IllegalStateException("Booting failed", LibFontBoot.getInstance().getBootFailureReason());
            }
            SwingUtilities.invokeAndWait(new UpdateStatusTask("Booting Reporting-Engine .."));
            ClassicEngineBoot.getInstance().start();
            if (ClassicEngineBoot.getInstance().isBootFailed()) {
                throw new IllegalStateException("Booting failed", ClassicEngineBoot.getInstance().getBootFailureReason());
            }
            SwingUtilities.invokeAndWait(new UpdateStatusTask("Booting Report-Designer .."));
            ReportDesignerBoot.getInstance().start();
            if (ReportDesignerBoot.getInstance().isBootFailed()) {
                throw new IllegalStateException("Booting failed", ReportDesignerBoot.getInstance().getBootFailureReason());
            }
            SwingUtilities.invokeAndWait(new UpdateStatusTask("Preloading classes .."));
            ExpressionRegistry.getInstance();
            ExpressionsTreeModel.getTreeModel();
            ExpressionUtil.getInstance();
            ReportDesigner.preloadFonts();
            SwingUtilities.invokeAndWait(new UpdateStatusTask("Checking initial configuration .."));
            SettingsUtil.createInitialConfiguration();
            SwingUtilities.invokeAndWait(new UpdateStatusTask("Collecting Sample Reports .."));
            SamplesTreeBuilder.getSampleTreeModel();
            SwingUtilities.invokeAndWait(new UpdateStatusTask("Starting  .."));
            SwingUtilities.invokeAndWait(new CreateReportDesignerFrame(files));
            SwingUtilities.invokeAndWait(new VersionCheckerTask());
            ElementMetaData data = ElementTypeRegistry.getInstance().getElementType("page-header");
            AttributeMetaData[] datas = data.getAttributeDescriptions();
            int n = datas.length;
        }
        catch (Throwable t) {
            if (splashScreen != null) {
                splashScreen.dispose();
            }
            UncaughtExceptionsModel.getInstance().addException(t);
            ExceptionDialog dialog = new ExceptionDialog();
            dialog.setModal(true);
            dialog.showDialog();
            System.exit(1);
        }
    }

    public static void preloadFonts() {
        BufferedImage image = ImageUtils.createTransparentImage((int)10, (int)10);
        Graphics2D d = image.createGraphics();
        d.setPaint(Color.BLACK);
        String[] availableFontFamilyNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < availableFontFamilyNames.length; ++i) {
            String value = availableFontFamilyNames[i];
            d.setFont(StyleContext.getDefaultStyleContext().getFont(value, 0, 12));
            d.drawString(value, 0, 10);
        }
        d.dispose();
    }

    private static class InstallAWTHandlerRunnable
    implements Runnable {
        private InstallAWTHandlerRunnable() {
        }

        @Override
        public void run() {
            Thread.currentThread().setUncaughtExceptionHandler(ThrowableHandler.getInstance());
        }
    }

    private static class VersionCheckerTask
    implements Runnable {
        private VersionCheckerTask() {
        }

        @Override
        public void run() {
            splashScreen.dispose();
            try {
                Class.forName("org.pentaho.versionchecker.VersionChecker");
                VersionCheckerUtility.handlerVersionCheck(reportDesignerFrame);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class CreateReportDesignerFrame
    implements Runnable {
        private File[] files;

        private CreateReportDesignerFrame(File[] files) {
            this.files = files;
        }

        @Override
        public void run() {
            try {
                ReportDesignerFrame frame = new ReportDesignerFrame();
                reportDesignerFrame = frame;
                frame.pack();
                Rectangle bounds = WorkspaceSettings.getInstance().getBounds();
                if (bounds == null || !LibSwingUtil.safeRestoreWindow((Window)frame, (Rectangle)bounds)) {
                    LibSwingUtil.centerFrameOnScreen((Window)frame);
                    frame.setExtendedState(6);
                }
                frame.initWindowLocations(this.files);
                frame.setVisible(true);
            }
            catch (Exception t) {
                if (splashScreen != null) {
                    splashScreen.dispose();
                }
                UncaughtExceptionsModel.getInstance().addException(t);
                ExceptionDialog dialog = new ExceptionDialog();
                dialog.setModal(true);
                dialog.showDialog();
                System.exit(-1);
            }
        }
    }

    private static class UpdateStatusTask
    implements Runnable {
        private String status;

        private UpdateStatusTask(String status) {
            this.status = status;
        }

        @Override
        public void run() {
            splashScreen.setStatus(this.status);
        }
    }

    private static class InitializeSplashScreenTask
    implements Runnable {
        private InitializeSplashScreenTask() {
        }

        @Override
        public void run() {
            SplashScreen splashScreen = new SplashScreen();
            splashScreen = splashScreen;
            if (WorkspaceSettings.getInstance().isSplashScreenVisible()) {
                splashScreen.setVisible(true);
            }
        }
    }

    private static class SetLookAndFeelTask
    implements Runnable {
        private SetLookAndFeelTask() {
        }

        @Override
        public void run() {
            int indent = 0;
            try {
                String lnfName = WorkspaceSettings.getInstance().getLNF();
                if (!StringUtils.isEmpty((String)lnfName)) {
                    UIManager.LookAndFeelInfo[] lnfs;
                    for (UIManager.LookAndFeelInfo lnf : lnfs = UIManager.getInstalledLookAndFeels()) {
                        if (!lnf.getName().equals(lnfName)) continue;
                        UIManager.setLookAndFeel(lnf.getClassName());
                        return;
                    }
                }
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                indent = 5;
            }
            catch (Throwable t) {
                UncaughtExceptionsModel.getInstance().addException(t);
            }
            UIDefaults uiDefaults = UIManager.getDefaults();
            uiDefaults.put("Table.gridColor", uiDefaults.get("Panel.background"));
            uiDefaults.put("Tree.leftChildIndent", (Object)indent);
        }
    }
}

