/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.format.ConditionalVisibilityDialog;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class AddConditionalVisibilityAction
extends AbstractElementSelectionAction {
    public AddConditionalVisibilityAction() {
        this.putValue("Name", ActionMessages.getString("AddConditionalVisibilityAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("AddConditionalVisibilityAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("AddConditionalVisibilityAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("AddConditionalVisibilityAction.Accelerator"));
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    protected void updateSelection() {
        if (!this.isSingleElementSelection()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(this.getSelectionModel().getSelectedElement(0) instanceof Element);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DocumentContextSelectionModel selectionModel1 = this.getSelectionModel();
        if (selectionModel1 == null) {
            return;
        }
        List<Element> visualElements = selectionModel1.getSelectedElementsOfType(Element.class);
        if (visualElements.size() != 1) {
            return;
        }
        Component parent = this.getReportDesignerContext().getView().getParent();
        Window window = LibSwingUtil.getWindowAncestor((Component)parent);
        ConditionalVisibilityDialog dialog = window instanceof JDialog ? new ConditionalVisibilityDialog((JDialog)window) : (window instanceof JFrame ? new ConditionalVisibilityDialog((JFrame)window) : new ConditionalVisibilityDialog());
        Expression oldExpression = visualElements.get(0).getStyleExpression(ElementStyleKeys.VISIBLE);
        dialog.setReportDesignerContext(this.getReportDesignerContext());
        Expression expression = dialog.performEdit(oldExpression);
        if (expression != null) {
            visualElements.get(0).setStyleExpression(ElementStyleKeys.VISIBLE, expression.getInstance());
        }
    }
}

