/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyEditor;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.util.table.ResourcePropertyEditor;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.designtime.ReportModelEventFilter;
import org.pentaho.reporting.engine.classic.core.designtime.ReportModelEventFilterFactory;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.libraries.designtime.swing.propertyeditors.CustomPropertyEditorDialog;

public class EditContentRefAction
extends AbstractElementSelectionAction {
    private ReportModelEventFilter eventFilter;

    public EditContentRefAction() {
        this.putValue("Name", ActionMessages.getString("EditContentRefAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("EditContentRefAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("EditContentRefAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("EditContentRefAction.Accelerator"));
        this.eventFilter = new ReportModelEventFilterFactory().createAttributeFilter("http://reporting.pentaho.org/namespaces/engine/attributes/core", "element-type");
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
        if (this.eventFilter.isFilteredEvent(event)) {
            this.updateSelection();
        }
    }

    @Override
    protected void updateSelection() {
        if (!this.isSingleElementSelection()) {
            this.setEnabled(false);
            return;
        }
        Object o = this.getSelectionModel().getLeadSelection();
        if (!(o instanceof Element)) {
            this.setEnabled(false);
            return;
        }
        Element e = (Element)o;
        AttributeMetaData data = e.getElementType().getMetaData().getAttributeDescription("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value");
        if (data == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled("Resource".equals(data.getValueRole()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isSingleElementSelection()) {
            return;
        }
        Object o = this.getSelectionModel().getLeadSelection();
        if (!(o instanceof Element)) {
            return;
        }
        Element element = (Element)o;
        AttributeMetaData data = element.getElementType().getMetaData().getAttributeDescription("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value");
        if (data == null) {
            return;
        }
        if (!"Resource".equals(data.getValueRole())) {
            return;
        }
        Component window = this.getReportDesignerContext().getView().getParent();
        CustomPropertyEditorDialog editorDialog = window instanceof Frame ? new CustomPropertyEditorDialog((Frame)window) : (window instanceof Dialog ? new CustomPropertyEditorDialog((Dialog)window) : new CustomPropertyEditorDialog());
        editorDialog.setTitle(ActionMessages.getString("EditContentRefAction.Text", new Object[0]));
        ResourcePropertyEditor propertyEditor = new ResourcePropertyEditor(this.getActiveContext());
        propertyEditor.setValue(element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value"));
        if (editorDialog.performEdit((PropertyEditor)((Object)propertyEditor))) {
            element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", propertyEditor.getValue());
        }
    }
}

