/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements;

import java.awt.event.ActionEvent;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.actions.elements.EditGroupAction;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.undo.EditGroupUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.GroupDataBody;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.SubGroupBody;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public final class InsertGroupAction
extends AbstractElementSelectionAction {
    public InsertGroupAction() {
        this.putValue("Name", ActionMessages.getString("InsertGroupAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("InsertGroupAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("InsertGroupAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("InsertGroupAction.Accelerator"));
        this.putValue("SmallIcon", IconLoader.getInstance().getGenericSquare());
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        RelationalGroup newGroup = new RelationalGroup();
        EditGroupUndoEntry groupUndoEntry = EditGroupAction.performEditGroup(this.getReportDesignerContext(), newGroup, true);
        if (groupUndoEntry == null) {
            return;
        }
        newGroup.setName(groupUndoEntry.getNewName());
        newGroup.setFieldsArray(groupUndoEntry.getNewFields());
        try {
            Object selectedElement = activeContext.getReportDefinition();
            if (this.getSelectionModel().getSelectionCount() > 0) {
                selectedElement = this.getSelectionModel().getSelectedElement(0);
            }
            if (selectedElement == activeContext.getReportDefinition()) {
                Object report = selectedElement;
                Group rootGroup = report.getRootGroup();
                SubGroupBody body = new SubGroupBody();
                newGroup.setBody((GroupBody)body);
                report.setRootGroup((Group)newGroup);
                body.setGroup(rootGroup);
                activeContext.getUndo().addChange(ActionMessages.getString("InsertGroupAction.UndoName", new Object[0]), new InsertGroupOnReportUndoEntry(rootGroup, (Group)newGroup));
                return;
            }
            if (!(selectedElement instanceof RelationalGroup)) {
                return;
            }
            RelationalGroup selectedGroup = (RelationalGroup)selectedElement;
            GroupBody bodyElement = selectedGroup.getBody();
            if (bodyElement instanceof SubGroupBody) {
                SubGroupBody subGroupBodyReportElement = (SubGroupBody)bodyElement;
                Group oldBodyContent = subGroupBodyReportElement.getGroup();
                SubGroupBody body = new SubGroupBody();
                newGroup.setBody((GroupBody)body);
                subGroupBodyReportElement.setGroup((Group)newGroup);
                body.setGroup(oldBodyContent);
                activeContext.getUndo().addChange(ActionMessages.getString("InsertGroupAction.UndoName", new Object[0]), new InsertGroupOnGroupUndoEntry(selectedGroup.getObjectID(), oldBodyContent, (Group)newGroup));
            } else if (bodyElement instanceof GroupDataBody) {
                GroupDataBody oldBody = (GroupDataBody)bodyElement;
                selectedGroup.setBody((GroupBody)new SubGroupBody((Group)newGroup));
                newGroup.setBody((GroupBody)oldBody);
                activeContext.getUndo().addChange(ActionMessages.getString("InsertGroupAction.UndoName", new Object[0]), new InsertGroupOnDetailsUndoEntry(selectedGroup.getObjectID(), newGroup));
            }
        }
        catch (Exception ex) {
            UncaughtExceptionsModel.getInstance().addException(ex);
        }
    }

    @Override
    protected void updateSelection() {
        DocumentContextSelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel == null) {
            this.setEnabled(false);
            return;
        }
        if (selectionModel.getSelectionCount() == 0) {
            this.setEnabled(true);
            return;
        }
        if (!this.isSingleElementSelection()) {
            this.setEnabled(false);
            return;
        }
        Object selectedElement = selectionModel.getSelectedElement(0);
        if (selectedElement == this.getActiveContext().getReportDefinition() || selectedElement instanceof RelationalGroup) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    private class InsertGroupOnDetailsUndoEntry
    implements UndoEntry {
        private InstanceID target;
        private RelationalGroup newGroup;

        public InsertGroupOnDetailsUndoEntry(InstanceID target, RelationalGroup newGroup) {
            this.target = target;
            this.newGroup = newGroup;
        }

        @Override
        public void undo(ReportDocumentContext renderContext) {
            RelationalGroup selectedGroup = (RelationalGroup)ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
            GroupBody bodyElement = selectedGroup.getBody();
            if (!(bodyElement instanceof SubGroupBody)) {
                throw new IllegalStateException();
            }
            SubGroupBody sgb = (SubGroupBody)bodyElement;
            GroupBody maybeDataBody = sgb.getGroup().getBody();
            if (!(maybeDataBody instanceof GroupDataBody)) {
                throw new IllegalStateException();
            }
            selectedGroup.setBody(maybeDataBody);
        }

        @Override
        public void redo(ReportDocumentContext renderContext) {
            RelationalGroup selectedGroup = (RelationalGroup)ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
            GroupBody bodyElement = selectedGroup.getBody();
            if (!(bodyElement instanceof GroupDataBody)) {
                throw new IllegalStateException();
            }
            GroupDataBody oldBody = (GroupDataBody)bodyElement;
            selectedGroup.setBody((GroupBody)new SubGroupBody((Group)this.newGroup));
            this.newGroup.setBody((GroupBody)oldBody);
        }

        @Override
        public UndoEntry merge(UndoEntry newEntry) {
            return null;
        }
    }

    private static class InsertGroupOnGroupUndoEntry
    implements UndoEntry {
        private InstanceID target;
        private Group newRootGroup;
        private Group oldRootGroup;

        private InsertGroupOnGroupUndoEntry(InstanceID target, Group oldRootGroup, Group newRootGroup) {
            this.target = target;
            this.oldRootGroup = oldRootGroup;
            this.newRootGroup = newRootGroup;
        }

        @Override
        public void undo(ReportDocumentContext renderContext) {
            RelationalGroup selectedGroup = (RelationalGroup)ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
            GroupBody bodyElement = selectedGroup.getBody();
            if (!(bodyElement instanceof SubGroupBody)) {
                throw new IllegalStateException();
            }
            SubGroupBody subGroupBodyReportElement = (SubGroupBody)bodyElement;
            subGroupBodyReportElement.setGroup(this.oldRootGroup);
        }

        @Override
        public void redo(ReportDocumentContext renderContext) {
            RelationalGroup selectedGroup = (RelationalGroup)ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
            GroupBody bodyElement = selectedGroup.getBody();
            if (!(bodyElement instanceof SubGroupBody)) {
                throw new IllegalStateException();
            }
            SubGroupBody subGroupBodyReportElement = (SubGroupBody)bodyElement;
            Group oldBodyContent = subGroupBodyReportElement.getGroup();
            SubGroupBody body = new SubGroupBody();
            this.newRootGroup.setBody((GroupBody)body);
            subGroupBodyReportElement.setGroup(this.newRootGroup);
            body.setGroup(oldBodyContent);
        }

        @Override
        public UndoEntry merge(UndoEntry newEntry) {
            return null;
        }
    }

    private static class InsertGroupOnReportUndoEntry
    implements UndoEntry {
        private Group newRootGroup;
        private Group oldRootGroup;

        private InsertGroupOnReportUndoEntry(Group oldRootGroup, Group newRootGroup) {
            this.oldRootGroup = oldRootGroup;
            this.newRootGroup = newRootGroup;
        }

        @Override
        public void undo(ReportDocumentContext renderContext) {
            AbstractReportDefinition report = renderContext.getReportDefinition();
            report.setRootGroup(this.oldRootGroup);
        }

        @Override
        public void redo(ReportDocumentContext renderContext) {
            AbstractReportDefinition report = renderContext.getReportDefinition();
            SubGroupBody body = new SubGroupBody();
            this.newRootGroup.setBody((GroupBody)body);
            report.setRootGroup(this.newRootGroup);
            body.setGroup(this.oldRootGroup);
        }

        @Override
        public UndoEntry merge(UndoEntry newEntry) {
            return null;
        }
    }
}

