/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.settings.SettingsListener;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.undo.CompoundUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.filter.MessageFormatSupport;
import org.pentaho.reporting.engine.classic.core.filter.types.DateFieldType;
import org.pentaho.reporting.engine.classic.core.filter.types.MessageType;
import org.pentaho.reporting.engine.classic.core.filter.types.NumberFieldType;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public final class MorphAction
extends AbstractElementSelectionAction
implements SettingsListener {
    private static final String CORE_NAMESPACE = "http://reporting.pentaho.org/namespaces/engine/attributes/core";
    private static final String ELEMENT_TYPE_ATTRIBUE = "element-type";
    private static final String FIELD_ATTRIBUTE = "field";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String FORMAT_ATTRIBUTE = "format-string";
    private final ElementMetaData metaData;
    private ElementType targetElementType;

    public MorphAction(ElementType elementType) {
        this.targetElementType = elementType;
        this.metaData = elementType.getMetaData();
        this.putValue("Name", this.metaData.getDisplayName(Locale.getDefault()));
        Image image = this.metaData.getIcon(Locale.getDefault(), 2);
        if (image != null) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }
        this.settingsChanged();
        WorkspaceSettings.getInstance().addSettingsListener(this);
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    public void settingsChanged() {
        this.setVisible(WorkspaceSettings.getInstance().isVisible((MetaData)this.metaData));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DocumentContextSelectionModel selectionModel1 = this.getSelectionModel();
        if (selectionModel1 == null) {
            return;
        }
        List<Element> visualElements = selectionModel1.getSelectedElementsOfType(Element.class);
        if (visualElements.isEmpty()) {
            return;
        }
        ArrayList<MorphUndoEntry> undos = new ArrayList<MorphUndoEntry>();
        ElementMetaData targetMetaData = this.targetElementType.getMetaData();
        for (Element visualElement : visualElements) {
            ReportAttributeMap oldAttributes;
            block19: {
                if (visualElement instanceof Section || ObjectUtilities.equal((Object)visualElement.getElementTypeName(), (Object)this.targetElementType.getMetaData().getName())) continue;
                oldAttributes = visualElement.getAttributes();
                ElementMetaData data = visualElement.getMetaData();
                AttributeMetaData[] datas = data.getAttributeDescriptions();
                for (int j = 0; j < datas.length; ++j) {
                    AttributeMetaData metaData = datas[j];
                    AttributeMetaData attributeMetaData = targetMetaData.getAttributeDescription(metaData.getNameSpace(), metaData.getName());
                    if (attributeMetaData != null) continue;
                    visualElement.setAttribute(metaData.getNameSpace(), metaData.getName(), null);
                    visualElement.setAttributeExpression(metaData.getNameSpace(), metaData.getName(), null);
                }
                visualElement.setElementType(this.targetElementType);
                ElementType srcType = (ElementType)oldAttributes.getAttribute(CORE_NAMESPACE, ELEMENT_TYPE_ATTRIBUE);
                if (srcType instanceof MessageType) {
                    String message = (String)oldAttributes.getAttribute(CORE_NAMESPACE, VALUE_ATTRIBUTE);
                    visualElement.setAttribute(CORE_NAMESPACE, VALUE_ATTRIBUTE, null);
                    try {
                        String[] fields;
                        Format df;
                        MessageFormatSupport fmt = new MessageFormatSupport();
                        fmt.setFormatString(message);
                        String rawFormat = fmt.getCompiledFormat();
                        MessageFormat msg = new MessageFormat(rawFormat);
                        Format[] subFormats = msg.getFormats();
                        if (this.targetElementType instanceof DateFieldType) {
                            int sdf = this.findFirstDateFormat(subFormats);
                            if (sdf != -1) {
                                df = (SimpleDateFormat)subFormats[sdf];
                                fields = fmt.getFields();
                                visualElement.setAttribute(CORE_NAMESPACE, FIELD_ATTRIBUTE, (Object)fields[sdf]);
                                visualElement.setAttribute(CORE_NAMESPACE, FORMAT_ATTRIBUTE, (Object)((SimpleDateFormat)df).toPattern());
                            }
                            break block19;
                        }
                        if (this.targetElementType instanceof NumberFieldType) {
                            int sdf = this.findFirstNumberFormat(subFormats);
                            if (sdf != -1) {
                                df = (DecimalFormat)subFormats[sdf];
                                fields = fmt.getFields();
                                visualElement.setAttribute(CORE_NAMESPACE, FIELD_ATTRIBUTE, (Object)fields[sdf]);
                                visualElement.setAttribute(CORE_NAMESPACE, FORMAT_ATTRIBUTE, (Object)((DecimalFormat)df).toPattern());
                            }
                            break block19;
                        }
                        String[] fields2 = fmt.getFields();
                        if (fields2.length > 0) {
                            visualElement.setAttribute(CORE_NAMESPACE, FIELD_ATTRIBUTE, (Object)fields2[0]);
                            break block19;
                        }
                        visualElement.setAttribute(CORE_NAMESPACE, VALUE_ATTRIBUTE, (Object)message);
                    }
                    catch (Exception ex) {
                        visualElement.setAttribute(CORE_NAMESPACE, VALUE_ATTRIBUTE, (Object)message);
                    }
                } else if (this.targetElementType instanceof MessageType) {
                    String srcField = (String)oldAttributes.getAttribute(CORE_NAMESPACE, FIELD_ATTRIBUTE);
                    String formatString = (String)oldAttributes.getAttribute(CORE_NAMESPACE, FORMAT_ATTRIBUTE);
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("$(").append(srcField);
                    if (srcType instanceof NumberFieldType) {
                        buffer.append(", number");
                        if (formatString != null && formatString.length() > 0) {
                            buffer.append(", ").append(formatString);
                        }
                    } else if (srcType instanceof DateFieldType) {
                        buffer.append(", date");
                        if (formatString != null && formatString.length() > 0) {
                            buffer.append(", ").append(formatString);
                        }
                    }
                    buffer.append(")");
                    visualElement.setAttribute(CORE_NAMESPACE, VALUE_ATTRIBUTE, (Object)buffer.toString());
                }
            }
            ReportAttributeMap newAttributes = visualElement.getAttributes();
            undos.add(new MorphUndoEntry(visualElement.getObjectID(), oldAttributes, newAttributes));
        }
        this.getActiveContext().getUndo().addChange(ActionMessages.getString("MorphAction.UndoName", new Object[0]), new CompoundUndoEntry(undos.toArray(new UndoEntry[undos.size()])));
    }

    private int findFirstDateFormat(Format[] formats) {
        for (int j = 0; j < formats.length; ++j) {
            Format format = formats[j];
            if (!(format instanceof SimpleDateFormat)) continue;
            return j;
        }
        return -1;
    }

    private int findFirstNumberFormat(Format[] formats) {
        for (int j = 0; j < formats.length; ++j) {
            Format format = formats[j];
            if (!(format instanceof DecimalFormat)) continue;
            return j;
        }
        return -1;
    }

    private static class MorphUndoEntry
    implements UndoEntry {
        private InstanceID target;
        private ReportAttributeMap oldAttributes;
        private ReportAttributeMap newAttributes;

        private MorphUndoEntry(InstanceID target, ReportAttributeMap oldAttributes, ReportAttributeMap newAttributes) {
            this.target = target;
            this.oldAttributes = oldAttributes;
            this.newAttributes = newAttributes;
        }

        @Override
        public void undo(ReportDocumentContext renderContext) {
            Element element = (Element)ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
            String[] attributeNamespaces = element.getAttributeNamespaces();
            for (int i = 0; i < attributeNamespaces.length; ++i) {
                String attributeNamespace = attributeNamespaces[i];
                String[] attributeNames = element.getAttributeNames(attributeNamespace);
                for (int j = 0; j < attributeNames.length; ++j) {
                    String attributeName = attributeNames[j];
                    element.setAttribute(attributeNamespace, attributeName, null, false);
                }
            }
            String[] namespaces = this.oldAttributes.getNameSpaces();
            for (int i = 0; i < namespaces.length; ++i) {
                String attributeNamespace = namespaces[i];
                String[] attributeNames = this.oldAttributes.getNames(attributeNamespace);
                for (int j = 0; j < attributeNames.length; ++j) {
                    String attributeName = attributeNames[j];
                    element.setAttribute(attributeNamespace, attributeName, this.oldAttributes.getAttribute(attributeNamespace, attributeName), false);
                }
            }
            element.notifyNodePropertiesChanged();
        }

        @Override
        public void redo(ReportDocumentContext renderContext) {
            Element element = (Element)ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
            String[] attributeNamespaces = element.getAttributeNamespaces();
            for (int i = 0; i < attributeNamespaces.length; ++i) {
                String attributeNamespace = attributeNamespaces[i];
                String[] attributeNames = element.getAttributeNames(attributeNamespace);
                for (int j = 0; j < attributeNames.length; ++j) {
                    String attributeName = attributeNames[j];
                    element.setAttribute(attributeNamespace, attributeName, null, false);
                }
            }
            String[] namespaces = this.newAttributes.getNameSpaces();
            for (int i = 0; i < namespaces.length; ++i) {
                String attributeNamespace = namespaces[i];
                String[] attributeNames = this.newAttributes.getNames(attributeNamespace);
                for (int j = 0; j < attributeNames.length; ++j) {
                    String attributeName = attributeNames[j];
                    element.setAttribute(attributeNamespace, attributeName, this.newAttributes.getAttribute(attributeNamespace, attributeName), false);
                }
            }
            element.notifyNodePropertiesChanged();
        }

        @Override
        public UndoEntry merge(UndoEntry newEntry) {
            return null;
        }
    }
}

