/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractDesignerContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.actions.ToggleStateAction;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.CrosstabCell;
import org.pentaho.reporting.engine.classic.core.CrosstabCellBody;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabElement;
import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabHeader;
import org.pentaho.reporting.engine.classic.core.CrosstabOtherGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabOtherGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabSummaryHeader;
import org.pentaho.reporting.engine.classic.core.CrosstabTitleHeader;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.GroupHeader;

public class SelectCrosstabBandAction
extends AbstractDesignerContextAction
implements ToggleStateAction {
    private DocumentContextSelectionModel selectionModel;
    private ArrayList<Element> otherGroupBodyList;
    private ArrayList<Element> rowGroupBodyList;
    private ArrayList<Element> columnGroupBodyList;
    private ArrayList<Element> cellBodyList;
    private ArrayList<Element> noneList;
    private ArrayList<Element> allElementsList;
    private CrosstabSelectionBandState selectionBandState;

    public SelectCrosstabBandAction() {
        this.putValue("SwingSelectedKey", Boolean.TRUE);
        this.putValue("Name", ActionMessages.getString("SelectCrosstabBandAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("SelectCrosstabBandAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("SelectCrosstabBandAction.Mnemonic"));
        this.putValue("SmallIcon", IconLoader.getInstance().getSelectCrosstabBandCommand());
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("SelectCrosstabBandAction.Accelerator"));
        this.selectionBandState = CrosstabSelectionBandState.NONE;
        this.otherGroupBodyList = new ArrayList();
        this.rowGroupBodyList = new ArrayList();
        this.columnGroupBodyList = new ArrayList();
        this.cellBodyList = new ArrayList();
        this.noneList = new ArrayList();
        this.allElementsList = new ArrayList();
        this.setEnabled(true);
    }

    private ArrayList<Element> getNextSelectionList() {
        this.selectionBandState = this.selectionBandState.getNextState();
        switch (this.selectionBandState) {
            case NONE: {
                return this.noneList;
            }
            case OTHER: {
                return this.otherGroupBodyList;
            }
            case ROW: {
                return this.rowGroupBodyList;
            }
            case COLUMN: {
                return this.columnGroupBodyList;
            }
            case CELL: {
                return this.cellBodyList;
            }
            case ALL: {
                return this.allElementsList;
            }
        }
        return this.noneList;
    }

    @Override
    public boolean isSelected() {
        return Boolean.TRUE.equals(this.getValue("SwingSelectedKey"));
    }

    public void setSelected(boolean selected) {
        this.putValue("SwingSelectedKey", selected);
    }

    public void initialize() {
        this.allElementsList.clear();
        this.otherGroupBodyList.clear();
        this.rowGroupBodyList.clear();
        this.columnGroupBodyList.clear();
        this.cellBodyList.clear();
    }

    private DocumentContextSelectionModel getSelectionModel() {
        if (this.selectionModel == null) {
            ReportDesignerContext reportDesignerContext = this.getReportDesignerContext();
            ReportDocumentContext activeContext = reportDesignerContext.getActiveContext();
            this.selectionModel = activeContext.getSelectionModel();
        }
        return this.selectionModel;
    }

    public ArrayList<Element> getOtherGroupBodyList() {
        return this.otherGroupBodyList;
    }

    public void buildCrosstabLists() {
        CrosstabElement crosstabElement;
        Group group;
        ReportDesignerContext reportDesignerContext = this.getReportDesignerContext();
        if (reportDesignerContext == null) {
            return;
        }
        this.initialize();
        ReportDocumentContext activeContext = reportDesignerContext.getActiveContext();
        this.selectionModel = this.getSelectionModel();
        AbstractReportDefinition reportDefinition = activeContext.getReportDefinition();
        if (reportDefinition instanceof CrosstabElement && (group = (crosstabElement = (CrosstabElement)reportDefinition).getRootGroup()) instanceof CrosstabGroup) {
            CrosstabGroup crosstabGroup = (CrosstabGroup)group;
            GroupBody crosstabGroupBody = crosstabGroup.getBody();
            if (crosstabGroupBody instanceof CrosstabOtherGroupBody) {
                CrosstabOtherGroup crosstabOtherGroup = ((CrosstabOtherGroupBody)crosstabGroupBody).getGroup();
                this.buildCrosstabOtherRowGroupBands(crosstabOtherGroup);
            } else if (crosstabGroupBody instanceof CrosstabRowGroupBody) {
                CrosstabRowGroupBody crosstabRowGroupBody = (CrosstabRowGroupBody)crosstabGroup.getBody();
                this.buildCrosstabRowGroupBands(crosstabRowGroupBody);
            }
            this.allElementsList.addAll(this.otherGroupBodyList);
            this.allElementsList.addAll(this.rowGroupBodyList);
            this.allElementsList.addAll(this.columnGroupBodyList);
            this.allElementsList.addAll(this.cellBodyList);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.allElementsList.isEmpty()) {
            this.buildCrosstabLists();
        }
        this.selectCrosstabElements(this.getNextSelectionList());
    }

    private void buildCrosstabCellBands(CrosstabCellBody crosstabCellBody) {
        if (crosstabCellBody == null) {
            return;
        }
        this.buildCrosstabElementsList((Band)crosstabCellBody.getHeader(), this.cellBodyList);
        int count = crosstabCellBody.getElementCount();
        for (int i = 0; i < count; ++i) {
            Element element = crosstabCellBody.getElement(i);
            if (!(element instanceof CrosstabCell)) continue;
            CrosstabCell cell = (CrosstabCell)element;
            int cellCount = cell.getElementCount();
            for (int c = 0; c < cellCount; ++c) {
                Element cellElement = cell.getElement(c);
                this.cellBodyList.add(cellElement);
            }
        }
    }

    private void buildCrosstabColumnGroupBands(CrosstabColumnGroupBody crosstabColumnGroupBody) {
        if (crosstabColumnGroupBody == null) {
            return;
        }
        CrosstabColumnGroup crosstabColumnGroup = crosstabColumnGroupBody.getGroup();
        CrosstabTitleHeader crosstabTitleHeader = crosstabColumnGroup.getTitleHeader();
        CrosstabHeader crosstabHeader = crosstabColumnGroup.getHeader();
        CrosstabSummaryHeader crosstabSummaryHeader = crosstabColumnGroup.getSummaryHeader();
        this.buildCrosstabElementsList((Band)crosstabTitleHeader, this.columnGroupBodyList);
        this.buildCrosstabElementsList((Band)crosstabHeader, this.columnGroupBodyList);
        this.buildCrosstabElementsList((Band)crosstabSummaryHeader, this.columnGroupBodyList);
        GroupBody body = crosstabColumnGroup.getBody();
        if (body instanceof CrosstabColumnGroupBody) {
            this.buildCrosstabColumnGroupBands((CrosstabColumnGroupBody)body);
        } else if (body instanceof CrosstabCellBody) {
            this.buildCrosstabCellBands((CrosstabCellBody)body);
        }
    }

    private void buildCrosstabRowGroupBands(CrosstabRowGroupBody crosstabRowGroupBody) {
        if (crosstabRowGroupBody == null) {
            return;
        }
        CrosstabRowGroup crosstabRowGroup = crosstabRowGroupBody.getGroup();
        CrosstabTitleHeader crosstabTitleHeader = crosstabRowGroup.getTitleHeader();
        CrosstabHeader crosstabHeader = crosstabRowGroup.getHeader();
        CrosstabSummaryHeader crosstabSummaryHeader = crosstabRowGroup.getSummaryHeader();
        this.buildCrosstabElementsList((Band)crosstabTitleHeader, this.rowGroupBodyList);
        this.buildCrosstabElementsList((Band)crosstabHeader, this.rowGroupBodyList);
        this.buildCrosstabElementsList((Band)crosstabSummaryHeader, this.rowGroupBodyList);
        GroupBody body = crosstabRowGroup.getBody();
        if (body instanceof CrosstabRowGroupBody) {
            this.buildCrosstabRowGroupBands((CrosstabRowGroupBody)body);
        } else if (body instanceof CrosstabColumnGroupBody) {
            this.buildCrosstabColumnGroupBands((CrosstabColumnGroupBody)body);
        }
    }

    private void buildCrosstabOtherRowGroupBands(CrosstabOtherGroup crosstabOtherGroup) {
        if (crosstabOtherGroup == null) {
            return;
        }
        GroupHeader otherGroupHeader = (GroupHeader)crosstabOtherGroup.getElement(0);
        for (int i = 0; i < otherGroupHeader.getElementCount(); ++i) {
            Element element = otherGroupHeader.getElement(i);
            this.otherGroupBodyList.add(element);
        }
        GroupBody groupBody = crosstabOtherGroup.getBody();
        if (groupBody instanceof CrosstabOtherGroupBody) {
            this.buildCrosstabOtherRowGroupBands(((CrosstabOtherGroupBody)groupBody).getGroup());
        } else if (groupBody instanceof CrosstabRowGroupBody) {
            this.buildCrosstabRowGroupBands((CrosstabRowGroupBody)groupBody);
        }
    }

    private void selectCrosstabElements(ArrayList<Element> elementsList) {
        if (elementsList == null) {
            return;
        }
        if (this.selectionModel == null) {
            this.selectionModel = this.getSelectionModel();
        }
        this.selectionModel.clearSelection();
        this.selectionModel.setSelectedElements(elementsList.toArray());
    }

    private void buildCrosstabElementsList(Band band, ArrayList<Element> elementsList) {
        if (band == null || elementsList == null) {
            return;
        }
        int count = band.getElementCount();
        for (int i = 0; i < count; ++i) {
            Element element = band.getElement(i);
            elementsList.add(element);
        }
    }

    private static enum CrosstabSelectionBandState {
        NONE{

            @Override
            public CrosstabSelectionBandState getNextState() {
                return OTHER;
            }

            @Override
            public CrosstabSelectionBandState getCurrentState() {
                return NONE;
            }
        }
        ,
        OTHER{

            @Override
            public CrosstabSelectionBandState getNextState() {
                return ROW;
            }

            @Override
            public CrosstabSelectionBandState getCurrentState() {
                return OTHER;
            }
        }
        ,
        ROW{

            @Override
            public CrosstabSelectionBandState getNextState() {
                return COLUMN;
            }

            @Override
            public CrosstabSelectionBandState getCurrentState() {
                return ROW;
            }
        }
        ,
        COLUMN{

            @Override
            public CrosstabSelectionBandState getNextState() {
                return CELL;
            }

            @Override
            public CrosstabSelectionBandState getCurrentState() {
                return COLUMN;
            }
        }
        ,
        CELL{

            @Override
            public CrosstabSelectionBandState getNextState() {
                return ALL;
            }

            @Override
            public CrosstabSelectionBandState getCurrentState() {
                return CELL;
            }
        }
        ,
        ALL{

            @Override
            public CrosstabSelectionBandState getNextState() {
                return NONE;
            }

            @Override
            public CrosstabSelectionBandState getCurrentState() {
                return ALL;
            }
        };


        public abstract CrosstabSelectionBandState getNextState();

        public abstract CrosstabSelectionBandState getCurrentState();
    }
}

