/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements.barcode;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.actions.ToggleStateAction;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.undo.AttributeEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.CompoundUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.designtime.ReportModelEventFilter;
import org.pentaho.reporting.engine.classic.core.designtime.ReportModelEventFilterFactory;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.extensions.modules.sbarcodes.SimpleBarcodesType;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class BarcodeTypeAction
extends AbstractElementSelectionAction
implements ToggleStateAction {
    private ReportModelEventFilter eventFilter;
    private String type;

    public BarcodeTypeAction(String type) {
        this.type = type;
        this.putValue("SwingSelectedKey", Boolean.FALSE);
        this.putValue("Name", type);
        this.putValue("ShortDescription", ActionMessages.getString("BarcodeTypeAction.Description", type));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("BarcodeTypeAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("BarcodeTypeAction.Accelerator"));
        this.eventFilter = new ReportModelEventFilterFactory().createAttributeFilter("http://reporting.pentaho.org/namespaces/engine/classic/extensions/sbarcodes/1.0", "type");
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
        if (this.eventFilter.isFilteredEvent(event)) {
            this.updateSelection();
        }
    }

    @Override
    public boolean isSelected() {
        return Boolean.TRUE.equals(this.getValue("SwingSelectedKey"));
    }

    public void setSelected(boolean selected) {
        this.putValue("SwingSelectedKey", selected);
    }

    @Override
    protected void updateSelection() {
        boolean selected;
        super.updateSelection();
        DocumentContextSelectionModel model = this.getSelectionModel();
        if (model == null) {
            return;
        }
        List<Element> visualElements = model.getSelectedElementsOfType(Element.class);
        if (visualElements.isEmpty()) {
            selected = false;
        } else {
            selected = true;
            for (Element visualElement : visualElements) {
                Object oldValue = visualElement.getAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/sbarcodes/1.0", "type");
                selected &= ObjectUtilities.equal((Object)oldValue, (Object)this.type);
            }
        }
        this.setSelected(selected);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DocumentContextSelectionModel model = this.getSelectionModel();
        if (model == null) {
            return;
        }
        Element[] visualElements = this.filterBarcodeElements(model);
        if (visualElements.length == 0) {
            return;
        }
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        ArrayList<AttributeEditUndoEntry> undos = new ArrayList<AttributeEditUndoEntry>();
        for (int i = 0; i < visualElements.length; ++i) {
            Element element = visualElements[i];
            Object oldValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/sbarcodes/1.0", "type");
            AttributeEditUndoEntry entry = new AttributeEditUndoEntry(element.getObjectID(), "http://reporting.pentaho.org/namespaces/engine/classic/extensions/sbarcodes/1.0", "type", oldValue, this.type);
            undos.add(entry);
            element.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/sbarcodes/1.0", "type", (Object)this.type);
        }
        this.getActiveContext().getUndo().addChange(ActionMessages.getString("BarcodeTypeAction.UndoName", this.type), new CompoundUndoEntry(undos.toArray(new UndoEntry[undos.size()])));
    }

    private Element[] filterBarcodeElements(DocumentContextSelectionModel model) {
        List<Element> visualElements = model.getSelectedElementsOfType(Element.class);
        ArrayList<Element> retval = new ArrayList<Element>();
        String name = SimpleBarcodesType.INSTANCE.getMetaData().getName();
        for (Element element : visualElements) {
            if (!name.equals(element.getElementTypeName())) continue;
            retval.add(element);
        }
        return retval.toArray(new Element[retval.size()]);
    }
}

