/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements.format;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.undo.CompoundUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.StyleEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;

public final class ApplyFontFamilyAction
extends AbstractElementSelectionAction {
    private JComboBox comboBox;

    public ApplyFontFamilyAction(JComboBox comboBox) {
        this.comboBox = comboBox;
        this.putValue("Name", ActionMessages.getString("ApplyFontFamilyAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("ApplyFontFamilyAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("ApplyFontFamilyAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("ApplyFontFamilyAction.Accelerator"));
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = this.comboBox.getSelectedItem();
        if (o != null && !(o instanceof String)) {
            return;
        }
        String font = (String)o;
        DocumentContextSelectionModel model = this.getSelectionModel();
        if (model == null) {
            return;
        }
        List<Element> visualElements = model.getSelectedElementsOfType(Element.class);
        ArrayList<StyleEditUndoEntry> undos = new ArrayList<StyleEditUndoEntry>();
        for (Element visualElement : visualElements) {
            undos.add(StyleEditUndoEntry.createConditional((ReportElement)visualElement, TextStyleKeys.FONT, font));
            visualElement.getStyle().setStyleProperty(TextStyleKeys.FONT, (Object)font);
            visualElement.notifyNodePropertiesChanged();
        }
        this.getActiveContext().getUndo().addChange(ActionMessages.getString("ApplyFontFamilyAction.UndoName", new Object[0]), new CompoundUndoEntry(undos.toArray(new UndoEntry[undos.size()])));
    }
}

