/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report;

import java.awt.event.ActionEvent;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.actions.ToggleStateAction;
import org.pentaho.reporting.designer.core.editor.structuretree.ReportQueryNode;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ActivateQueryAction
extends AbstractElementSelectionAction
implements ToggleStateAction {
    public ActivateQueryAction() {
        this.putValue("Name", ActionMessages.getString("ActivateQueryAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("ActivateQueryAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("ActivateQueryAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("ActivateQueryAction.Accelerator"));
    }

    @Override
    public boolean isSelected() {
        return Boolean.TRUE.equals(this.getValue("SwingSelectedKey"));
    }

    public void setSelected(boolean selected) {
        this.putValue("SwingSelectedKey", selected);
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    protected void updateSelection() {
        DocumentContextSelectionModel reportSelectionModel = this.getSelectionModel();
        if (reportSelectionModel == null) {
            this.setEnabled(false);
            return;
        }
        Object[] selectedElements = reportSelectionModel.getSelectedElements();
        for (int i = 0; i < selectedElements.length; ++i) {
            Object selectedElement = selectedElements[i];
            if (!(selectedElement instanceof ReportQueryNode)) continue;
            ReportQueryNode node = (ReportQueryNode)selectedElement;
            this.setSelected(ObjectUtilities.equal((Object)node.getQueryName(), (Object)this.getActiveContext().getReportDefinition().getQuery()));
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DocumentContextSelectionModel reportSelectionModel = this.getSelectionModel();
        if (reportSelectionModel == null) {
            return;
        }
        Object[] selectedElements = reportSelectionModel.getSelectedElements();
        for (int i = 0; i < selectedElements.length; ++i) {
            Object selectedElement = selectedElements[i];
            if (!(selectedElement instanceof ReportQueryNode)) continue;
            ReportQueryNode node = (ReportQueryNode)selectedElement;
            this.getActiveContext().getReportDefinition().setQuery(node.getQueryName());
            return;
        }
    }
}

