/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.expressions.ExpressionChooserDialog;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.undo.ExpressionAddedUndoEntry;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public final class AddExpressionsAction
extends AbstractReportContextAction {
    private static int nameCounter = 0;

    public AddExpressionsAction() {
        this.putValue("Name", ActionMessages.getString("AddExpressionsAction.Text", new Object[0]));
        this.putValue("Default", ActionMessages.getString("AddExpressionsAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("AddExpressionsAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("AddExpressionsAction.Accelerator"));
        this.putValue("SmallIcon", IconLoader.getInstance().getFunctionIcon());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        Component parent = this.getReportDesignerContext().getView().getParent();
        Window window = LibSwingUtil.getWindowAncestor((Component)parent);
        ExpressionChooserDialog dialog = window instanceof JDialog ? new ExpressionChooserDialog((JDialog)window) : (window instanceof JFrame ? new ExpressionChooserDialog((JFrame)window) : new ExpressionChooserDialog());
        Expression expression = dialog.performSelect();
        if (expression == null) {
            return;
        }
        AbstractReportDefinition definition = activeContext.getReportDefinition();
        String possibleName = expression.getClass().getSimpleName() + nameCounter++;
        while (definition.getExpressions().get(possibleName) != null) {
            possibleName = expression.getClass().getSimpleName() + nameCounter++;
        }
        expression.setName(possibleName);
        int position = definition.getExpressions().size();
        activeContext.getUndo().addChange(ActionMessages.getString("AddExpressionsAction.Text", new Object[0]), new ExpressionAddedUndoEntry(position, expression));
        definition.addExpression(expression);
    }
}

