/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.actions.report.CloseReportAction;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;

public class CloseOtherReportsAction
extends AbstractReportContextAction {
    private int tabIndex;

    public CloseOtherReportsAction() {
        this(-1);
    }

    public CloseOtherReportsAction(int indexToClose) {
        this.tabIndex = indexToClose;
        this.putValue("Name", ActionMessages.getString("CloseOtherReportsAction.Text", new Object[0]));
        this.putValue("Default", ActionMessages.getString("CloseOtherReportsAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("CloseOtherReportsAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("CloseOtherReportsAction.Accelerator"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDesignerContext reportDesignerContext1 = this.getReportDesignerContext();
        if (this.tabIndex == -1) {
            ReportDocumentContext activeContext = this.getActiveContext();
            if (activeContext == null) {
                return;
            }
            this.performCloseReport(reportDesignerContext1, activeContext);
        } else if (this.tabIndex >= 0 && this.tabIndex < reportDesignerContext1.getReportRenderContextCount()) {
            ReportRenderContext context = reportDesignerContext1.getReportRenderContext(this.tabIndex);
            this.performCloseReport(reportDesignerContext1, context);
        }
    }

    private void performCloseReport(ReportDesignerContext context, ReportDocumentContext activeContext) {
        int contextCount = context.getReportRenderContextCount();
        ArrayList<ReportRenderContext> contexts = new ArrayList<ReportRenderContext>(contextCount);
        for (int i = 0; i < contextCount; ++i) {
            ReportRenderContext renderContext = context.getReportRenderContext(i);
            if (renderContext == activeContext || ModelUtility.isDescendant((Section)renderContext.getReportDefinition(), (ReportElement)activeContext.getReportDefinition())) continue;
            contexts.add(renderContext);
        }
        ReportRenderContext[] contextArray = contexts.toArray(new ReportRenderContext[contexts.size()]);
        ReportRenderContext[] filteredArray = CloseReportAction.filterSubreports(this.getReportDesignerContext(), contextArray);
        for (int i = 0; i < filteredArray.length; ++i) {
            ReportRenderContext reportRenderContext = filteredArray[i];
            if (CloseReportAction.performCloseReport(this.getReportDesignerContext(), reportRenderContext)) continue;
            return;
        }
    }
}

