/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.editor.parameters.DataFactoryWrapper;
import org.pentaho.reporting.designer.core.editor.parameters.ParameterDialog;
import org.pentaho.reporting.designer.core.editor.parameters.SubReportParameterDialog;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.undo.CompoundUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.DataSourceEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.ParameterEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.parameters.ModifiableReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class EditParametersAction
extends AbstractElementSelectionAction {
    public EditParametersAction() {
        this.configureForMaster();
    }

    private void configureForSubreport() {
        this.putValue("Name", ActionMessages.getString("EditParametersAction.SubReport.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("EditParametersAction.SubReport.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("EditParametersAction.SubReport.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("EditParametersAction.SubReport.Accelerator"));
        this.putValue("SmallIcon", IconLoader.getInstance().getParameterIcon());
    }

    private void configureForMaster() {
        this.putValue("Name", ActionMessages.getString("EditParametersAction.MasterReport.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("EditParametersAction.MasterReport.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("EditParametersAction.MasterReport.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("EditParametersAction.MasterReport.Accelerator"));
        this.putValue("SmallIcon", IconLoader.getInstance().getParameterIcon());
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    protected void updateActiveContext(ReportRenderContext oldContext, ReportRenderContext newContext) {
        super.updateActiveContext(oldContext, newContext);
        if (newContext == null) {
            this.configureForMaster();
            return;
        }
        AbstractReportDefinition definition = newContext.getReportDefinition();
        if (definition instanceof SubReport) {
            this.configureForSubreport();
        } else {
            this.configureForMaster();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        if (activeContext.getReportDefinition() instanceof SubReport) {
            EditParametersAction.performEditSubReportParameters(this.getReportDesignerContext());
            return;
        }
        Object[] selectedElements = this.getSelectionModel().getSelectedElements();
        for (int i = 0; i < selectedElements.length; ++i) {
            Object theElement = selectedElements[i];
            if (!(theElement instanceof ParameterDefinitionEntry)) continue;
            try {
                EditParametersAction.performEditMasterReportParameters(this.getReportDesignerContext(), (ParameterDefinitionEntry)theElement);
            }
            catch (ReportDataFactoryException theExc) {
                UncaughtExceptionsModel.getInstance().addException(theExc);
            }
            break;
        }
    }

    public static void performEditSubReportParameters(ReportDesignerContext context) {
        ReportDocumentContext activeContext = context.getActiveContext();
        if (activeContext == null) {
            throw new NullPointerException();
        }
        AbstractReportDefinition definition = activeContext.getReportDefinition();
        if (!(definition instanceof SubReport)) {
            throw new IllegalStateException();
        }
        SubReport subReport = (SubReport)definition;
        Component parent = context.getView().getParent();
        Window window = LibSwingUtil.getWindowAncestor((Component)parent);
        SubReportParameterDialog parameterDialog = window instanceof JDialog ? new SubReportParameterDialog((JDialog)window) : (window instanceof JFrame ? new SubReportParameterDialog((JFrame)window) : new SubReportParameterDialog());
        SubReportParameterDialog.EditResult editResult = parameterDialog.performEdit(context, subReport.getInputMappings(), subReport.getExportMappings());
        if (editResult == null) {
            return;
        }
        ParameterMapping[] oldImportMapping = subReport.getInputMappings();
        ParameterMapping[] oldExportMapping = subReport.getExportMappings();
        activeContext.getUndo().addChange(ActionMessages.getString("EditParametersAction.SubReport.Text", new Object[0]), new EditSubreportParametersUndoEntry(oldImportMapping, oldExportMapping, editResult.getImportParameters(), editResult.getExportParameters()));
        subReport.setExportMappings(editResult.getExportParameters());
        subReport.setInputMappings(editResult.getImportParameters());
    }

    public static void performEditMasterReportParameters(ReportDesignerContext context, ParameterDefinitionEntry parameter) throws ReportDataFactoryException {
        ParameterDialog.ParameterEditResult definitionEntry;
        ReportDocumentContext activeContext = context.getActiveContext();
        if (activeContext == null) {
            return;
        }
        Component theParent = context.getView().getParent();
        Window theWindow = LibSwingUtil.getWindowAncestor((Component)theParent);
        ParameterDialog parameterDialog = theWindow instanceof JDialog ? new ParameterDialog((JDialog)theWindow, context) : (theWindow instanceof JFrame ? new ParameterDialog((JFrame)theWindow, context) : new ParameterDialog(context));
        MasterReport masterReport = (MasterReport)activeContext.getContextRoot();
        ModifiableReportParameterDefinition parameterDefinition = (ModifiableReportParameterDefinition)masterReport.getParameterDefinition();
        int index = -1;
        for (int i = 0; i < parameterDefinition.getParameterCount(); ++i) {
            ParameterDefinitionEntry definition = parameterDefinition.getParameterDefinition(i);
            if (definition != parameter) continue;
            index = i;
            break;
        }
        if (index == -1) {
            if (parameter == null) {
                index = parameterDefinition.getParameterCount();
            } else {
                throw new IndexOutOfBoundsException("This parameter is not part of the existing parameter collection");
            }
        }
        if ((definitionEntry = parameterDialog.performEditParameter(context, masterReport, parameter)) != null) {
            ParameterEditUndoEntry parameterEditUndoEntry = new ParameterEditUndoEntry(index, parameter, definitionEntry.getParameter());
            ArrayList<UndoEntry> undos = new ArrayList<UndoEntry>();
            undos.add(parameterEditUndoEntry);
            DataFactoryWrapper[] dataFactoryWrappers = definitionEntry.getWrappers();
            for (int i = 0; i < dataFactoryWrappers.length; ++i) {
                DataFactoryWrapper dataFactoryWrapper = dataFactoryWrappers[i];
                if (dataFactoryWrapper.getOriginalDataFactory() == dataFactoryWrapper.getEditedDataFactory()) continue;
                undos.add(new DataSourceEditUndoEntry(i, dataFactoryWrapper.getOriginalDataFactory(), dataFactoryWrapper.getEditedDataFactory()));
            }
            CompoundUndoEntry undoEntry = new CompoundUndoEntry(undos.toArray(new UndoEntry[undos.size()]));
            undoEntry.redo(activeContext);
            activeContext.getUndo().addChange(ActionMessages.getString("EditParametersAction.MasterReport.Text", new Object[0]), undoEntry);
        }
    }

    private static class EditSubreportParametersUndoEntry
    implements UndoEntry {
        private ParameterMapping[] oldImportParameters;
        private ParameterMapping[] oldExportParameters;
        private ParameterMapping[] newImportParameters;
        private ParameterMapping[] newExportParameters;

        private EditSubreportParametersUndoEntry(ParameterMapping[] oldImportParameters, ParameterMapping[] oldExportParameters, ParameterMapping[] newImportParameters, ParameterMapping[] newExportParameters) {
            this.oldImportParameters = oldImportParameters;
            this.oldExportParameters = oldExportParameters;
            this.newImportParameters = newImportParameters;
            this.newExportParameters = newExportParameters;
        }

        @Override
        public void undo(ReportDocumentContext renderContext) {
            SubReport reportDefinition = (SubReport)renderContext.getReportDefinition();
            reportDefinition.setInputMappings(this.oldImportParameters);
            reportDefinition.setExportMappings(this.oldExportParameters);
        }

        @Override
        public void redo(ReportDocumentContext renderContext) {
            SubReport reportDefinition = (SubReport)renderContext.getReportDefinition();
            reportDefinition.setInputMappings(this.newImportParameters);
            reportDefinition.setExportMappings(this.newExportParameters);
        }

        @Override
        public UndoEntry merge(UndoEntry newEntry) {
            return null;
        }
    }
}

