/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.format.RowBandingDialog;
import org.pentaho.reporting.designer.core.util.undo.ExpressionAddedUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.ExpressionEditUndoEntry;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionCollection;
import org.pentaho.reporting.engine.classic.core.function.RowBandingFunction;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class EditRowBandingAction
extends AbstractReportContextAction {
    public EditRowBandingAction() {
        this.putValue("Name", ActionMessages.getString("EditRowBandingAction.Text", new Object[0]));
        this.putValue("Default", ActionMessages.getString("EditRowBandingAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("EditRowBandingAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("EditRowBandingAction.Accelerator"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        ReportDesignerContext context = this.getReportDesignerContext();
        Component parent = context.getView().getParent();
        Window window = LibSwingUtil.getWindowAncestor((Component)parent);
        RowBandingDialog dialog = window instanceof JDialog ? new RowBandingDialog((JDialog)window) : (window instanceof JFrame ? new RowBandingDialog((JFrame)window) : new RowBandingDialog());
        RowBandingFunction function = this.findRowbandingFunction(activeContext);
        AbstractReportDefinition report = activeContext.getReportDefinition();
        if (function == null) {
            RowBandingFunction newFunction = new RowBandingFunction();
            if (dialog.performEdit(newFunction)) {
                report.getExpressions().add((Expression)newFunction);
                activeContext.getUndo().addChange(ActionMessages.getString("EditRowBandingAction.Text", new Object[0]), new ExpressionAddedUndoEntry(report.getExpressions().size() - 1, (Expression)newFunction));
                report.notifyNodeChildAdded((Object)function);
            }
        } else {
            RowBandingFunction instance = (RowBandingFunction)function.getInstance();
            if (dialog.performEdit(instance)) {
                ExpressionCollection expressionCollection = report.getExpressions();
                int idx = expressionCollection.indexOf((Expression)function);
                expressionCollection.set(idx, (Expression)instance);
                activeContext.getUndo().addChange(ActionMessages.getString("EditRowBandingAction.Text", new Object[0]), new ExpressionEditUndoEntry(idx, (Expression)function, (Expression)instance));
                report.fireModelLayoutChanged((ReportElement)report, 0, (Object)instance);
            }
        }
    }

    private RowBandingFunction findRowbandingFunction(ReportDocumentContext activeContext) {
        Expression[] expressions = activeContext.getReportDefinition().getExpressions().getExpressions();
        for (int i = 0; i < expressions.length; ++i) {
            Expression expression = expressions[i];
            if (!(expression instanceof RowBandingFunction)) continue;
            return (RowBandingFunction)expression;
        }
        return null;
    }
}

