/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report.export;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.AbstractGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExportActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public abstract class AbstractExportAction
extends AbstractReportContextAction {
    private ExportActionPlugin actionPlugin;
    private DefaultExportContext exportContext;

    public AbstractExportAction(ExportActionPlugin actionPlugin) {
        this.actionPlugin = actionPlugin;
        this.exportContext = new DefaultExportContext();
        this.actionPlugin.addPropertyChangeListener("enabled", (PropertyChangeListener)new EnableChangeListener());
        this.actionPlugin.initialize((SwingGuiContext)this.exportContext);
        this.putValue("Name", actionPlugin.getDisplayName());
        this.putValue("ShortDescription", actionPlugin.getShortDescription());
        this.putValue("MnemonicKey", actionPlugin.getMnemonicKey());
        this.putValue("SmallIcon", actionPlugin.getSmallIcon());
        this.putValue("Icon24", actionPlugin.getLargeIcon());
        this.setEnabled(actionPlugin.isEnabled());
    }

    @Override
    protected void updateActiveContext(ReportRenderContext oldContext, ReportRenderContext newContext) {
        super.updateActiveContext(oldContext, newContext);
        MasterReport oldReport = oldContext != null ? oldContext.getMasterReportElement() : null;
        MasterReport newReport = newContext != null ? newContext.getMasterReportElement() : null;
        this.exportContext.fireReportChange(oldReport, newReport);
        this.setEnabled(newContext != null && this.actionPlugin.isEnabled());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.getActiveContext() == null) {
            return;
        }
        if (!this.actionPlugin.isEnabled()) {
            return;
        }
        MasterReport reportJob = (MasterReport)this.getActiveContext().getContextRoot();
        if (reportJob == null) {
            return;
        }
        try {
            this.actionPlugin.performExport(reportJob.clone());
        }
        catch (Exception e1) {
            UncaughtExceptionsModel.getInstance().addException(e1);
        }
    }

    private class EnableChangeListener
    implements PropertyChangeListener {
        protected EnableChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AbstractExportAction.this.setEnabled(AbstractExportAction.this.getActiveContext() != null && AbstractExportAction.this.actionPlugin.isEnabled());
        }
    }

    private class DefaultExportContext
    extends AbstractGuiContext {
        private DefaultExportContext() {
        }

        public Window getWindow() {
            ReportDesignerContext context = AbstractExportAction.this.getReportDesignerContext();
            if (context == null) {
                return null;
            }
            Component parent = context.getView().getParent();
            return LibSwingUtil.getWindowAncestor((Component)parent);
        }

        public MasterReport getReportJob() {
            ReportDocumentContext activeContext = AbstractExportAction.this.getActiveContext();
            if (activeContext == null) {
                return null;
            }
            return (MasterReport)activeContext.getContextRoot();
        }

        public void fireReportChange(MasterReport oldReport, MasterReport newReport) {
            this.firePropertyChange("reportJob", oldReport, newReport);
        }
    }
}

