/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report.preview;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewDialog;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public final class PreviewSwingAction
extends AbstractReportContextAction {
    public PreviewSwingAction() {
        this.putValue("Name", ActionMessages.getString("PreviewSwingAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("PreviewSwingAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("PreviewSwingAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("PreviewSwingAction.Accelerator"));
        this.putValue("SmallIcon", IconLoader.getInstance().getCreateReportIcon());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Rectangle rectangle;
        if (this.getActiveContext() == null) {
            return;
        }
        MasterReport reportElement = (MasterReport)this.getActiveContext().getContextRoot();
        Component parent = this.getReportDesignerContext().getView().getParent();
        Window window = LibSwingUtil.getWindowAncestor((Component)parent);
        PreviewDialog dialog = window instanceof JDialog ? new PreviewDialog((Dialog)((JDialog)window)) : (window instanceof JFrame ? new PreviewDialog((Frame)((JFrame)window)) : new PreviewDialog());
        dialog.addWindowListener((WindowListener)new PreviewSizeMonitor(reportElement));
        dialog.setReportJob(reportElement);
        dialog.pack();
        Object attribute = reportElement.getAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "preview-dialog-bounds");
        if (attribute instanceof String && (rectangle = LibSwingUtil.parseRectangle((String)attribute.toString())) != null && LibSwingUtil.safeRestoreWindow((Window)dialog, (Rectangle)rectangle)) {
            dialog.setVisible(true);
            return;
        }
        dialog.setSize(700, 700);
        LibSwingUtil.centerDialogInParent((Dialog)dialog);
        dialog.setVisible(true);
    }

    private static class PreviewSizeMonitor
    extends WindowAdapter {
        private MasterReport report;

        private PreviewSizeMonitor(MasterReport report) {
            if (report == null) {
                throw new NullPointerException();
            }
            this.report = report;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.report.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "preview-dialog-bounds", (Object)LibSwingUtil.rectangleToString((Rectangle)e.getWindow().getBounds()));
        }
    }
}

