/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.selection;

import java.awt.Component;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import javax.swing.FocusManager;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.util.IconLoader;

public final class DeselectAllAction
extends AbstractReportContextAction {
    public DeselectAllAction() {
        this.putValue("Name", ActionMessages.getString("DeselectAllAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("DeselectAllAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("DeselectAllAction.Mnemonic"));
        this.putValue("SmallIcon", IconLoader.getInstance().getDeselectAllIcon());
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("DeselectAllAction.Accelerator"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Component owner = FocusManager.getCurrentManager().getPermanentFocusOwner();
        if (owner instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)owner;
            textComponent.select(textComponent.getCaretPosition(), textComponent.getCaretPosition());
        } else if (owner instanceof TextComponent) {
            TextComponent textComponent = (TextComponent)owner;
            textComponent.select(textComponent.getCaretPosition(), textComponent.getCaretPosition());
        } else if (owner instanceof JTable) {
            JTable table = (JTable)owner;
            table.clearSelection();
        } else if (owner instanceof JList) {
            JList list = (JList)owner;
            list.getSelectionModel().clearSelection();
            list.repaint();
        } else if (owner instanceof JTree) {
            JTree list = (JTree)owner;
            list.clearSelection();
            list.repaint();
        } else {
            ReportDocumentContext activeContext = this.getActiveContext();
            if (activeContext != null) {
                activeContext.getSelectionModel().clearSelection();
            }
        }
    }
}

