/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.auth;

import java.io.Serializable;
import java.util.Properties;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.settings.prefs.PreferencesMap;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public class AuthenticationData
implements Serializable,
PreferencesMap.ConfigurationData {
    private String url;
    private Properties properties;
    private long lastChanged;

    public AuthenticationData(String url) {
        this(url, System.currentTimeMillis());
    }

    public AuthenticationData(AuthenticationData data) {
        this.url = data.url;
        this.properties = (Properties)data.properties.clone();
        this.lastChanged = data.lastChanged;
    }

    public AuthenticationData(String baseUrl, String username, String password, int timeout) {
        this(baseUrl);
        this.setOption("user", username);
        this.setOption("password", password);
        this.setOption("timeout", String.valueOf(timeout));
    }

    public AuthenticationData(String url, long lastChanged) {
        if (url == null) {
            throw new NullPointerException();
        }
        this.url = url;
        this.properties = new Properties();
        this.lastChanged = lastChanged;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public String getOption(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.properties.getProperty(key);
    }

    @Override
    public String getKey() {
        return this.getUrl();
    }

    @Override
    public String[] getDefinedOptions() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    @Override
    public void setOption(String key, String value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.setProperty(key, value);
        }
        this.lastChanged = System.currentTimeMillis();
    }

    @Override
    public long getLastChanged() {
        return this.lastChanged;
    }

    @Override
    public void setLastChanged(long time) {
        this.lastChanged = time;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthenticationData)) {
            return false;
        }
        AuthenticationData that = (AuthenticationData)o;
        return this.url.equals(that.url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String getUsername() {
        return this.getOption("user");
    }

    public String getPassword() {
        return this.getOption("password");
    }

    public int getTimeout() {
        String s = this.getOption("timeout");
        return ParserUtil.parseInt((String)s, (int)WorkspaceSettings.getInstance().getConnectionTimeout());
    }
}

