/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.auth;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.pentaho.reporting.designer.core.ReportDesignerBoot;
import org.pentaho.reporting.designer.core.auth.AuthenticationStore;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class AuthenticationHelper {
    private static final char DOMAIN_SEPARATOR = '\\';
    private static final String NT_AUTH_CONFIGKEY = "org.pentaho.reporting.designer.core.auth.AllowNtDomainAuthentication";

    private AuthenticationHelper() {
    }

    public static Credentials getCredentials(String user, String password) {
        if (StringUtils.isEmpty((String)user)) {
            return null;
        }
        Configuration config = ReportDesignerBoot.getInstance().getGlobalConfig();
        if (!"true".equals(config.getConfigProperty(NT_AUTH_CONFIGKEY, "false"))) {
            return new UsernamePasswordCredentials(user, password);
        }
        int domainIdx = user.indexOf(92);
        if (domainIdx == -1) {
            return new UsernamePasswordCredentials(user, password);
        }
        try {
            String domain = user.substring(0, domainIdx);
            String username = user.substring(domainIdx + 1);
            String host = InetAddress.getLocalHost().getHostName();
            return new NTCredentials(username, password, host, domain);
        }
        catch (UnknownHostException uhe) {
            return new UsernamePasswordCredentials(user, password);
        }
    }

    public static Credentials getCredentials(String url, AuthenticationStore store) {
        String user = store.getUsername(url);
        if (user == null) {
            return null;
        }
        String password = store.getPassword(url);
        Configuration config = ReportDesignerBoot.getInstance().getGlobalConfig();
        if (!"true".equals(config.getConfigProperty(NT_AUTH_CONFIGKEY, "false"))) {
            return new UsernamePasswordCredentials(user, password);
        }
        int domainIdx = user.indexOf(92);
        if (domainIdx == -1) {
            return new UsernamePasswordCredentials(user, password);
        }
        try {
            String domain = user.substring(0, domainIdx);
            String username = user.substring(domainIdx + 1);
            String host = InetAddress.getLocalHost().getHostName();
            return new NTCredentials(username, password, host, domain);
        }
        catch (UnknownHostException uhe) {
            return new UsernamePasswordCredentials(user, password);
        }
    }
}

