/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.auth;

import java.util.Enumeration;
import java.util.Properties;
import java.util.prefs.Preferences;
import org.pentaho.reporting.designer.core.auth.AuthenticationData;
import org.pentaho.reporting.designer.core.auth.AuthenticationStore;
import org.pentaho.reporting.designer.core.auth.PasswordPolicyManager;
import org.pentaho.reporting.designer.core.settings.prefs.PreferencesMap;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class GlobalAuthenticationStore
extends PreferencesMap<AuthenticationData>
implements AuthenticationStore {
    private PasswordPolicyManager policyManager = PasswordPolicyManager.getInstance();
    private static final String[] EMPTY_STRINGS = new String[0];

    public GlobalAuthenticationStore() {
        super(Preferences.userNodeForPackage(GlobalAuthenticationStore.class).node("AuthStore"));
        this.init();
    }

    @Override
    protected AuthenticationData create(String key, long time) {
        return new AuthenticationData(key, time);
    }

    @Override
    public AuthenticationData getCredentials(String url) {
        AuthenticationData configurationData = (AuthenticationData)this.get(url);
        if (configurationData == null) {
            return null;
        }
        return new AuthenticationData(configurationData);
    }

    @Override
    public String getUsername(String url) {
        AuthenticationData data = (AuthenticationData)this.get(url);
        if (data == null) {
            return null;
        }
        return data.getOption("user");
    }

    @Override
    public String getPassword(String url) {
        AuthenticationData data = (AuthenticationData)this.get(url);
        if (data == null) {
            return null;
        }
        return data.getOption("password");
    }

    @Override
    public String getOption(String url, String key) {
        AuthenticationData data = (AuthenticationData)this.get(url);
        if (data == null) {
            return null;
        }
        return data.getOption(key);
    }

    @Override
    public String[] getDefinedOptions(String url) {
        AuthenticationData data = (AuthenticationData)this.get(url);
        if (data == null) {
            return EMPTY_STRINGS;
        }
        return data.getDefinedOptions();
    }

    @Override
    public String[] getKnownURLs() {
        return this.getKnownKeys();
    }

    @Override
    public void add(AuthenticationData authenticationData, boolean persist) {
        if (persist && this.policyManager.isPasswordStoringAllowed(authenticationData.getUrl())) {
            super.add(authenticationData);
        }
    }

    @Override
    public void addCredentials(String url, String user, String password, Properties options, boolean persist) {
        if (persist && this.policyManager.isPasswordStoringAllowed(url)) {
            this.add(GlobalAuthenticationStore.createAuthenticationData(url, user, password, options), persist);
        }
    }

    public static AuthenticationData createAuthenticationData(String url, String user, String password, Properties options) {
        AuthenticationData data = new AuthenticationData(url);
        if (options != null) {
            Enumeration<?> enumeration = options.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = options.getProperty(key);
                data.setOption(key, value);
            }
        }
        data.setOption("user", user);
        data.setOption("password", password);
        return data;
    }

    @Override
    protected void add(AuthenticationData configurationData) {
        Object oldData = this.get(configurationData.getKey());
        if (oldData != null) {
            String[] strings = oldData.getDefinedOptions();
            for (int i = 0; i < strings.length; ++i) {
                String key = strings[i];
                if (configurationData.getOption(key) != null) continue;
                configurationData.setOption(key, oldData.getOption(key));
            }
        }
        super.add(configurationData);
    }

    @Override
    public void removeCredentials(String url) {
        this.remove(url);
    }

    @Override
    public int getIntOption(String path, String key, int defaultValue) {
        String option = this.getOption(path, key);
        if (StringUtils.isEmpty((String)option)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(option);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

