/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.auth;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.pentaho.reporting.designer.core.auth.AuthenticationData;
import org.pentaho.reporting.designer.core.auth.AuthenticationStore;
import org.pentaho.reporting.designer.core.auth.GlobalAuthenticationStore;
import org.pentaho.reporting.designer.core.settings.prefs.PreferencesMap;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class ReportAuthenticationStore
implements AuthenticationStore {
    private AuthenticationStore backend;
    private HashMap<String, AuthenticationData> localStorage;

    public ReportAuthenticationStore(AuthenticationStore backend) {
        if (backend == null) {
            throw new NullPointerException();
        }
        this.backend = backend;
        this.localStorage = new HashMap();
    }

    @Override
    public String getUsername(String url) {
        AuthenticationData data = this.localStorage.get(url);
        if (data != null) {
            return data.getOption("user");
        }
        return this.backend.getUsername(url);
    }

    @Override
    public String getPassword(String url) {
        AuthenticationData data = this.localStorage.get(url);
        if (data != null) {
            return data.getOption("password");
        }
        return this.backend.getPassword(url);
    }

    @Override
    public String getOption(String url, String key) {
        AuthenticationData data = this.localStorage.get(url);
        if (data != null) {
            return data.getOption(key);
        }
        return this.backend.getOption(url, key);
    }

    @Override
    public String[] getDefinedOptions(String url) {
        AuthenticationData data = this.localStorage.get(url);
        if (data == null) {
            return this.backend.getDefinedOptions(url);
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        keys.addAll(Arrays.asList(this.backend.getDefinedOptions(url)));
        keys.addAll(Arrays.asList(data.getDefinedOptions()));
        return keys.toArray(new String[keys.size()]);
    }

    @Override
    public String[] getKnownURLs() {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        keys.addAll(Arrays.asList(this.backend.getKnownURLs()));
        keys.addAll(Arrays.asList(this.localStorage.keySet().toArray(new String[this.localStorage.size()])));
        return keys.toArray(new String[keys.size()]);
    }

    @Override
    public void addCredentials(String url, String user, String password, Properties options, boolean persist) {
        this.add(GlobalAuthenticationStore.createAuthenticationData(url, user, password, options), persist);
    }

    @Override
    public void add(AuthenticationData data, boolean persist) {
        PreferencesMap.ConfigurationData oldData;
        if (persist) {
            this.backend.add(data, true);
        }
        if ((oldData = (PreferencesMap.ConfigurationData)this.localStorage.get(data.getKey())) != null) {
            String[] strings = oldData.getDefinedOptions();
            for (int i = 0; i < strings.length; ++i) {
                String key = strings[i];
                if (data.getOption(key) != null) continue;
                data.setOption(key, oldData.getOption(key));
            }
        }
        this.localStorage.put(data.getKey(), data);
    }

    @Override
    public void removeCredentials(String url) {
        this.backend.removeCredentials(url);
    }

    @Override
    public AuthenticationData getCredentials(String url) {
        AuthenticationData authenticationData = this.localStorage.get(url);
        if (authenticationData != null) {
            return authenticationData;
        }
        return this.backend.getCredentials(url);
    }

    @Override
    public int getIntOption(String path, String key, int defaultValue) {
        String option = this.getOption(path, key);
        if (StringUtils.isEmpty((String)option)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(option);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

