/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.attributes;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.attributes.AbstractAttributeTableModel;
import org.pentaho.reporting.designer.core.util.table.GroupedName;
import org.pentaho.reporting.designer.core.util.table.GroupingHeader;
import org.pentaho.reporting.designer.core.util.undo.AttributeEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.CompoundUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoManager;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class AttributeTableModel
extends AbstractAttributeTableModel {
    private static final Log logger = LogFactory.getLog(AttributeTableModel.class);
    private static final ReportElement[] EMPTY = new ReportElement[0];
    private static final Object[] EMPTY_VALUES = new Object[0];
    private static final Object NULL_INDICATOR = new Object();
    private ExecutorService pool = Executors.newSingleThreadExecutor();
    private static final String[] EMPTY_FIELDS = new String[0];

    public AttributeTableModel() {
        this.setDataBackend(new AttributeDataBackend());
    }

    protected AttributeDataBackend getAttributeDataBackend() {
        return (AttributeDataBackend)this.getDataBackend();
    }

    public ReportElement[] getData() {
        return this.getAttributeDataBackend().getData();
    }

    public void setData(ReportElement[] elements) {
        if (AttributeTableModel.isSameElements(elements, this.getData(), null)) {
            SwingUtilities.invokeLater(new AbstractAttributeTableModel.SameElementsUpdateDataTask(this, this.getDataBackend()));
            return;
        }
        this.pool.submit(new AbstractAttributeTableModel.UpdateDataTask(this, elements));
    }

    @Override
    protected void refreshData() {
        ReportElement[] data = this.getAttributeDataBackend().getData();
        this.setDataBackend(this.updateData(data));
    }

    @Override
    protected AbstractAttributeTableModel.DataBackend createDataBackend(GroupingHeader[] headers, AttributeMetaData[] metaData, ReportElement[] elements, ElementType[] elementTypes) {
        super.createDataBackend(headers, metaData, elements, elementTypes);
        return new AttributeDataBackend(metaData, headers, elements);
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        AttributeMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return this.getGroupings(rowIndex);
        }
        switch (columnIndex) {
            case 0: {
                return new GroupedName((MetaData)metaData);
            }
            case 1: {
                return this.computeFullValue(metaData, rowIndex);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        AttributeMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return false;
        }
        switch (columnIndex) {
            case 0: {
                return false;
            }
            case 1: {
                return !"ElementType".equals(metaData.getValueRole());
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public String getValueRole(int row, int column) {
        if (column != 1) {
            return null;
        }
        AttributeMetaData metaData = this.getMetaData(row);
        if (metaData == null) {
            return null;
        }
        return metaData.getValueRole();
    }

    @Override
    public String[] getExtraFields(int row, int column) {
        if (column == 0) {
            return EMPTY_FIELDS;
        }
        AttributeMetaData metaData = this.getMetaData(row);
        if (metaData == null) {
            return EMPTY_FIELDS;
        }
        return metaData.getExtraCalculationFields();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        AttributeMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return;
        }
        switch (columnIndex) {
            case 0: {
                return;
            }
            case 1: {
                if (!this.defineFullValue(metaData, aValue)) break;
                AttributeDataBackend db = (AttributeDataBackend)this.getDataBackend();
                ((AttributeDataBackend)db).fullValues[rowIndex] = null;
                this.fireTableDataChanged();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    private boolean defineFullValue(AttributeMetaData metaData, Object value) {
        if (value != null && !metaData.getTargetType().isInstance(value)) {
            logger.warn((Object)("Invalid type: " + value + " but expected " + metaData.getTargetType()));
            return false;
        }
        ReportDocumentContext reportRenderContext = this.getReportRenderContext();
        if (reportRenderContext == null) {
            throw new IllegalStateException("No report render context? Thats bad.");
        }
        UndoManager undo = reportRenderContext.getUndo();
        boolean changed = false;
        ReportElement[] elements = this.getAttributeDataBackend().getData();
        ArrayList<AttributeEditUndoEntry> undos = new ArrayList<AttributeEditUndoEntry>();
        for (int i = 0; i < elements.length; ++i) {
            ReportElement element = elements[i];
            Object attribute = element.getAttribute(metaData.getNameSpace(), metaData.getName());
            if (ObjectUtilities.equal((Object)attribute, (Object)value)) continue;
            undos.add(new AttributeEditUndoEntry(element.getObjectID(), metaData.getNameSpace(), metaData.getName(), attribute, value));
            element.setAttribute(metaData.getNameSpace(), metaData.getName(), value);
            changed = true;
        }
        undo.addChange(Messages.getString("AttributeTableModel.UndoName", new Object[0]), new CompoundUndoEntry(undos.toArray(new UndoEntry[undos.size()])));
        return changed;
    }

    private Object computeFullValue(AttributeMetaData metaData, int row) {
        AttributeDataBackend dataBackend = this.getAttributeDataBackend();
        Object[] fullValues = dataBackend.getFullValues();
        Object o = fullValues[row];
        if (o == NULL_INDICATOR) {
            return null;
        }
        if (o != null) {
            return o;
        }
        Object lastElement = null;
        ReportElement[] elements = dataBackend.getData();
        if (elements.length > 0) {
            ReportElement element = elements[0];
            lastElement = element.getAttribute(metaData.getNameSpace(), metaData.getName());
        }
        fullValues[row] = lastElement != null ? lastElement : NULL_INDICATOR;
        return lastElement;
    }

    public Class getClassForCell(int rowIndex, int columnIndex) {
        AttributeMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return GroupingHeader.class;
        }
        switch (columnIndex) {
            case 0: {
                return GroupedName.class;
            }
            case 1: {
                return metaData.getTargetType();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public PropertyEditor getEditorForCell(int rowIndex, int columnIndex) {
        AttributeMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return null;
            }
            case 1: {
                return this.computeEditor(metaData, rowIndex);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    private PropertyEditor computeEditor(AttributeMetaData metaData, int row) {
        Object[] propertyEditors = this.getAttributeDataBackend().getPropertyEditors();
        Object o = propertyEditors[row];
        if (o == NULL_INDICATOR) {
            return null;
        }
        if (o != null) {
            return (PropertyEditor)o;
        }
        PropertyEditor propertyEditor = metaData.getEditor();
        if (propertyEditor == null) {
            propertyEditor = this.getDefaultEditor(metaData.getTargetType(), metaData.getValueRole());
        }
        propertyEditors[row] = propertyEditor == null ? NULL_INDICATOR : propertyEditor;
        return propertyEditor;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return Messages.getString("AttributeTableModel.NameColumn", new Object[0]);
            }
            case 1: {
                return Messages.getString("AttributeTableModel.ValueColumn", new Object[0]);
            }
        }
        throw new IllegalArgumentException();
    }

    private static class AttributeDataBackend
    extends AbstractAttributeTableModel.DataBackend {
        private ReportElement[] elements;
        private Object[] fullValues;
        private Object[] propertyEditors;

        private AttributeDataBackend() {
            this.elements = EMPTY;
            this.propertyEditors = EMPTY_VALUES;
            this.fullValues = EMPTY_VALUES;
        }

        private AttributeDataBackend(AttributeMetaData[] metaData, GroupingHeader[] groupings, ReportElement[] elements) {
            super(metaData, groupings);
            this.elements = elements;
            this.fullValues = new Object[metaData.length];
            this.propertyEditors = new Object[metaData.length];
        }

        public ReportElement[] getData() {
            return (ReportElement[])this.elements.clone();
        }

        public Object[] getFullValues() {
            return this.fullValues;
        }

        public Object[] getPropertyEditors() {
            return this.propertyEditors;
        }

        @Override
        public void resetCache() {
            Arrays.fill(this.fullValues, null);
        }
    }
}

