/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.bundle;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.designtime.swing.event.DocumentChangeHandler;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.CommonFileChooser;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.FileChooserService;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;

public class ImportBundleFileDialog
extends CommonDialog {
    private JTextField fileNameField;
    private JComboBox mimeTypeBox;
    private JTextField entryNameField;
    private DocumentBundle bundle;

    public ImportBundleFileDialog(Dialog owner) throws HeadlessException {
        super(owner);
        ValidateHandler listener = new ValidateHandler();
        this.mimeTypeBox = new JComboBox();
        this.mimeTypeBox.setEditable(true);
        this.mimeTypeBox.addItem("text/plain");
        this.mimeTypeBox.addItem("text/xml");
        this.mimeTypeBox.addItem("image/jpeg");
        this.mimeTypeBox.addItem("image/png");
        this.mimeTypeBox.addItem("image/gif");
        this.mimeTypeBox.addItem("application/octet-stream");
        this.mimeTypeBox.setSelectedIndex(0);
        this.mimeTypeBox.addActionListener(listener);
        this.entryNameField = new JTextField();
        this.entryNameField.getDocument().addDocumentListener((DocumentListener)((Object)listener));
        this.fileNameField = new JTextField();
        this.fileNameField.getDocument().addDocumentListener((DocumentListener)((Object)listener));
        this.init();
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.ImportBundleFile";
    }

    protected Component createContentPane() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)new JLabel(Messages.getString("ImportBundleFileDialog.FileName", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        panel.add((Component)new JLabel(Messages.getString("ImportBundleFileDialog.EntryName", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        panel.add((Component)new JLabel(Messages.getString("ImportBundleFileDialog.ContentType", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        panel.add((Component)this.fileNameField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        panel.add((Component)this.entryNameField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        panel.add((Component)this.mimeTypeBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        panel.add((Component)new JButton(new BrowseAction()), gbc);
        return panel;
    }

    public boolean performCreateEntry(DocumentBundle bundle) {
        this.bundle = bundle;
        this.mimeTypeBox.setSelectedIndex(0);
        this.entryNameField.setText("");
        this.fileNameField.setText("");
        LibSwingUtil.centerDialogInParent((Dialog)((Object)this));
        return super.performEdit();
    }

    public String getMimeType() {
        return (String)this.mimeTypeBox.getSelectedItem();
    }

    public String getEntryName() {
        return this.entryNameField.getText();
    }

    public String getFileName() {
        return this.fileNameField.getText();
    }

    private class BrowseAction
    extends AbstractAction {
        private BrowseAction() {
            this.putValue("Name", "..");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileFilter[] filters = new FileFilter[]{new FilesystemFilter(".properties", Messages.getString("BundledResourceEditor.PropertiesTranslations", new Object[0])), new FilesystemFilter(new String[]{".xml", ".report", ".prpt", ".prpti", ".prptstyle"}, Messages.getString("BundledResourceEditor.Resources", new Object[0]), true), new FilesystemFilter(new String[]{".gif", ".jpg", ".jpeg", ".png", ".svg", ".wmf"}, Messages.getString("BundledResourceEditor.Images", new Object[0]), true)};
            CommonFileChooser fileChooser = FileChooserService.getInstance().getFileChooser("resources");
            fileChooser.setFilters(filters);
            if (!fileChooser.showDialog((Component)((Object)ImportBundleFileDialog.this), 0)) {
                return;
            }
            File selectedFile = fileChooser.getSelectedFile();
            if (selectedFile == null) {
                return;
            }
            ImportBundleFileDialog.this.fileNameField.setText(selectedFile.getPath());
        }
    }

    private class ValidateHandler
    extends DocumentChangeHandler
    implements ActionListener {
        private ValidateHandler() {
        }

        protected void handleChange(DocumentEvent e) {
            String s = ImportBundleFileDialog.this.entryNameField.getText();
            if (StringUtils.isEmpty((String)s)) {
                ImportBundleFileDialog.this.getConfirmAction().setEnabled(false);
                return;
            }
            if (StringUtils.isEmpty((String)((String)ImportBundleFileDialog.this.mimeTypeBox.getSelectedItem()))) {
                ImportBundleFileDialog.this.getConfirmAction().setEnabled(false);
                return;
            }
            ImportBundleFileDialog.this.getConfirmAction().setEnabled(!ImportBundleFileDialog.this.bundle.isEntryExists(s));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.handleChange(null);
        }
    }
}

