/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.crosstab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDataChangeListener;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.crosstab.CrosstabDetailTableModel;
import org.pentaho.reporting.designer.core.editor.crosstab.CrosstabDialogTransferHandler;
import org.pentaho.reporting.designer.core.editor.crosstab.CrosstabDimensionTableModel;
import org.pentaho.reporting.designer.core.editor.crosstab.CrosstabEditSupport;
import org.pentaho.reporting.designer.core.editor.crosstab.CrosstabOptionsPane;
import org.pentaho.reporting.designer.core.editor.crosstab.DraggableCrosstabDetailTable;
import org.pentaho.reporting.designer.core.editor.crosstab.DraggableCrosstabDimensionTable;
import org.pentaho.reporting.designer.core.editor.crosstab.DraggableJList;
import org.pentaho.reporting.designer.core.editor.crosstab.FieldListCellRenderer;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.elementfactory.CrosstabBuilder;
import org.pentaho.reporting.engine.classic.core.elementfactory.CrosstabDetail;
import org.pentaho.reporting.engine.classic.core.elementfactory.CrosstabDimension;
import org.pentaho.reporting.engine.classic.core.wizard.ContextAwareDataSchemaModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.designtime.swing.bulk.BulkDataProvider;
import org.pentaho.reporting.libraries.designtime.swing.bulk.DefaultBulkListModel;
import org.pentaho.reporting.libraries.designtime.swing.bulk.RemoveBulkAction;
import org.pentaho.reporting.libraries.designtime.swing.bulk.SortBulkDownAction;
import org.pentaho.reporting.libraries.designtime.swing.bulk.SortBulkUpAction;

public class CreateCrosstabDialog
extends CommonDialog
implements ReportDataChangeListener {
    private DraggableJList otherFields;
    private DraggableCrosstabDimensionTable rowFields;
    private DraggableCrosstabDimensionTable columnFields;
    private JTable detailFields;
    private FieldListCellRenderer fieldListCellRenderer;
    private DraggableJList availableFields;
    private DefaultBulkListModel availableFieldsModel;
    private DefaultBulkListModel otherFieldsModel;
    private CrosstabDimensionTableModel rowsFieldsModel;
    private CrosstabDimensionTableModel columnsFieldsModel;
    private CrosstabDetailTableModel detailFieldsModel;
    private CrosstabOptionsPane optionsPane;

    public CreateCrosstabDialog() {
        this.init();
    }

    public CreateCrosstabDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public CreateCrosstabDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    protected void init() {
        this.setTitle(Messages.getString("CreateCrosstabDialog.Title", new Object[0]));
        this.setModal(true);
        this.optionsPane = new CrosstabOptionsPane();
        this.fieldListCellRenderer = new FieldListCellRenderer();
        this.availableFieldsModel = new DefaultBulkListModel();
        this.availableFields = new DraggableJList(this.availableFieldsModel);
        this.availableFields.setTransferHandler(new CrosstabDialogTransferHandler(this.availableFields, true));
        this.availableFields.setCellRenderer(this.fieldListCellRenderer);
        this.otherFieldsModel = new DefaultBulkListModel();
        this.otherFields = new DraggableJList(this.otherFieldsModel);
        this.otherFields.setVisibleRowCount(3);
        this.otherFields.setCellRenderer(this.fieldListCellRenderer);
        this.rowsFieldsModel = new CrosstabDimensionTableModel();
        this.rowsFieldsModel.addTableModelListener(new MonitorMandatoryDimensionsHandler());
        this.rowFields = new DraggableCrosstabDimensionTable(this.rowsFieldsModel);
        this.columnsFieldsModel = new CrosstabDimensionTableModel();
        this.columnsFieldsModel.addTableModelListener(new MonitorMandatoryDimensionsHandler());
        this.columnFields = new DraggableCrosstabDimensionTable(this.columnsFieldsModel);
        this.detailFieldsModel = new CrosstabDetailTableModel();
        this.detailFields = new DraggableCrosstabDetailTable(this.detailFieldsModel);
        super.init();
    }

    protected void performInitialResize() {
        super.performInitialResize();
        if (this.getHeight() > 800) {
            this.setBounds(this.getX(), this.getY(), this.getWidth(), 800);
        }
        LibSwingUtil.centerDialogInParent((Dialog)((Object)this));
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.CreateCrosstab";
    }

    protected Component createContentPane() {
        JTabbedPane pane = new JTabbedPane();
        pane.addTab(Messages.getString("CreateCrosstabDialog.Fields", new Object[0]), this.createSelectionPane());
        pane.addTab(Messages.getString("CreateCrosstabDialog.Options", new Object[0]), this.optionsPane);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.createTitlePanel(), "North");
        contentPane.add((Component)pane, "Center");
        return contentPane;
    }

    private JPanel createTitlePanel() {
        JPanel titlePanel = new JPanel(new FlowLayout(0, 5, 5));
        titlePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        titlePanel.add(new JLabel(Messages.getString("CreateCrosstabDialog.TitleLabel", new Object[0])));
        return titlePanel;
    }

    private JComponent createSelectionPane() {
        JPanel sidePane = new JPanel();
        sidePane.setLayout(new BorderLayout());
        JLabel tablesColumnsLabel = new JLabel(Messages.getString("CreateCrosstabDialog.AvailableFields", new Object[0]));
        sidePane.add((Component)tablesColumnsLabel, "North");
        JScrollPane comp = new JScrollPane(this.availableFields, 20, 30);
        sidePane.add((Component)comp, "Center");
        JPanel tablesPane = new JPanel();
        tablesPane.setLayout(new GridBagLayout());
        this.addList(tablesPane, 0, this.otherFields, "CreateCrosstabDialog.OtherFields");
        this.addTable(tablesPane, 1, (JTable)((Object)this.rowFields), "CreateCrosstabDialog.RowFields", new AddDimensionAction(this.availableFields, this.rowsFieldsModel));
        this.addTable(tablesPane, 2, (JTable)((Object)this.columnFields), "CreateCrosstabDialog.ColumnsFields", new AddDimensionAction(this.availableFields, this.columnsFieldsModel));
        this.addTable(tablesPane, 3, this.detailFields, "CreateCrosstabDialog.Details", new AddDetailsAction(this.availableFields, this.detailFieldsModel));
        JSplitPane splitPane = new JSplitPane(1, sidePane, tablesPane);
        splitPane.setBorder(null);
        return splitPane;
    }

    private void addTable(JComponent tablesPane, int index, JTable list, String labelText, Action addAction) {
        BulkDataProvider bulkListModel = (BulkDataProvider)list.getModel();
        BorderlessButton otherAdd = new BorderlessButton(addAction);
        JLabel otherLabel = new JLabel(Messages.getString(labelText, new Object[0]));
        ListSelectionModel otherSelectionModel = list.getSelectionModel();
        BorderlessButton otherSortUp = new BorderlessButton((Action)new SortBulkUpAction(bulkListModel, otherSelectionModel));
        BorderlessButton otherSortDown = new BorderlessButton((Action)new SortBulkDownAction(bulkListModel, otherSelectionModel));
        BorderlessButton otherRemove = new BorderlessButton((Action)new RemoveBulkAction(bulkListModel, otherSelectionModel));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 2;
        gbc.gridy = index * 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add((Component)otherLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = index * 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add((Component)otherSortUp, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = index * 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add((Component)otherSortDown, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = index * 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add((Component)otherRemove, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1 + index * 2;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 4;
        gbc.insets = new Insets(0, 5, 5, 0);
        tablesPane.add((Component)new JScrollPane(list, 20, 30), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1 + index * 2;
        gbc.insets = new Insets(5, 5, 5, 0);
        tablesPane.add((Component)otherAdd, gbc);
    }

    private void addList(JComponent tablesPane, int index, JList list, String labelText) {
        DefaultBulkListModel bulkListModel = (DefaultBulkListModel)list.getModel();
        BorderlessButton otherAdd = new BorderlessButton((Action)new AddListSelectionAction(this.availableFields, bulkListModel));
        JLabel otherLabel = new JLabel(Messages.getString(labelText, new Object[0]));
        ListSelectionModel otherSelectionModel = list.getSelectionModel();
        BorderlessButton otherSortUp = new BorderlessButton((Action)new SortBulkUpAction((BulkDataProvider)bulkListModel, otherSelectionModel));
        BorderlessButton otherSortDown = new BorderlessButton((Action)new SortBulkDownAction((BulkDataProvider)bulkListModel, otherSelectionModel));
        BorderlessButton otherRemove = new BorderlessButton((Action)new RemoveBulkAction((BulkDataProvider)bulkListModel, otherSelectionModel));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 2;
        gbc.gridy = index * 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add((Component)otherLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = index * 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add((Component)otherSortUp, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = index * 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add((Component)otherSortDown, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = index * 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add((Component)otherRemove, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1 + index * 2;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 4;
        gbc.insets = new Insets(0, 5, 5, 0);
        tablesPane.add((Component)new JScrollPane(list, 20, 30), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1 + index * 2;
        gbc.insets = new Insets(5, 5, 5, 0);
        tablesPane.add((Component)otherAdd, gbc);
    }

    protected DefaultBulkListModel getAvailableFieldsModel() {
        return this.availableFieldsModel;
    }

    @Override
    public void dataModelChanged(ReportDocumentContext context) {
        ContextAwareDataSchemaModel dataSchemaModel = context.getReportDataSchemaModel();
        Object[] columnNames = this.filterDatabaseColumn(dataSchemaModel);
        DefaultBulkListModel availableFieldsModel = this.getAvailableFieldsModel();
        availableFieldsModel.setBulkData(columnNames);
        this.fieldListCellRenderer.setModel(context.getReportDataSchemaModel());
    }

    private String[] filterDatabaseColumn(ContextAwareDataSchemaModel dataSchemaModel) {
        ArrayList<String> fields = new ArrayList<String>();
        String[] columnNames = dataSchemaModel.getColumnNames();
        DataAttributeContext dac = dataSchemaModel.getDataAttributeContext();
        for (String columnName : columnNames) {
            DataAttributes attributes = dataSchemaModel.getDataSchema().getAttributes(columnName);
            Object sourceAttribute = attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "source", String.class, dac);
            if ("environment".equals(sourceAttribute) || "parameter".equals(sourceAttribute)) continue;
            fields.add(columnName);
        }
        return fields.toArray(new String[fields.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CrosstabGroup createCrosstab(ReportDesignerContext designerContext, CrosstabGroup editedGroup) {
        if (designerContext == null) {
            throw new NullPointerException();
        }
        ReportDocumentContext reportRenderContext = designerContext.getActiveContext();
        if (reportRenderContext == null) {
            throw new IllegalArgumentException();
        }
        this.optionsPane.setReportDesignerContext(designerContext);
        try {
            Object column;
            CrosstabBuilder originBuilder;
            if (editedGroup != null) {
                originBuilder = CrosstabEditSupport.populateBuilder(editedGroup, reportRenderContext.getReportDataSchemaModel());
                this.populateDialogFromBuilder(originBuilder);
                this.optionsPane.setValuesFromGroup(editedGroup);
            } else {
                originBuilder = new CrosstabBuilder(reportRenderContext.getReportDataSchemaModel());
            }
            reportRenderContext.addReportDataChangeListener(this);
            this.dataModelChanged(reportRenderContext);
            this.validateInputs(false);
            if (!this.performEdit()) {
                CrosstabGroup crosstabGroup = null;
                return crosstabGroup;
            }
            if (this.columnsFieldsModel.size() < 1) {
                CrosstabGroup crosstabGroup = null;
                return crosstabGroup;
            }
            if (this.rowsFieldsModel.size() < 1) {
                CrosstabGroup crosstabGroup = null;
                return crosstabGroup;
            }
            CrosstabBuilder builder = originBuilder.clearDimensions();
            this.configureBuilderFromOptions(builder);
            for (int i = 0; i < this.detailFieldsModel.size(); ++i) {
                CrosstabDetail crosstabDetail = this.detailFieldsModel.get(i);
                builder.addDetails(crosstabDetail.getField(), crosstabDetail.getAggregation());
            }
            for (int col = 0; col < this.columnsFieldsModel.size(); ++col) {
                column = this.columnsFieldsModel.get(col);
                builder.addColumnDimension(column);
            }
            for (int row = 0; row < this.rowsFieldsModel.size(); ++row) {
                CrosstabDimension rowDimension = this.rowsFieldsModel.get(row);
                builder.addRowDimension(rowDimension);
            }
            for (int other = 0; other < this.otherFieldsModel.size(); ++other) {
                column = (String)this.otherFieldsModel.get(other);
                builder.addOtherDimension((String)column);
            }
            CrosstabGroup crosstabGroup = builder.create();
            this.optionsPane.setValuesOnGroup(crosstabGroup);
            CrosstabGroup crosstabGroup2 = crosstabGroup;
            return crosstabGroup2;
        }
        finally {
            reportRenderContext.removeReportDataChangeListener(this);
            this.fieldListCellRenderer.setModel(null);
            this.optionsPane.setReportDesignerContext(null);
        }
    }

    protected boolean validateInputs(boolean onConfirm) {
        boolean retval = true;
        if (this.columnsFieldsModel.size() < 1) {
            retval = false;
        }
        if (this.rowsFieldsModel.size() < 1) {
            retval = false;
        }
        this.getConfirmAction().setEnabled(retval);
        return retval;
    }

    private void configureBuilderFromOptions(CrosstabBuilder builder) {
        builder.setGroupNamePrefix("Group ");
        this.optionsPane.configureCrosstabBuilder(builder);
    }

    private void populateDialogFromBuilder(CrosstabBuilder builder) {
        this.optionsPane.configureFromCrosstabBuilder(builder);
        for (String other : builder.getOthers()) {
            this.otherFieldsModel.addElement((Object)other);
        }
        for (CrosstabDimension d : builder.getRows()) {
            this.rowsFieldsModel.add(d);
        }
        for (CrosstabDimension d : builder.getColumns()) {
            this.columnsFieldsModel.add(d);
        }
        for (CrosstabDetail detail : builder.getDetails()) {
            this.detailFieldsModel.add(detail);
        }
    }

    private class MonitorMandatoryDimensionsHandler
    implements TableModelListener {
        private MonitorMandatoryDimensionsHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            CreateCrosstabDialog.this.validateInputs(false);
        }
    }

    private class AddDetailsAction
    extends AbstractAction
    implements ListSelectionListener {
        private ListSelectionModel selectionModel;
        private CrosstabDetailTableModel data;
        private ListModel fields;

        private AddDetailsAction(JList availableFields, CrosstabDetailTableModel data) {
            this.selectionModel = availableFields.getSelectionModel();
            this.fields = availableFields.getModel();
            this.data = data;
            this.putValue("SmallIcon", IconLoader.getInstance().getFowardArrowIcon());
            this.putValue("ShortDescription", Messages.getString("CreateCrosstabDialog.AddColumn", new Object[0]));
            this.selectionModel.addListSelectionListener(this);
            this.setEnabled(!this.selectionModel.isSelectionEmpty());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!this.selectionModel.isSelectionEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < this.fields.getSize(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                String item = (String)this.fields.getElementAt(i);
                this.data.add(new CrosstabDetail(item));
            }
        }
    }

    private class AddDimensionAction
    extends AbstractAction
    implements ListSelectionListener {
        private ListSelectionModel selectionModel;
        private CrosstabDimensionTableModel data;
        private ListModel fields;

        private AddDimensionAction(JList availableFields, CrosstabDimensionTableModel data) {
            this.selectionModel = availableFields.getSelectionModel();
            this.fields = availableFields.getModel();
            this.data = data;
            this.putValue("SmallIcon", IconLoader.getInstance().getFowardArrowIcon());
            this.putValue("ShortDescription", Messages.getString("CreateCrosstabDialog.AddColumn", new Object[0]));
            this.selectionModel.addListSelectionListener(this);
            this.setEnabled(!this.selectionModel.isSelectionEmpty());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!this.selectionModel.isSelectionEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < this.fields.getSize(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                String item = (String)this.fields.getElementAt(i);
                this.data.add(new CrosstabDimension(item));
            }
        }
    }

    private class AddListSelectionAction
    extends AbstractAction
    implements ListSelectionListener {
        private ListSelectionModel selectionModel;
        private DefaultListModel data;
        private ListModel fields;

        private AddListSelectionAction(JList availableFields, DefaultBulkListModel data) {
            this.selectionModel = availableFields.getSelectionModel();
            this.fields = availableFields.getModel();
            this.data = data;
            this.putValue("SmallIcon", IconLoader.getInstance().getFowardArrowIcon());
            this.putValue("ShortDescription", Messages.getString("CreateCrosstabDialog.AddColumn", new Object[0]));
            this.selectionModel.addListSelectionListener(this);
            this.setEnabled(!this.selectionModel.isSelectionEmpty());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!this.selectionModel.isSelectionEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < this.fields.getSize(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                this.data.addElement(this.fields.getElementAt(i));
            }
        }
    }
}

