/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.crosstab;

import java.awt.BorderLayout;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.crosstab.CrosstabOptionsTableModel;
import org.pentaho.reporting.designer.core.util.table.ElementMetaDataTable;
import org.pentaho.reporting.designer.core.util.table.GroupedMetaTableModel;
import org.pentaho.reporting.engine.classic.core.CrosstabDetailMode;
import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.elementfactory.CrosstabBuilder;
import org.pentaho.reporting.engine.classic.core.filter.types.AutoLayoutBoxType;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.CrosstabGroupType;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;

public class CrosstabOptionsPane
extends JComponent {
    private final ElementMetaDataTable metaDataTable;
    private CrosstabOptionsTableModel tableModel = this.createOptions();

    public CrosstabOptionsPane() {
        this.metaDataTable = new ElementMetaDataTable();
        this.metaDataTable.setModel(new GroupedMetaTableModel(this.tableModel));
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane(this.metaDataTable));
    }

    private CrosstabOptionsTableModel createOptions() {
        CrosstabOptionsTableModel crosstabOptionsTableModel = new CrosstabOptionsTableModel();
        crosstabOptionsTableModel.addAttributeOption(CrosstabGroupType.INSTANCE, "http://reporting.pentaho.org/namespaces/engine/attributes/crosstab", "detail-mode", CrosstabDetailMode.last);
        crosstabOptionsTableModel.addAttributeOption(CrosstabGroupType.INSTANCE, "http://reporting.pentaho.org/namespaces/engine/attributes/crosstab", "normalization-mode", null);
        crosstabOptionsTableModel.addAttributeOption(CrosstabGroupType.INSTANCE, "http://reporting.pentaho.org/namespaces/engine/attributes/crosstab", "print-detail-header", null);
        crosstabOptionsTableModel.addAttributeOption(CrosstabGroupType.INSTANCE, "http://reporting.pentaho.org/namespaces/engine/attributes/crosstab", "padding-fields", null);
        crosstabOptionsTableModel.addAttributeOption(AutoLayoutBoxType.INSTANCE, "http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-styling", null);
        crosstabOptionsTableModel.addAttributeOption(AutoLayoutBoxType.INSTANCE, "http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-attributes", null);
        crosstabOptionsTableModel.addStyleOption(AutoLayoutBoxType.INSTANCE, ElementStyleKeys.MIN_WIDTH, Float.valueOf(-100.0f));
        crosstabOptionsTableModel.addStyleOption(AutoLayoutBoxType.INSTANCE, ElementStyleKeys.MIN_HEIGHT, Float.valueOf(-100.0f));
        crosstabOptionsTableModel.addStyleOption(AutoLayoutBoxType.INSTANCE, ElementStyleKeys.WIDTH, null);
        crosstabOptionsTableModel.addStyleOption(AutoLayoutBoxType.INSTANCE, ElementStyleKeys.HEIGHT, null);
        crosstabOptionsTableModel.addStyleOption(AutoLayoutBoxType.INSTANCE, ElementStyleKeys.MAX_WIDTH, null);
        crosstabOptionsTableModel.addStyleOption(AutoLayoutBoxType.INSTANCE, ElementStyleKeys.MAX_HEIGHT, null);
        return crosstabOptionsTableModel;
    }

    public Float getMinWidth() {
        return (Float)this.tableModel.getStyleOption(AutoLayoutBoxType.INSTANCE, ElementStyleKeys.MIN_WIDTH);
    }

    public void setMinWidth(Float minWidth) {
        this.tableModel.setStyleOption(AutoLayoutBoxType.INSTANCE, ElementStyleKeys.MIN_WIDTH, minWidth);
    }

    public Float getMinHeight() {
        return (Float)this.tableModel.getStyleOption(AutoLayoutBoxType.INSTANCE, ElementStyleKeys.MIN_HEIGHT);
    }

    public void setMinHeight(Float minHeight) {
        this.tableModel.setStyleOption(AutoLayoutBoxType.INSTANCE, ElementStyleKeys.MIN_HEIGHT, minHeight);
    }

    public Float getPrefWidth() {
        return (Float)this.tableModel.getStyleOption(AutoLayoutBoxType.INSTANCE, ElementStyleKeys.WIDTH);
    }

    public void setPrefWidth(Float width) {
        this.tableModel.setStyleOption(AutoLayoutBoxType.INSTANCE, ElementStyleKeys.WIDTH, width);
    }

    public Float getPrefHeight() {
        return (Float)this.tableModel.getStyleOption(AutoLayoutBoxType.INSTANCE, ElementStyleKeys.HEIGHT);
    }

    public void setPrefHeight(Float height) {
        this.tableModel.setStyleOption(AutoLayoutBoxType.INSTANCE, ElementStyleKeys.HEIGHT, height);
    }

    public Float getMaxWidth() {
        return (Float)this.tableModel.getStyleOption(AutoLayoutBoxType.INSTANCE, ElementStyleKeys.MAX_WIDTH);
    }

    public void setMaxWidth(Float maxWidth) {
        this.tableModel.setStyleOption(AutoLayoutBoxType.INSTANCE, ElementStyleKeys.MAX_WIDTH, maxWidth);
    }

    public Float getMaxHeight() {
        return (Float)this.tableModel.getStyleOption(AutoLayoutBoxType.INSTANCE, ElementStyleKeys.MAX_HEIGHT);
    }

    public void setMaxHeight(Float maxHeight) {
        this.tableModel.setStyleOption(AutoLayoutBoxType.INSTANCE, ElementStyleKeys.MAX_HEIGHT, maxHeight);
    }

    public Boolean getAllowMetaDataStyling() {
        return (Boolean)this.tableModel.getAttributeOption(AutoLayoutBoxType.INSTANCE, "http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-styling");
    }

    public void setAllowMetaDataStyling(Boolean allowMetaDataStyling) {
        this.tableModel.setAttributeOption(AutoLayoutBoxType.INSTANCE, "http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-styling", allowMetaDataStyling);
    }

    public Boolean getAllowMetaDataAttributes() {
        return (Boolean)this.tableModel.getAttributeOption(AutoLayoutBoxType.INSTANCE, "http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-attributes");
    }

    public void setAllowMetaDataAttributes(Boolean allowMetaDataAttributes) {
        this.tableModel.setAttributeOption(AutoLayoutBoxType.INSTANCE, "http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-attributes", allowMetaDataAttributes);
    }

    public void setValuesFromGroup(CrosstabGroup crosstabGroup) {
        this.tableModel.copyFrom((ReportElement)crosstabGroup);
    }

    public void setValuesOnGroup(CrosstabGroup crosstabGroup) {
        this.tableModel.copyInto((ReportElement)crosstabGroup);
    }

    public void configureCrosstabBuilder(CrosstabBuilder builder) {
        builder.setMinimumWidth(this.getMinWidth());
        builder.setMinimumHeight(this.getMinHeight());
        builder.setPrefWidth(this.getPrefWidth());
        builder.setPrefHeight(this.getPrefHeight());
        builder.setMaximumWidth(this.getMaxWidth());
        builder.setMaximumHeight(this.getMaxHeight());
        builder.setAllowMetaDataAttributes(this.getAllowMetaDataAttributes());
        builder.setAllowMetaDataStyling(this.getAllowMetaDataStyling());
    }

    public void configureFromCrosstabBuilder(CrosstabBuilder builder) {
        if (builder.getMaximumHeight() != null) {
            this.setMaxHeight(builder.getMaximumHeight());
        }
        if (builder.getMaximumWidth() != null) {
            this.setMaxWidth(builder.getMaximumWidth());
        }
        if (builder.getPrefHeight() != null) {
            this.setPrefHeight(builder.getPrefHeight());
        }
        if (builder.getPrefWidth() != null) {
            this.setPrefWidth(builder.getPrefWidth());
        }
        if (builder.getMinimumHeight() != null) {
            this.setMinHeight(builder.getMinimumHeight());
        }
        if (builder.getMinimumWidth() != null) {
            this.setMinWidth(builder.getMinimumWidth());
        }
        if (builder.getAllowMetaDataAttributes() != null) {
            this.setAllowMetaDataAttributes(builder.getAllowMetaDataAttributes());
        }
        if (builder.getAllowMetaDataStyling() != null) {
            this.setAllowMetaDataStyling(builder.getAllowMetaDataStyling());
        }
    }

    public void setReportDesignerContext(ReportDesignerContext newContext) {
        this.metaDataTable.setReportDesignerContext(newContext);
    }

    public ReportDesignerContext getReportDesignerContext() {
        return this.metaDataTable.getReportDesignerContext();
    }
}

