/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.crosstab;

import java.awt.Component;
import javax.swing.JList;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.engine.classic.core.wizard.ContextAwareDataSchemaModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.FixDefaultListCellRenderer;

public class FieldListCellRenderer
extends FixDefaultListCellRenderer {
    private ContextAwareDataSchemaModel model;

    public void setModel(ContextAwareDataSchemaModel model) {
        this.model = model;
    }

    public ContextAwareDataSchemaModel getModel() {
        return this.model;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        this.setToolTipText(null);
        this.setIcon(IconLoader.getInstance().getEmptyIcon());
        if (this.model != null && value instanceof String) {
            String field = (String)value;
            DataAttributes attributes = this.model.getDataSchema().getAttributes(field);
            DataAttributeContext dac = this.model.getDataAttributeContext();
            if (attributes != null) {
                Class fieldClass = this.configureFieldType(attributes, dac);
                this.configureFieldText(field, fieldClass, attributes, dac);
                this.configureFieldIcon(attributes, dac);
            } else {
                this.setText(field);
            }
        }
        return this;
    }

    protected void configureFieldText(String fieldName, Class fieldClass, DataAttributes attributes, DataAttributeContext dac) {
        String displayName = (String)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/formatting", "label", String.class, dac);
        this.setText(this.formatFieldType(displayName, fieldName, fieldClass));
    }

    protected Class configureFieldType(DataAttributes attributes, DataAttributeContext dac) {
        Object metaAttribute = attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "value-type", Class.class, dac);
        if (metaAttribute instanceof Class) {
            Class fieldClass = (Class)metaAttribute;
            this.setToolTipText(fieldClass.getSimpleName());
            return fieldClass;
        }
        return Object.class;
    }

    protected void configureFieldIcon(DataAttributes attributes, DataAttributeContext dac) {
        Object source = attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "source", String.class, this.model.getDataAttributeContext());
        if ("environment".equals(source)) {
            this.setIcon(IconLoader.getInstance().getPropertiesDataSetIcon());
        } else if ("expression".equals(source)) {
            this.setIcon(IconLoader.getInstance().getFunctionIcon());
        } else if ("parameter".equals(source)) {
            this.setIcon(IconLoader.getInstance().getParameterIcon());
        } else if ("table".equals(source)) {
            this.setIcon(IconLoader.getInstance().getDataSetsIcon());
        } else {
            this.setIcon(IconLoader.getInstance().getBlankDocumentIcon());
        }
    }

    private String formatFieldType(String displayName, String fieldName, Class fieldClass) {
        if (displayName == null || ObjectUtilities.equal((Object)displayName, (Object)fieldName)) {
            if (fieldClass == null) {
                return fieldName;
            }
            return Messages.getString("FieldCellRenderer.TypedFieldMessage", fieldName, fieldClass.getSimpleName());
        }
        if (fieldClass == null) {
            return Messages.getString("FieldCellRenderer.TypedFieldMessage", displayName, fieldName);
        }
        return Messages.getString("FieldCellRenderer.AliasedTypedFieldMessage", displayName, fieldName, fieldClass.getSimpleName());
    }
}

